/*
 * Decompiled with CFR 0.152.
 */
package org.structr.common;

import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecurringDateHelper {
    private static final Logger logger = LoggerFactory.getLogger((String)RecurringDateHelper.class.getName());

    public static void main(String[] args) {
        String startTimeString = "14:30";
        String endTimeString = "17:00";
        Calendar cal = GregorianCalendar.getInstance();
        Date startDate = new Date();
        cal.setTime(startDate);
        cal.add(7, 20);
        Date endDate = cal.getTime();
        System.out.println("Start date: " + startDate);
        System.out.println("End date: " + endDate);
        List<Appointment> appointments = RecurringDateHelper.generateAppointments(startDate, endDate, "Mo,Di,Do,Fr,So", startTimeString, endTimeString);
        for (Appointment app : appointments) {
            System.out.println(app);
        }
    }

    public static List<Appointment> generateAppointments(Date startDate, Date endDate, String weekdays, String startTimeString, String endTimeString) {
        LinkedList<Appointment> appointments = new LinkedList<Appointment>();
        if (startDate == null || startDate.getTime() == 0L || endDate == null || endDate.getTime() == 0L || weekdays == null || weekdays.equals("") || startTimeString == null || startTimeString.equals("") || endTimeString == null || endTimeString.equals("")) {
            return appointments;
        }
        Object[] wd = StringUtils.split((String)weekdays, (String)",");
        Date start = RecurringDateHelper.dateFromDateAndTimeString(startDate, wd[0], startTimeString);
        Calendar cal = GregorianCalendar.getInstance();
        while (start.before(startDate) && start.before(endDate)) {
            cal.setTime(start);
            cal.add(7, 1);
            start = cal.getTime();
        }
        while (start.before(endDate)) {
            String shortWeekday = RecurringDateHelper.getShortWeekday(cal.get(7));
            if (ArrayUtils.contains((Object[])wd, (Object)shortWeekday)) {
                Date end = RecurringDateHelper.dateFromDateAndTimeString(start, shortWeekday, endTimeString);
                appointments.add(new Appointment(start, end));
            }
            cal.setTime(start);
            cal.add(7, 1);
            start = cal.getTime();
        }
        return appointments;
    }

    private static Date dateFromDateAndTimeString(Date date, String shortWeekday, String timeString) {
        String[] hourMinute = StringUtils.split((String)timeString, (String)":");
        Calendar cal = GregorianCalendar.getInstance();
        cal.setTime(date);
        cal.set(7, RecurringDateHelper.getDayOfWeek(shortWeekday));
        try {
            cal.set(11, Integer.parseInt(hourMinute[0]));
            cal.set(12, Integer.parseInt(hourMinute[1]));
        }
        catch (Throwable t) {
            logger.warn("Unable to parse time from string {}", (Object)timeString);
        }
        cal.set(13, 0);
        return cal.getTime();
    }

    private static int getDayOfWeek(String shortWeekday) {
        if (shortWeekday != null && !shortWeekday.equals("")) {
            try {
                ShortWeekday wd = ShortWeekday.valueOf(shortWeekday);
                switch (wd) {
                    case Mo: {
                        return 2;
                    }
                    case Di: {
                        return 3;
                    }
                    case Mi: {
                        return 4;
                    }
                    case Do: {
                        return 5;
                    }
                    case Fr: {
                        return 6;
                    }
                    case Sa: {
                        return 7;
                    }
                    case So: {
                        return 1;
                    }
                }
            }
            catch (Throwable t) {
                logger.warn("Unable to parse day of week for string {}", (Object)shortWeekday);
            }
        }
        return 0;
    }

    private static String getShortWeekday(int wd) {
        switch (wd) {
            case 2: {
                return ShortWeekday.Mo.name();
            }
            case 3: {
                return ShortWeekday.Di.name();
            }
            case 4: {
                return ShortWeekday.Mi.name();
            }
            case 5: {
                return ShortWeekday.Do.name();
            }
            case 6: {
                return ShortWeekday.Fr.name();
            }
            case 7: {
                return ShortWeekday.Sa.name();
            }
            case 1: {
                return ShortWeekday.So.name();
            }
        }
        return "";
    }

    public static class Appointment {
        public Date startDate;
        public Date endDate;

        public Appointment(Date startDate, Date endDate) {
            this.startDate = startDate;
            this.endDate = endDate;
        }

        public String toString() {
            return this.startDate + " - " + this.endDate;
        }
    }

    private static enum ShortWeekday {
        Mo,
        Di,
        Mi,
        Do,
        Fr,
        Sa,
        So;

    }
}

