/*
 * Decompiled with CFR 0.152.
 */
package org.structr.common;

import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.LocaleUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.common.AccessControllable;
import org.structr.common.AccessMode;
import org.structr.common.Permission;
import org.structr.common.QueryRange;
import org.structr.core.GraphObject;
import org.structr.core.Services;
import org.structr.core.auth.Authenticator;
import org.structr.core.entity.AbstractNode;
import org.structr.core.entity.Principal;
import org.structr.core.entity.SuperUser;
import org.structr.core.graph.NodeInterface;
import org.structr.schema.SchemaHelper;

public class SecurityContext {
    public static final String LOCALE_KEY = "locale";
    private static final Logger logger = LoggerFactory.getLogger((String)SecurityContext.class.getName());
    private static final Map<String, Long> resourceFlags = new ConcurrentHashMap<String, Long>();
    private static final Pattern customViewPattern = Pattern.compile(".*properties=([a-zA-Z_,]+)");
    private boolean doTransactionNotifications = true;
    private boolean dontModifyAccessTime = false;
    private boolean ignoreResultCount = false;
    private int serializationDepth = -1;
    private final Map<String, QueryRange> ranges = new ConcurrentHashMap<String, QueryRange>();
    private final Map<String, Object> attrs = new ConcurrentHashMap<String, Object>();
    private AccessMode accessMode = AccessMode.Frontend;
    private Authenticator authenticator = null;
    private Principal cachedUser = null;
    private HttpServletRequest request = null;
    private HttpServletResponse response = null;
    private Set<String> customView = null;
    private String cachedUserName = null;
    private String cachedUserId = null;
    private String sessionId = null;

    private SecurityContext() {
    }

    private SecurityContext(Principal user, AccessMode accessMode) {
        this.cachedUser = user;
        this.accessMode = accessMode;
    }

    private SecurityContext(Principal user, HttpServletRequest request, AccessMode accessMode) {
        this(request);
        this.cachedUser = user;
        this.accessMode = accessMode;
    }

    private SecurityContext(HttpServletRequest request) {
        this.request = request;
        this.initializeCustomView(request);
        this.initializeQueryRanges(request);
        this.initializeHttpParameters(request);
    }

    private void initializeHttpParameters(HttpServletRequest request) {
        if (request != null) {
            if ("disabled".equals(request.getHeader("Structr-Websocket-Broadcast"))) {
                this.doTransactionNotifications = false;
            }
            if (request.getParameter("ignoreResultCount") != null) {
                this.ignoreResultCount = true;
            }
        }
    }

    private void initializeCustomView(HttpServletRequest request) {
        if (request != null) {
            try {
                Matcher matcher;
                String acceptedContentType = request.getHeader("Accept");
                if (acceptedContentType != null && acceptedContentType.startsWith("application/json") && (matcher = customViewPattern.matcher(acceptedContentType)).matches()) {
                    String[] parts;
                    this.customView = new LinkedHashSet<String>();
                    String properties = matcher.group(1);
                    for (String part : parts = properties.split("[,]+")) {
                        String p = part.trim();
                        if (p.length() <= 0) continue;
                        this.customView.add(p);
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private void initializeQueryRanges(HttpServletRequest request) {
        String rangeSource;
        if (request != null && (rangeSource = request.getHeader("Range")) != null) {
            String[] rangeParts = rangeSource.split("[;]+");
            int rangeCount = rangeParts.length;
            for (int i = 0; i < rangeCount; ++i) {
                String[] parts = rangeParts[i].split("[=]+");
                if (parts.length != 2) continue;
                String identifier = parts[0].trim();
                String valueRange = parts[1].trim();
                if (!StringUtils.isNotBlank((CharSequence)identifier) || !StringUtils.isNotBlank((CharSequence)valueRange)) continue;
                if (valueRange.contains(",")) {
                    logger.warn("Unsupported Range header specification {}, multiple ranges are not supported.", (Object)valueRange);
                    continue;
                }
                String[] valueParts = valueRange.split("[-]+");
                if (valueParts.length != 2) continue;
                String startString = valueParts[0].trim();
                String endString = valueParts[1].trim();
                if (endString.contains("/")) {
                    endString = endString.substring(0, endString.indexOf("/"));
                }
                try {
                    int start = Integer.parseInt(startString);
                    int end = Integer.parseInt(endString);
                    this.ranges.put(identifier, new QueryRange(start, end));
                    continue;
                }
                catch (Throwable t) {
                    logger.warn("", t);
                }
            }
        }
    }

    public static void clearResourceFlag(String resource, long flag) {
        String name = SchemaHelper.normalizeEntityName(resource);
        Long flagObject = resourceFlags.get(name);
        long flags = 0L;
        if (flagObject != null) {
            flags = flagObject;
        }
        resourceFlags.put(name, flags &= flag ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public void removeForbiddenNodes(List<? extends GraphObject> nodes, boolean includeDeletedAndHidden, boolean publicOnly) {
        boolean readableByUser = false;
        Iterator<? extends GraphObject> it = nodes.iterator();
        while (it.hasNext()) {
            AbstractNode n;
            GraphObject obj = it.next();
            if (!(obj instanceof AbstractNode) || (readableByUser = (n = (AbstractNode)obj).isGranted(Permission.read, this)) && (includeDeletedAndHidden || !n.isDeleted()) && (n.isVisibleToPublicUsers() || !publicOnly)) continue;
            it.remove();
        }
    }

    public static SecurityContext getSuperUserInstance(HttpServletRequest request) {
        return new SuperUserSecurityContext(request);
    }

    public static SecurityContext getSuperUserInstance() {
        return new SuperUserSecurityContext();
    }

    public static SecurityContext getInstance(Principal user, AccessMode accessMode) {
        return new SecurityContext(user, accessMode);
    }

    public static SecurityContext getInstance(Principal user, HttpServletRequest request, AccessMode accessMode) {
        return new SecurityContext(user, request, accessMode);
    }

    public HttpSession getSession() {
        if (this.request != null) {
            HttpSession session = this.request.getSession(false);
            if (session != null) {
                session.setMaxInactiveInterval(Services.getGlobalSessionTimeout());
            }
            return session;
        }
        return null;
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public HttpServletResponse getResponse() {
        return this.response;
    }

    public String getCachedUserId() {
        return this.cachedUserId;
    }

    public String getCachedUserName() {
        return this.cachedUserName;
    }

    public Principal getCachedUser() {
        return this.cachedUser;
    }

    public void setCachedUser(Principal user) {
        this.cachedUser = user;
        this.cachedUserId = user.getUuid();
        this.cachedUserName = user.getName();
    }

    public Principal getUser(boolean tryLogin) {
        if (this.cachedUser != null) {
            if (this.cachedUserId == null) {
                this.cachedUserId = this.cachedUser.getUuid();
            }
            if (this.cachedUserName == null) {
                this.cachedUserName = this.cachedUser.getName();
            }
            return this.cachedUser;
        }
        if (this.authenticator == null) {
            return null;
        }
        if (this.authenticator.hasExaminedRequest()) {
            return null;
        }
        try {
            this.cachedUser = this.authenticator.getUser(this.request, tryLogin);
            if (this.cachedUser != null) {
                this.cachedUserId = this.cachedUser.getUuid();
                this.cachedUserName = this.cachedUser.getName();
            }
        }
        catch (Throwable t) {
            logger.warn("No user found");
        }
        return this.cachedUser;
    }

    public AccessMode getAccessMode() {
        return this.accessMode;
    }

    public boolean hasParameter(String name) {
        return this.request != null && this.request.getParameter(name) != null;
    }

    public StringBuilder getBaseURI() {
        StringBuilder uriBuilder = new StringBuilder(200);
        uriBuilder.append(this.request.getScheme());
        uriBuilder.append("://");
        uriBuilder.append(this.request.getServerName());
        uriBuilder.append(":");
        uriBuilder.append(this.request.getServerPort());
        uriBuilder.append(this.request.getContextPath());
        uriBuilder.append(this.request.getServletPath());
        uriBuilder.append("/");
        return uriBuilder;
    }

    public Object getAttribute(String key) {
        return this.attrs.get(key);
    }

    public static long getResourceFlags(String resource) {
        String name = SchemaHelper.normalizeEntityName(resource);
        Long flagObject = resourceFlags.get(name);
        long flags = 0L;
        if (flagObject != null) {
            flags = flagObject;
        } else {
            logger.debug("No resource flag set for {}", (Object)resource);
        }
        return flags;
    }

    public static boolean hasFlag(String resourceSignature, long flag) {
        return (SecurityContext.getResourceFlags(resourceSignature) & flag) == flag;
    }

    public boolean isSuperUser() {
        Principal user = this.getUser(false);
        return user != null && (user instanceof SuperUser || user.getProperty(Principal.isAdmin) != false);
    }

    public boolean isVisible(AccessControllable node) {
        switch (this.accessMode) {
            case Backend: {
                return this.isVisibleInBackend(node);
            }
            case Frontend: {
                return this.isVisibleInFrontend(node);
            }
        }
        return false;
    }

    public boolean isReadable(NodeInterface node, boolean includeDeletedAndHidden, boolean publicOnly) {
        if ((node.isDeleted() || node.isHidden()) && !includeDeletedAndHidden) {
            return false;
        }
        if (node.isVisibleToPublicUsers()) {
            return true;
        }
        if (publicOnly) {
            return false;
        }
        if (node.isVisibleToAuthenticatedUsers() && this.getUser(false) != null) {
            return true;
        }
        return node.isGranted(Permission.read, this);
    }

    private boolean isVisibleInBackend(AccessControllable node) {
        if (this.isVisibleInFrontend(node)) {
            return true;
        }
        if (node == null) {
            return false;
        }
        Principal user = this.getUser(false);
        if (user == null) {
            return false;
        }
        if (user instanceof SuperUser) {
            return true;
        }
        return node.isGranted(Permission.read, this);
    }

    private boolean isVisibleInFrontend(AccessControllable node) {
        if (node == null) {
            return false;
        }
        if (node.isHidden()) {
            return false;
        }
        Principal user = this.getUser(false);
        if (user != null) {
            Principal owner = node.getOwnerNode();
            if (user.equals(node) || user.equals(owner) || user.getParents().contains(owner)) {
                return true;
            }
        }
        if (node.isVisibleToPublicUsers() && user == null) {
            return true;
        }
        if (node.isVisibleToAuthenticatedUsers() && user != null) {
            return true;
        }
        return node.isGranted(Permission.read, this);
    }

    public void setRequest(HttpServletRequest request) {
        this.request = request;
    }

    public void setResponse(HttpServletResponse response) {
        this.response = response;
    }

    public static void setResourceFlag(String resource, long flag) {
        String name = SchemaHelper.normalizeEntityName(resource);
        Long flagObject = resourceFlags.get(name);
        long flags = 0L;
        if (flagObject != null) {
            flags = flagObject;
        }
        resourceFlags.put(name, flags |= flag);
    }

    public void setAttribute(String key, Object value) {
        this.attrs.put(key, value);
    }

    public void setAccessMode(AccessMode accessMode) {
        this.accessMode = accessMode;
    }

    public void clearCustomView() {
        this.customView = new LinkedHashSet<String>();
    }

    public void setCustomView(String ... properties) {
        this.customView = new LinkedHashSet<String>();
        for (String prop : properties) {
            this.customView.add(prop);
        }
    }

    public void setCustomView(Set<String> properties) {
        this.customView = properties;
    }

    public Authenticator getAuthenticator() {
        return this.authenticator;
    }

    public void setAuthenticator(Authenticator authenticator) {
        this.authenticator = authenticator;
    }

    public boolean hasCustomView() {
        return this.customView != null && !this.customView.isEmpty();
    }

    public Set<String> getCustomView() {
        return this.customView;
    }

    public QueryRange getRange(String key) {
        return this.ranges.get(key);
    }

    public Locale getEffectiveLocale() {
        String userLocaleString;
        Locale locale = Locale.getDefault();
        boolean userHasLocaleString = false;
        if (this.cachedUser != null && (userLocaleString = this.cachedUser.getProperty(Principal.locale)) != null) {
            userHasLocaleString = true;
            try {
                locale = LocaleUtils.toLocale((String)userLocaleString);
            }
            catch (IllegalArgumentException e) {
                locale = Locale.forLanguageTag(userLocaleString);
            }
        }
        if (this.request != null) {
            String requestedLocaleString;
            if (!userHasLocaleString) {
                locale = this.request.getLocale();
                Cookie[] cookies = this.request.getCookies();
                if (cookies != null) {
                    for (Cookie c : cookies) {
                        if (!c.getName().equals(LOCALE_KEY)) continue;
                        String cookieLocaleString = c.getValue();
                        try {
                            locale = LocaleUtils.toLocale((String)cookieLocaleString);
                        }
                        catch (IllegalArgumentException e) {
                            locale = Locale.forLanguageTag(cookieLocaleString);
                        }
                    }
                }
            }
            if (StringUtils.isNotBlank((CharSequence)(requestedLocaleString = this.request.getParameter(LOCALE_KEY)))) {
                try {
                    locale = LocaleUtils.toLocale((String)requestedLocaleString);
                }
                catch (IllegalArgumentException e) {
                    locale = Locale.forLanguageTag(requestedLocaleString);
                }
            }
        }
        return locale;
    }

    public String getCompoundRequestURI() {
        if (this.request != null) {
            if (this.request.getQueryString() != null) {
                return this.request.getRequestURI().concat("?").concat(this.request.getQueryString());
            }
            return this.request.getRequestURI();
        }
        return "[No request available]";
    }

    public boolean isDoTransactionNotifications() {
        return this.doTransactionNotifications;
    }

    public void setDoTransactionNotifications(boolean doTransactionNotifications) {
        this.doTransactionNotifications = doTransactionNotifications;
    }

    public boolean dontModifyAccessTime() {
        return this.dontModifyAccessTime;
    }

    public void preventModificationOfAccessTime() {
        this.dontModifyAccessTime = true;
    }

    public void enableModificationOfAccessTime() {
        this.dontModifyAccessTime = false;
    }

    public void ignoreResultCount(boolean doIgnore) {
        this.ignoreResultCount = doIgnore;
    }

    public boolean ignoreResultCount() {
        return this.ignoreResultCount;
    }

    public String getSessionId() {
        if (this.getRequest() != null && this.getRequest().getSession() != null && this.getRequest().getSession().getId() != null) {
            return this.getRequest().getSession().getId();
        }
        return this.sessionId;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    public void setSerializationDepth(int depth) {
        this.serializationDepth = depth;
    }

    public int getSerializationDepth() {
        return this.serializationDepth;
    }

    private static class SuperUserSecurityContext
    extends SecurityContext {
        private static final SuperUser superUser = new SuperUser();

        public SuperUserSecurityContext(HttpServletRequest request) {
            super(request);
        }

        public SuperUserSecurityContext() {
        }

        @Override
        public Principal getUser(boolean tryLogin) {
            return new SuperUser();
        }

        @Override
        public Principal getCachedUser() {
            return superUser;
        }

        @Override
        public String getCachedUserId() {
            return "00000000000000000000000000000000";
        }

        @Override
        public String getCachedUserName() {
            return "superadmin";
        }

        @Override
        public AccessMode getAccessMode() {
            return AccessMode.Backend;
        }

        @Override
        public boolean isReadable(NodeInterface node, boolean includeDeletedAndHidden, boolean publicOnly) {
            return true;
        }

        @Override
        public boolean isVisible(AccessControllable node) {
            return true;
        }

        @Override
        public boolean isSuperUser() {
            return true;
        }
    }
}

