/*
 * Decompiled with CFR 0.152.
 */
package org.structr.common;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.structr.api.graph.PropertyContainer;
import org.structr.common.Permission;
import org.structr.core.GraphObject;
import org.structr.core.property.PropertyKey;

public class SecurityDelegate {
    public static boolean isAllowed(GraphObject graphObject, PropertyKey<String[]> key, Permission permission) {
        return SecurityDelegate.getPermissions(graphObject, key).contains(permission.name());
    }

    public static void setAllowed(GraphObject graphObject, PropertyKey<String[]> key, Set<String> allowed) {
        String[] permissions = allowed.toArray(new String[allowed.size()]);
        SecurityDelegate.setAllowed(graphObject, key, permissions);
    }

    public static void setAllowed(GraphObject graphObject, PropertyKey<String[]> key, Permission ... permissions) {
        HashSet<String> permissionSet = new HashSet<String>();
        for (Permission permission : permissions) {
            permissionSet.add(permission.name());
        }
        SecurityDelegate.setAllowed(graphObject, key, permissionSet);
    }

    public static void setAllowed(GraphObject graphObject, PropertyKey<String[]> key, String[] allowed) {
        PropertyContainer propertyContainer = graphObject.getPropertyContainer();
        propertyContainer.setProperty(key.dbName(), (Object)allowed);
    }

    public static Set<String> getPermissions(GraphObject graphObject, PropertyKey<String[]> key) {
        PropertyContainer propertyContainer = graphObject.getPropertyContainer();
        return SecurityDelegate.getPermissionSet(propertyContainer, key);
    }

    public static void addPermission(GraphObject graphObject, PropertyKey<String[]> key, Permission permission) {
        Set<String> permissionSet = SecurityDelegate.getPermissions(graphObject, key);
        if (permissionSet.contains(permission.name())) {
            return;
        }
        permissionSet.add(permission.name());
        SecurityDelegate.setAllowed(graphObject, key, permissionSet);
    }

    public static void removePermission(GraphObject graphObject, PropertyKey<String[]> key, Permission permission) {
        Set<String> permissionSet = SecurityDelegate.getPermissions(graphObject, key);
        if (!permissionSet.contains(permission.name())) {
            return;
        }
        permissionSet.remove(permission.name());
        SecurityDelegate.setAllowed(graphObject, key, permissionSet);
    }

    public static Set<String> getPermissionSet(PropertyContainer propertyContainer, PropertyKey<String[]> key) {
        String[] permissions;
        HashSet<String> permissionSet = new HashSet<String>();
        if (propertyContainer.hasProperty(key.dbName()) && (permissions = (String[])propertyContainer.getProperty(key.dbName())) != null) {
            permissionSet.addAll(Arrays.asList(permissions));
        }
        return permissionSet;
    }
}

