/*
 * Decompiled with CFR 0.152.
 */
package org.structr.common;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.structr.api.config.Settings;
import org.structr.core.Services;
import org.structr.core.app.StructrApp;
import org.structr.module.StructrModule;

public class VersionHelper {
    private static final String classPath;
    private static final String instanceName;
    private static final String instanceStage;
    private static final Map<String, Map<String, Object>> modules;
    private static final Map<String, Map<String, String>> components;
    private static boolean modulesUpdatedAfterSystemInitComplete;

    public static String getFullVersionInfo() {
        Map<String, String> structrUiModule = VersionHelper.getComponents().get("structr-ui");
        if (structrUiModule != null) {
            return structrUiModule.get("version") + " " + structrUiModule.get("build") + " " + structrUiModule.get("date");
        }
        return "Could not determine version string";
    }

    public static String getClassPath() {
        return classPath;
    }

    public static String getInstanceName() {
        return instanceName;
    }

    public static String getInstanceStage() {
        return instanceStage;
    }

    public static void updateModuleList() {
        modules.clear();
        for (StructrModule module : StructrApp.getConfiguration().getModules().values()) {
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            map.put("source", module.getClass().getProtectionDomain().getCodeSource().getLocation().getPath());
            if (module.getDependencies() != null) {
                map.put("dependencies", module.getDependencies());
            }
            if (module.getFeatures() != null) {
                map.put("features", module.getFeatures());
            }
            modules.put(module.getName(), map);
        }
    }

    public static Map<String, Map<String, Object>> getModules() {
        if (!modulesUpdatedAfterSystemInitComplete) {
            VersionHelper.updateModuleList();
        }
        modulesUpdatedAfterSystemInitComplete = Services.getInstance().isInitialized();
        return modules;
    }

    public static Map<String, Map<String, String>> getComponents() {
        return components;
    }

    static {
        modules = new HashMap<String, Map<String, Object>>();
        components = new HashMap<String, Map<String, String>>();
        modulesUpdatedAfterSystemInitComplete = false;
        classPath = System.getProperty("java.class.path");
        instanceName = (String)Settings.InstanceName.getValue();
        instanceStage = (String)Settings.InstanceStage.getValue();
        Pattern outerPattern = Pattern.compile("(structr-.+?(?=.jar))");
        Matcher outerMatcher = outerPattern.matcher(classPath);
        while (outerMatcher.find()) {
            String group = outerMatcher.group();
            Pattern innerPattern = Pattern.compile("(structr-core|structr-rest|structr-ui)-([^-]*(?:-SNAPSHOT){0,1})-{0,1}(?:([0-9]{0,12})\\.{0,1}([0-9a-f]{0,5})).*");
            Matcher innerMatcher = innerPattern.matcher(group);
            HashMap<String, String> module = new HashMap<String, String>();
            if (!innerMatcher.matches()) continue;
            module.put("version", innerMatcher.group(2));
            module.put("date", innerMatcher.group(3));
            module.put("build", innerMatcher.group(4));
            components.put(innerMatcher.group(1), module);
        }
    }
}

