/*
 * Decompiled with CFR 0.152.
 */
package org.structr.common.error;

import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;

public abstract class ErrorToken {
    private String property = null;
    private String type = null;
    private Object detail = null;
    private String token = null;
    private Object value = null;

    public ErrorToken(String type, String property, String token, Object detail) {
        this.type = type;
        this.property = property;
        this.token = token;
        this.detail = detail;
    }

    public String getProperty() {
        return this.property;
    }

    public String getType() {
        return this.type;
    }

    public String getToken() {
        return this.token;
    }

    public Object getDetail() {
        return this.detail;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public JsonObject toJSON() {
        JsonObject token = new JsonObject();
        token.add("type", this.getStringOrNull(this.getType()));
        token.add("property", this.getStringOrNull(this.getProperty()));
        token.add("token", this.getStringOrNull(this.getToken()));
        this.addIfNonNull(token, "detail", this.getObjectOrNull(this.getDetail()));
        this.addIfNonNull(token, "value", this.getObjectOrNull(this.getValue()));
        return token;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        if (this.type != null) {
            buf.append(this.type);
        }
        if (this.property != null) {
            buf.append(".");
            buf.append(this.property);
        }
        if (this.token != null) {
            buf.append(" ");
            buf.append(this.token);
        }
        if (this.detail != null) {
            buf.append(" ");
            buf.append(this.detail);
        }
        return buf.toString();
    }

    protected void addIfNonNull(JsonObject obj, String key, JsonElement value) {
        if (value != null && !JsonNull.INSTANCE.equals((Object)value)) {
            obj.add(key, value);
        }
    }

    protected JsonElement getStringOrNull(String source) {
        if (source != null) {
            return new JsonPrimitive(source);
        }
        return JsonNull.INSTANCE;
    }

    protected JsonElement getObjectOrNull(Object source) {
        if (source != null) {
            if (source instanceof String) {
                return new JsonPrimitive((String)source);
            }
            if (source instanceof Number) {
                return new JsonPrimitive((Number)source);
            }
            if (source instanceof Boolean) {
                return new JsonPrimitive((Boolean)source);
            }
            return new JsonPrimitive(source.toString());
        }
        return JsonNull.INSTANCE;
    }
}

