/*
 * Decompiled with CFR 0.152.
 */
package org.structr.common.geo;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Map;
import org.apache.commons.jxpath.JXPathContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.api.config.Settings;
import org.structr.common.geo.GeoCodingProvider;

public abstract class AbstractGeoCodingProvider
implements GeoCodingProvider {
    private static final Logger logger = LoggerFactory.getLogger((String)AbstractGeoCodingProvider.class.getName());
    protected String apiKey = (String)Settings.GeocodingApiKey.getValue();

    protected <T> T extract(Map source, String path, Class<T> type) {
        JXPathContext context = JXPathContext.newContext((Object)source);
        Object value = context.getValue(path);
        return (T)value;
    }

    protected String encodeURL(String source) {
        try {
            return URLEncoder.encode(source, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            logger.warn("Unsupported Encoding", (Throwable)ex);
            return source;
        }
    }
}

