/*
 * Decompiled with CFR 0.152.
 */
package org.structr.common.geo;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.collections.map.LRUMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.api.config.Settings;
import org.structr.common.error.FrameworkException;
import org.structr.common.geo.GeoCodingProvider;
import org.structr.common.geo.GeoCodingResult;
import org.structr.core.app.StructrApp;
import org.structr.core.entity.AbstractNode;
import org.structr.core.entity.Location;
import org.structr.core.graph.search.DistanceSearchAttribute;
import org.structr.core.property.PropertyMap;

public class GeoHelper {
    private static final Logger logger = LoggerFactory.getLogger((String)GeoHelper.class.getName());
    private static final Map<String, GeoCodingResult> geoCache = Collections.synchronizedMap(new LRUMap(10000));
    private static Class<GeoCodingProvider> providerClass = null;
    private static GeoCodingProvider providerInstance = null;

    public static Location createLocation(GeoCodingResult coords) throws FrameworkException {
        PropertyMap props = new PropertyMap();
        double latitude = coords.getLatitude();
        double longitude = coords.getLongitude();
        String type = Location.class.getSimpleName();
        props.put(AbstractNode.type, type);
        props.put(Location.latitude, latitude);
        props.put(Location.longitude, longitude);
        return StructrApp.getInstance().create(Location.class, props);
    }

    public static GeoCodingResult geocode(DistanceSearchAttribute distanceSearch) throws FrameworkException {
        String street = distanceSearch.getStreet();
        String house = distanceSearch.getHouse();
        String postalCode = distanceSearch.getPostalCode();
        String city = distanceSearch.getCity();
        String state = distanceSearch.getState();
        String country = distanceSearch.getCountry();
        return GeoHelper.geocode(street, house, postalCode, city, state, country);
    }

    public static GeoCodingResult geocode(String street, String house, String postalCode, String city, String state, String country) throws FrameworkException {
        GeoCodingProvider provider;
        String language = (String)Settings.GeocodingLanguage.getValue();
        String cacheKey = GeoHelper.cacheKey(street, house, postalCode, city, state, country, language);
        GeoCodingResult result = geoCache.get(cacheKey);
        if (result == null && (provider = GeoHelper.getGeoCodingProvider()) != null) {
            try {
                result = provider.geocode(street, house, postalCode, city, state, country, language);
                if (result != null) {
                    geoCache.put(cacheKey, result);
                }
            }
            catch (IOException ioex) {
                logger.warn("Unable to obtain geocoding result using provider {}: {}", new Object[]{provider.getClass().getName(), ioex.getMessage()});
            }
        }
        return result;
    }

    private static String cacheKey(String street, String house, String postalCode, String city, String state, String country, String language) {
        StringBuilder keyBuffer = new StringBuilder();
        if (street != null) {
            keyBuffer.append(street);
        }
        if (house != null) {
            keyBuffer.append(house);
        }
        if (postalCode != null) {
            keyBuffer.append(postalCode);
        }
        if (city != null) {
            keyBuffer.append(city);
        }
        if (state != null) {
            keyBuffer.append(state);
        }
        if (country != null) {
            keyBuffer.append(country);
        }
        if (language != null) {
            keyBuffer.append(language);
        }
        return keyBuffer.toString();
    }

    private static GeoCodingProvider getGeoCodingProvider() {
        if (providerInstance == null) {
            try {
                if (providerClass == null) {
                    providerClass = Class.forName((String)Settings.GeocodingProvider.getValue());
                }
                providerInstance = providerClass.newInstance();
            }
            catch (Throwable t) {
                logger.warn("Unable to instantiate geocoding provider: {}", (Object)t.getMessage());
            }
        }
        return providerInstance;
    }
}

