/*
 * Decompiled with CFR 0.152.
 */
package org.structr.common.geo;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.common.geo.AbstractGeoCodingProvider;
import org.structr.common.geo.AddressComponent;
import org.structr.common.geo.GeoCodingResult;

public class OSMGeoCodingProvider
extends AbstractGeoCodingProvider {
    private static final Logger logger = LoggerFactory.getLogger((String)OSMGeoCodingProvider.class.getName());

    @Override
    public GeoCodingResult geocode(String street, String house, String postalCode, String city, String state, String country, String language) throws IOException {
        block24: {
            String encodedAddress;
            String address = (StringUtils.isNotBlank((CharSequence)house) ? house : "") + " " + (StringUtils.isNotBlank((CharSequence)street) ? street : "") + " " + (StringUtils.isNotBlank((CharSequence)postalCode) ? postalCode : " " + (StringUtils.isNotBlank((CharSequence)city) ? city : "") + " " + (StringUtils.isNotBlank((CharSequence)state) ? state : "") + " " + (StringUtils.isNotBlank((CharSequence)country) ? country : "") + " ");
            try {
                encodedAddress = URLEncoder.encode(address, "UTF-8");
            }
            catch (UnsupportedEncodingException ex) {
                logger.warn("Unsupported Encoding", (Throwable)ex);
                return null;
            }
            try {
                String protocol = "xml";
                URL mapsUrl = new URL("http://nominatim.openstreetmap.org/search?q=" + encodedAddress + "&format=" + protocol + "&accept-language=" + language + "&addressdetails=1&limit=1");
                HttpURLConnection connection = (HttpURLConnection)mapsUrl.openConnection();
                SAXReader reader = new SAXReader();
                BufferedReader rd = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                Document xmlDoc = reader.read((Reader)rd);
                connection.disconnect();
                rd.close();
                if (xmlDoc == null) break block24;
                LinkedHashMap<String, String> data = new LinkedHashMap<String, String>();
                Element root = xmlDoc.getRootElement();
                try {
                    data.put("lat", root.element("place").attributeValue("lat"));
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                try {
                    data.put("lon", root.element("place").attributeValue("lon"));
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                try {
                    data.put("postalCode", root.element("place").element("postcode").getTextTrim());
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                try {
                    data.put("state", root.element("place").element("state").getTextTrim());
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                try {
                    data.put("state_district", root.element("place").element("state_district").getTextTrim());
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                try {
                    data.put("city", root.element("place").element("city").getTextTrim());
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                try {
                    data.put("countryRegion", root.element("place").element("country").getTextTrim());
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                try {
                    data.put("road", root.element("place").element("road").getTextTrim());
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                try {
                    data.put("house_number", root.element("place").element("house_number").getTextTrim());
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (data.containsKey("lat") && data.containsKey("lon")) {
                    return new OSMGeoCodingResult(address, data);
                }
                logger.warn("Geocoding result did not contain location information:\n{}", (Object)xmlDoc.asXML());
            }
            catch (IOException ioe) {
                logger.warn("Connection to geocoding service failed", (Throwable)ioe);
                return null;
            }
            catch (DocumentException de) {
                logger.warn("Could not read result document", (Throwable)de);
                return null;
            }
        }
        return null;
    }

    private static class OSMAddressComponent
    implements AddressComponent {
        GeoCodingResult.Type type = null;
        String value = null;

        public OSMAddressComponent(String value, GeoCodingResult.Type type) {
            this.type = type;
            this.value = value;
        }

        @Override
        public String getValue() {
            return this.value;
        }

        @Override
        public GeoCodingResult.Type getType() {
            return this.type;
        }
    }

    private static class OSMGeoCodingResult
    implements GeoCodingResult {
        private List<AddressComponent> addressComponents = new LinkedList<AddressComponent>();
        private String address = null;
        private double latitude;
        private double longitude;

        public OSMGeoCodingResult(String address, Map<String, String> data) {
            this.address = address;
            this.latitude = Double.parseDouble(data.get("lat"));
            this.longitude = Double.parseDouble(data.get("lon"));
            String curData = null;
            curData = data.get("postalCode");
            if (curData != null) {
                this.addressComponents.add(new OSMAddressComponent(curData, GeoCodingResult.Type.postal_code));
            }
            if ((curData = data.get("state")) != null) {
                this.addressComponents.add(new OSMAddressComponent(curData, GeoCodingResult.Type.administrative_area_level_1));
            }
            if ((curData = data.get("state_district")) != null) {
                this.addressComponents.add(new OSMAddressComponent(curData, GeoCodingResult.Type.administrative_area_level_3));
            }
            if ((curData = data.get("countryRegion")) != null) {
                this.addressComponents.add(new OSMAddressComponent(curData, GeoCodingResult.Type.country));
            }
            if ((curData = data.get("city")) != null) {
                this.addressComponents.add(new OSMAddressComponent(curData, GeoCodingResult.Type.locality));
            }
            if ((curData = data.get("road")) != null) {
                this.addressComponents.add(new OSMAddressComponent(curData, GeoCodingResult.Type.route));
            }
            if ((curData = data.get("house_number")) != null) {
                this.addressComponents.add(new OSMAddressComponent(curData, GeoCodingResult.Type.street_number));
            }
        }

        public OSMGeoCodingResult(double latitude, double longitude) {
            this.latitude = latitude;
            this.longitude = longitude;
        }

        @Override
        public String getAddress() {
            return this.address;
        }

        @Override
        public AddressComponent getAddressComponent(GeoCodingResult.Type type) {
            for (AddressComponent addressComponent : this.addressComponents) {
                if (addressComponent.getType() != type) continue;
                return addressComponent;
            }
            return null;
        }

        @Override
        public List<AddressComponent> getAddressComponents() {
            return this.addressComponents;
        }

        @Override
        public double getLatitude() {
            return this.latitude;
        }

        @Override
        public double getLongitude() {
            return this.longitude;
        }

        @Override
        public void setAddress(String address) {
            this.address = address;
        }

        @Override
        public void setLatitude(double latitude) {
            this.latitude = latitude;
        }

        @Override
        public void setLongitude(double longitude) {
            this.longitude = longitude;
        }

        @Override
        public Double[] toArray() {
            return new Double[]{this.latitude, this.longitude};
        }
    }
}

