/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.common.SecurityContext;
import org.structr.common.error.FrameworkException;
import org.structr.core.Value;
import org.structr.core.converter.PropertyConverter;

public class Converter<SourceType, TargetType>
implements Value<TargetType> {
    private static final Logger logger = LoggerFactory.getLogger((String)Converter.class.getName());
    private PropertyConverter<SourceType, TargetType> converter = null;
    private Value<SourceType> source = null;

    public Converter(Value<SourceType> source, PropertyConverter<SourceType, TargetType> converter) {
        this.converter = converter;
        this.source = source;
    }

    @Override
    public void set(SecurityContext securityContext, TargetType value) throws FrameworkException {
        this.source.set(securityContext, this.converter.revert(value));
    }

    @Override
    public TargetType get(SecurityContext securityContext) {
        try {
            return this.converter.convert(this.source.get(securityContext));
        }
        catch (FrameworkException fex) {
            logger.warn("Unable to obtain value for Converter {}", (Object)this.getClass().getName());
            return null;
        }
    }
}

