/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core;

import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.common.SecurityContext;
import org.structr.common.error.FrameworkException;
import org.structr.core.GraphObject;
import org.structr.core.PropertyGroup;
import org.structr.core.converter.PropertyConverter;
import org.structr.core.property.PropertyKey;
import org.structr.core.property.PropertyMap;

public class MapPropertyGroup
implements PropertyGroup<PropertyMap> {
    private static final Logger logger = LoggerFactory.getLogger((String)MapPropertyGroup.class.getName());
    protected PropertyKey[] propertyKeys = null;

    public MapPropertyGroup(PropertyKey ... propertyKeys) {
        this.propertyKeys = propertyKeys;
    }

    @Override
    public PropertyMap getGroupedProperties(SecurityContext securityContext, GraphObject source) {
        PropertyMap groupedProperties = new PropertyMap();
        for (PropertyKey key : this.propertyKeys) {
            PropertyConverter converter = key.inputConverter(securityContext);
            if (converter != null) {
                try {
                    Object convertedValue = converter.revert(source.getProperty(key));
                    groupedProperties.put(key, convertedValue);
                }
                catch (FrameworkException fex) {
                    logger.warn("Unable to convert grouped property {} on type {}: {}", new Object[]{key.dbName(), source.getClass().getSimpleName(), fex.getMessage()});
                }
                continue;
            }
            groupedProperties.put(key, source.getProperty(key));
        }
        return groupedProperties;
    }

    @Override
    public void setGroupedProperties(SecurityContext securityContext, PropertyMap source, GraphObject destination) throws FrameworkException {
        if (source == null) {
            for (PropertyKey key : this.propertyKeys) {
                destination.setProperty(key, null);
            }
            return;
        }
        for (Map.Entry<PropertyKey, Object> entry : source.entrySet()) {
            destination.setProperty(entry.getKey(), entry.getValue());
        }
    }
}

