/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.api.DatabaseService;
import org.structr.api.config.Setting;
import org.structr.api.config.Settings;
import org.structr.api.service.Command;
import org.structr.api.service.Feature;
import org.structr.api.service.InitializationCallback;
import org.structr.api.service.LicenseManager;
import org.structr.api.service.RunnableService;
import org.structr.api.service.Service;
import org.structr.api.service.StructrServices;
import org.structr.common.Permission;
import org.structr.common.Permissions;
import org.structr.common.SecurityContext;
import org.structr.core.app.StructrApp;
import org.structr.core.graph.NodeService;
import org.structr.schema.ConfigurationProvider;
import org.structr.util.StructrLicenseManager;

public class Services
implements StructrServices {
    private static final Logger logger = LoggerFactory.getLogger((String)StructrApp.class.getName());
    public static final String LOG_SERVICE_INTERVAL = "structr.logging.interval";
    public static final String LOG_SERVICE_THRESHOLD = "structr.logging.threshold";
    public static final String WS_INDENTATION = "ws.indentation";
    private static Services singletonInstance = null;
    private static boolean testingModeDisabled = false;
    private final List<InitializationCallback> callbacks = new LinkedList<InitializationCallback>();
    private final Set<Permission> permissionsForOwnerlessNodes = new LinkedHashSet<Permission>();
    private final Map<String, Object> attributes = new ConcurrentHashMap<String, Object>(10, 0.9f, 8);
    private final Map<Class, Service> serviceCache = new ConcurrentHashMap<Class, Service>(10, 0.9f, 8);
    private final Set<Class> registeredServiceClasses = new LinkedHashSet<Class>();
    private final Set<String> configuredServiceClasses = new LinkedHashSet<String>();
    private LicenseManager licenseManager = null;
    private ConfigurationProvider configuration = null;
    private boolean initializationDone = false;
    private boolean overridingSchemaTypesAllowed = true;
    private boolean shutdownDone = false;
    private String configuredServiceNames = null;
    private String configurationClass = null;

    private Services() {
    }

    public static Services getInstance() {
        if (singletonInstance == null) {
            singletonInstance = new Services();
            singletonInstance.initialize();
        }
        return singletonInstance;
    }

    public <T extends Command> T command(SecurityContext securityContext, Class<T> commandType) {
        try {
            Service service;
            Command command = (Command)commandType.newInstance();
            Class serviceClass = command.getServiceClass();
            command.setArgument("securityContext", (Object)securityContext);
            if (serviceClass != null && this.configuredServiceClasses.contains(serviceClass.getSimpleName()) && (service = this.serviceCache.get(serviceClass)) != null) {
                logger.debug("Initializing command ", (Object)commandType.getName());
                service.injectArguments(command);
            }
            command.initialized();
            return (T)command;
        }
        catch (Throwable t) {
            logger.error("Exception while creating command {}", (Object)commandType.getName());
            return null;
        }
    }

    private void initialize() {
        String configFileName = "structr.conf";
        File configFile = new File("structr.conf");
        if (Services.isTesting()) {
            logger.info("Starting Structr for testing (structr.conf will be ignored)..");
        } else if (configFile.exists()) {
            logger.info("Reading {}..", (Object)"structr.conf");
            Settings.loadConfiguration((String)"structr.conf");
        } else {
            logger.info("Writing {}..", (Object)"structr.conf");
            try {
                Settings.storeConfiguration((String)"structr.conf");
            }
            catch (IOException ioex) {
                logger.warn("Unable to write {}: {}", (Object)"structr.conf", (Object)ioex.getMessage());
            }
        }
        this.doInitialize();
    }

    private void doInitialize() {
        this.configurationClass = (String)Settings.Configuration.getValue();
        this.configuredServiceNames = (String)Settings.Services.getValue();
        this.configuredServiceClasses.addAll(Arrays.asList(this.configuredServiceNames.split("[ ,]+")));
        if (!Services.isTesting()) {
            this.licenseManager = new StructrLicenseManager(Settings.getBasePath() + "license.key");
        }
        this.getConfigurationProvider();
        logger.info("Starting services..");
        for (String string : this.configuredServiceClasses) {
            Class serviceClass = this.getServiceClassForName(string);
            if (serviceClass == null) continue;
            this.startService(serviceClass);
        }
        logger.info("{} service(s) processed", (Object)this.serviceCache.size());
        logger.info("Registering shutdown hook.");
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                Services.this.shutdown();
            }
        });
        String configForOwnerlessNodes = (String)Settings.OwnerlessNodes.getValue();
        if (StringUtils.isNotBlank((CharSequence)configForOwnerlessNodes)) {
            for (String permission : configForOwnerlessNodes.split("[, ]+")) {
                String trimmed = permission.trim();
                if (!StringUtils.isNotBlank((CharSequence)trimmed)) continue;
                Permission val = Permissions.valueOf(trimmed);
                if (val != null) {
                    this.permissionsForOwnerlessNodes.add(val);
                    continue;
                }
                logger.warn("Invalid permisson {}, ignoring.", (Object)trimmed);
            }
        } else {
            this.permissionsForOwnerlessNodes.add(Permission.read);
        }
        try {
            ExecutorService executorService = Executors.newSingleThreadExecutor();
            executorService.submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    for (InitializationCallback callback : singletonInstance.callbacks) {
                        callback.initializationDone();
                    }
                }
            }).get();
        }
        catch (Throwable throwable) {
            logger.warn("Exception while executing post-initialization tasks", throwable);
        }
        System.out.println(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.ms").format(new Date()) + "  ---------------- Initialization complete ----------------");
        this.setOverridingSchemaTypesAllowed(false);
        this.initializationDone = true;
    }

    public void registerInitializationCallback(InitializationCallback callback) {
        this.callbacks.add(callback);
        Collections.sort(this.callbacks, (o1, o2) -> Integer.valueOf(o1.priority()).compareTo(o2.priority()));
    }

    public LicenseManager getLicenseManager() {
        return this.licenseManager;
    }

    public boolean isInitialized() {
        return this.initializationDone;
    }

    public boolean isOverridingSchemaTypesAllowed() {
        return this.overridingSchemaTypesAllowed;
    }

    public void setOverridingSchemaTypesAllowed(boolean allow) {
        this.overridingSchemaTypesAllowed = allow;
    }

    public void shutdown() {
        this.initializationDone = false;
        if (!this.shutdownDone) {
            System.out.println("INFO: Shutting down...");
            for (Service service : this.serviceCache.values()) {
                this.shutdownService(service);
            }
            this.serviceCache.clear();
            this.configuration.shutdown();
            singletonInstance = null;
            System.out.println("INFO: Shutdown complete");
            this.shutdownDone = true;
        }
    }

    public void registerServiceClass(Class serviceClass) {
        this.registeredServiceClasses.add(serviceClass);
    }

    public Class getServiceClassForName(String serviceClassName) {
        for (Class serviceClass : this.registeredServiceClasses) {
            if (!serviceClass.getSimpleName().equals(serviceClassName)) continue;
            return serviceClass;
        }
        return null;
    }

    public ConfigurationProvider getConfigurationProvider() {
        if (this.configuration == null) {
            try {
                this.configuration = (ConfigurationProvider)Class.forName(this.configurationClass).newInstance();
                this.configuration.initialize(this.licenseManager);
            }
            catch (Throwable t) {
                logger.error("Unable to instantiate configration provider of type {}: {}", (Object)this.configurationClass, (Object)t);
            }
        }
        return this.configuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAttribute(String name, Object value) {
        Map<String, Object> map = this.attributes;
        synchronized (map) {
            this.attributes.put(name, value);
        }
    }

    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    public void removeAttribute(String name) {
        this.attributes.remove(name);
    }

    public void startService(String serviceName) {
        Class serviceClass = this.getServiceClassForName(serviceName);
        if (serviceClass != null) {
            this.startService(serviceClass);
        }
    }

    public void startService(Class serviceClass) {
        logger.info("Creating {}..", (Object)serviceClass.getSimpleName());
        try {
            RunnableService runnableService;
            Service service = (Service)serviceClass.newInstance();
            if (this.licenseManager != null && !this.licenseManager.isValid((Feature)service)) {
                logger.error("Configured service {} is not part of the currently licensed Structr Edition.", (Object)serviceClass.getSimpleName());
                return;
            }
            service.initialize((StructrServices)this);
            if (service instanceof RunnableService && (runnableService = (RunnableService)service).runOnStartup()) {
                runnableService.startService();
            }
            if (service.isRunning()) {
                this.serviceCache.put(serviceClass, service);
            }
            service.initialized();
        }
        catch (Throwable t) {
            logger.error("Service {} failed to start", (Object)serviceClass.getSimpleName(), (Object)t);
        }
    }

    public void shutdownService(String serviceName) {
        Class serviceClass = this.getServiceClassForName(serviceName);
        if (serviceClass != null) {
            this.shutdownService(serviceClass);
        }
    }

    public void shutdownService(Class serviceClass) {
        Service service = this.serviceCache.get(serviceClass);
        if (service != null) {
            this.shutdownService(service);
        }
    }

    private void shutdownService(Service service) {
        try {
            RunnableService runnableService;
            if (service instanceof RunnableService && (runnableService = (RunnableService)service).isRunning()) {
                runnableService.stopService();
            }
            service.shutdown();
        }
        catch (Throwable t) {
            System.out.println("WARNING: Failed to shut down " + service.getName() + ": " + t.getMessage());
        }
        this.serviceCache.remove(service.getClass());
    }

    public List<String> getServices() {
        LinkedList<String> services = new LinkedList<String>();
        for (Class serviceClass : this.registeredServiceClasses) {
            String serviceName = serviceClass.getSimpleName();
            if (!this.configuredServiceClasses.contains(serviceName)) continue;
            services.add(serviceName);
        }
        return services;
    }

    public <T extends Service> T getService(Class<T> type) {
        return (T)this.serviceCache.get(type);
    }

    public DatabaseService getDatabaseService() {
        NodeService nodeService = this.getService(NodeService.class);
        if (nodeService != null) {
            return nodeService.getGraphDb();
        }
        return null;
    }

    public boolean isReady(Class serviceClass) {
        Service service = this.serviceCache.get(serviceClass);
        return service != null && service.isRunning();
    }

    public Set<String> getResources() {
        LinkedHashSet<String> resources = new LinkedHashSet<String>();
        for (Setting setting : Settings.getSettings()) {
            Object configurationValue = setting.getValue();
            if (configurationValue == null) continue;
            for (String value : configurationValue.toString().split("[\\s ,;]+")) {
                try {
                    File file;
                    String codeLocation;
                    Class<?> candidate = Class.forName(value);
                    if (candidate.getName().startsWith("org.structr") || (!(codeLocation = candidate.getProtectionDomain().getCodeSource().getLocation().toString()).startsWith("file:") || !codeLocation.endsWith(".jar")) && !codeLocation.endsWith(".war") || !(file = new File(URI.create(codeLocation))).exists()) continue;
                    resources.add(file.getAbsolutePath());
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        return resources;
    }

    public static int parseInt(String value, int defaultValue) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException numberFormatException) {
            return defaultValue;
        }
    }

    public static boolean parseBoolean(String value, boolean defaultValue) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return defaultValue;
        }
        try {
            return Boolean.parseBoolean(value);
        }
        catch (Throwable throwable) {
            return defaultValue;
        }
    }

    public static int getGlobalSessionTimeout() {
        return (Integer)Settings.SessionTimeout.getValue();
    }

    public static Set<Permission> getPermissionsForOwnerlessNodes() {
        return Services.getInstance().permissionsForOwnerlessNodes;
    }

    public String getEdition() {
        if (this.licenseManager != null) {
            return this.licenseManager.getEdition();
        }
        return "Community";
    }

    public static void disableTestingMode() {
        testingModeDisabled = true;
    }

    public static boolean isTesting() {
        if (testingModeDisabled) {
            return false;
        }
        for (StackTraceElement[] stackTraces : Thread.getAllStackTraces().values()) {
            for (StackTraceElement elem : stackTraces) {
                if (!elem.getClassName().startsWith("org.junit.")) continue;
                return true;
            }
        }
        return false;
    }
}

