/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core;

import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.structr.core.entity.AbstractNode;
import org.structr.core.entity.AbstractRelationship;

public class TransactionChangeSet {
    private final Queue<AbstractNode> propagationQueue = new ConcurrentLinkedQueue<AbstractNode>();
    private boolean systemOnly = true;
    private final Queue<AbstractRelationship> modifiedRels = new ConcurrentLinkedQueue<AbstractRelationship>();
    private final Queue<AbstractRelationship> createdRels = new ConcurrentLinkedQueue<AbstractRelationship>();
    private final Queue<AbstractRelationship> deletedRels = new ConcurrentLinkedQueue<AbstractRelationship>();
    private final Queue<AbstractNode> modifiedNodes = new ConcurrentLinkedQueue<AbstractNode>();
    private final Queue<AbstractNode> createdNodes = new ConcurrentLinkedQueue<AbstractNode>();
    private final Queue<AbstractNode> deletedNodes = new ConcurrentLinkedQueue<AbstractNode>();
    private final Queue<AbstractNode> ownerModifiedNodes = new ConcurrentLinkedQueue<AbstractNode>();
    private final Queue<AbstractNode> securityModifiedNodes = new ConcurrentLinkedQueue<AbstractNode>();
    private final Queue<AbstractNode> locationModifiedNodes = new ConcurrentLinkedQueue<AbstractNode>();

    public void include(TransactionChangeSet changeSet) {
        this.modifiedRels.addAll(changeSet.getModifiedRelationships());
        this.createdRels.addAll(changeSet.getCreatedRelationships());
        this.deletedRels.addAll(changeSet.getDeletedRelationships());
        this.modifiedNodes.addAll(changeSet.getModifiedNodes());
        this.createdNodes.addAll(changeSet.getCreatedNodes());
        this.deletedNodes.addAll(changeSet.getDeletedNodes());
        this.ownerModifiedNodes.addAll(changeSet.getOwnerModifiedNodes());
        this.securityModifiedNodes.addAll(changeSet.getSecurityModifiedNodes());
        this.locationModifiedNodes.addAll(changeSet.getLocationModifiedNodes());
        this.ownerModifiedNodes.removeAll(this.deletedNodes);
        this.securityModifiedNodes.removeAll(this.deletedNodes);
        this.locationModifiedNodes.removeAll(this.deletedNodes);
        this.modifiedNodes.removeAll(this.deletedNodes);
        this.createdNodes.removeAll(this.deletedNodes);
        this.modifiedRels.removeAll(this.deletedRels);
        this.createdRels.removeAll(this.deletedRels);
        this.propagationQueue.addAll(changeSet.getPropagationQueue());
    }

    public void clear() {
        this.modifiedRels.clear();
        this.createdRels.clear();
        this.deletedRels.clear();
        this.modifiedNodes.clear();
        this.createdNodes.clear();
        this.deletedNodes.clear();
        this.ownerModifiedNodes.clear();
        this.securityModifiedNodes.clear();
        this.locationModifiedNodes.clear();
        this.propagationQueue.clear();
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("Nodes: ");
        buf.append(this.createdNodes.size());
        buf.append("/");
        buf.append(this.modifiedNodes.size());
        buf.append("/");
        buf.append(this.deletedNodes.size());
        buf.append(", ");
        buf.append("Rels: ");
        buf.append(this.createdRels.size());
        buf.append("/");
        buf.append(this.modifiedRels.size());
        buf.append("/");
        buf.append(this.deletedRels.size());
        if (this.systemOnly) {
            buf.append(" system only");
        }
        return buf.toString();
    }

    public void nonSystemProperty() {
        this.systemOnly = false;
    }

    public boolean systemOnly() {
        return this.systemOnly;
    }

    public void create(AbstractNode created) {
        this.createdNodes.add(created);
        this.propagationQueue.add(created);
        this.systemOnly = false;
    }

    public void modify(AbstractNode modified) {
        if (!this.isNewOrDeleted(modified)) {
            this.modifiedNodes.add(modified);
            this.propagationQueue.add(modified);
        }
    }

    public void delete(AbstractNode deleted) {
        this.propagationQueue.remove(deleted);
        this.createdNodes.remove(deleted);
        this.modifiedNodes.remove(deleted);
        this.ownerModifiedNodes.remove(deleted);
        this.securityModifiedNodes.remove(deleted);
        this.locationModifiedNodes.remove(deleted);
        this.deletedNodes.add(deleted);
        this.systemOnly = false;
    }

    public void create(AbstractRelationship created) {
        this.createdRels.add(created);
        this.systemOnly = false;
    }

    public void modify(AbstractRelationship modified) {
        if (!this.isNewOrDeleted(modified)) {
            this.modifiedRels.add(modified);
        }
    }

    public void delete(AbstractRelationship deleted) {
        this.createdRels.remove(deleted);
        this.modifiedRels.remove(deleted);
        this.deletedRels.add(deleted);
        this.systemOnly = false;
    }

    public void modifyRelationshipEndpoint(AbstractNode node, String relationshipType) {
        switch (relationshipType) {
            case "OWNS": {
                this.modifyOwner(node);
                break;
            }
            case "SECURITY": {
                this.modifySecurity(node);
                break;
            }
            case "IS_AT": {
                this.modifyLocation(node);
                break;
            }
            default: {
                this.modify(node);
            }
        }
    }

    public void modifyOwner(AbstractNode ownerModified) {
        if (!this.isNewOrDeleted(ownerModified)) {
            this.ownerModifiedNodes.add(ownerModified);
            this.propagationQueue.add(ownerModified);
        }
    }

    public void modifySecurity(AbstractNode securityModified) {
        if (!this.isNewOrDeleted(securityModified)) {
            this.securityModifiedNodes.add(securityModified);
            this.propagationQueue.add(securityModified);
        }
    }

    public void modifyLocation(AbstractNode locationModified) {
        if (!this.isNewOrDeleted(locationModified)) {
            this.locationModifiedNodes.add(locationModified);
            this.propagationQueue.add(locationModified);
        }
    }

    public Queue<AbstractRelationship> getModifiedRelationships() {
        return this.modifiedRels;
    }

    public Queue<AbstractRelationship> getCreatedRelationships() {
        return this.createdRels;
    }

    public Queue<AbstractRelationship> getDeletedRelationships() {
        return this.deletedRels;
    }

    public Queue<AbstractNode> getModifiedNodes() {
        return this.modifiedNodes;
    }

    public Queue<AbstractNode> getCreatedNodes() {
        return this.createdNodes;
    }

    public Queue<AbstractNode> getDeletedNodes() {
        return this.deletedNodes;
    }

    public Queue<AbstractNode> getOwnerModifiedNodes() {
        return this.ownerModifiedNodes;
    }

    public Queue<AbstractNode> getSecurityModifiedNodes() {
        return this.securityModifiedNodes;
    }

    public Queue<AbstractNode> getLocationModifiedNodes() {
        return this.locationModifiedNodes;
    }

    public Queue<AbstractNode> getPropagationQueue() {
        return this.propagationQueue;
    }

    private boolean isNew(AbstractNode node) {
        return this.createdNodes.contains(node);
    }

    private boolean isNew(AbstractRelationship relationship) {
        return this.createdRels.contains(relationship);
    }

    private boolean isDeleted(AbstractNode node) {
        return this.deletedNodes.contains(node);
    }

    private boolean isDeleted(AbstractRelationship relationship) {
        return this.deletedRels.contains(relationship);
    }

    private boolean isNewOrDeleted(AbstractNode node) {
        return this.isNew(node) || this.isDeleted(node);
    }

    private boolean isNewOrDeleted(AbstractRelationship relationship) {
        return this.isNew(relationship) || this.isDeleted(relationship);
    }
}

