/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core.app;

import java.io.IOException;
import java.net.URI;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.structr.agent.AgentService;
import org.structr.agent.Task;
import org.structr.api.DatabaseService;
import org.structr.api.NotFoundException;
import org.structr.api.config.Settings;
import org.structr.api.graph.GraphProperties;
import org.structr.api.service.Command;
import org.structr.api.service.Service;
import org.structr.api.util.FixedSizeCache;
import org.structr.common.SecurityContext;
import org.structr.common.error.FrameworkException;
import org.structr.common.fulltext.DummyFulltextIndexer;
import org.structr.common.fulltext.FulltextIndexer;
import org.structr.core.GraphObject;
import org.structr.core.Services;
import org.structr.core.app.App;
import org.structr.core.app.Query;
import org.structr.core.entity.AbstractNode;
import org.structr.core.entity.Relation;
import org.structr.core.graph.CreateNodeCommand;
import org.structr.core.graph.CreateRelationshipCommand;
import org.structr.core.graph.CypherQueryCommand;
import org.structr.core.graph.DeleteNodeCommand;
import org.structr.core.graph.DeleteRelationshipCommand;
import org.structr.core.graph.GraphDatabaseCommand;
import org.structr.core.graph.MaintenanceCommand;
import org.structr.core.graph.NodeAttribute;
import org.structr.core.graph.NodeFactory;
import org.structr.core.graph.NodeInterface;
import org.structr.core.graph.NodeServiceCommand;
import org.structr.core.graph.RelationshipFactory;
import org.structr.core.graph.RelationshipInterface;
import org.structr.core.graph.Tx;
import org.structr.core.graph.search.SearchNodeCommand;
import org.structr.core.graph.search.SearchRelationshipCommand;
import org.structr.core.property.PropertyMap;
import org.structr.module.StructrModule;
import org.structr.schema.ConfigurationProvider;

public class StructrApp
implements App {
    private static FixedSizeCache<String, Long> nodeUuidMap = null;
    private static FixedSizeCache<String, Long> relUuidMap = null;
    private static final URI schemaBaseURI = URI.create("https://structr.org/v1.1/#");
    private static final Object globalConfigLock = new Object();
    private RelationshipFactory relFactory = null;
    private NodeFactory nodeFactory = null;
    private DatabaseService graphDb = null;
    private SecurityContext securityContext = null;
    private static final Map<URI, Class> schemaIdMap = new LinkedHashMap<URI, Class>();
    private static final Map<Class, URI> typeIdMap = new LinkedHashMap<Class, URI>();

    private StructrApp(SecurityContext securityContext) {
        this.securityContext = securityContext;
        this.relFactory = new RelationshipFactory(securityContext);
        this.nodeFactory = new NodeFactory(securityContext);
    }

    @Override
    public <T extends NodeInterface> T create(Class<T> type, String name) throws FrameworkException {
        return this.create(type, new NodeAttribute<String>(StructrApp.getConfiguration().getPropertyKeyForJSONName(type, "name"), name));
    }

    @Override
    public <T extends NodeInterface> T create(Class<T> type, PropertyMap source) throws FrameworkException {
        CreateNodeCommand command = this.command(CreateNodeCommand.class);
        PropertyMap properties = new PropertyMap(source);
        String finalType = type.getSimpleName();
        String typeFromInput = (String)properties.get(NodeInterface.type);
        if (typeFromInput != null) {
            Class actualType = StructrApp.getConfiguration().getNodeEntityClass(typeFromInput);
            if (actualType == null) {
                properties.put(AbstractNode.type, type.getSimpleName());
            } else {
                if (actualType.isInterface()) {
                    throw new FrameworkException(422, "Invalid interface type " + type.getSimpleName() + ", please supply a non-interface class name in the type property");
                }
                finalType = actualType.getSimpleName();
            }
        }
        properties.put(AbstractNode.type, finalType);
        return command.execute(properties);
    }

    @Override
    public <T extends NodeInterface> T create(Class<T> type, NodeAttribute<?> ... attributes) throws FrameworkException {
        LinkedList attrs = new LinkedList(Arrays.asList(attributes));
        CreateNodeCommand command = this.command(CreateNodeCommand.class);
        attrs.add(new NodeAttribute<String>(AbstractNode.type, type.getSimpleName()));
        return command.execute(attrs);
    }

    @Override
    public void delete(NodeInterface node) {
        this.removeNodeFromCache(node);
        this.command(DeleteNodeCommand.class).execute(node);
    }

    @Override
    public <A extends NodeInterface, B extends NodeInterface, R extends Relation<A, B, ?, ?>> R create(A fromNode, B toNode, Class<R> relType) throws FrameworkException {
        return this.command(CreateRelationshipCommand.class).execute(fromNode, toNode, relType);
    }

    @Override
    public <A extends NodeInterface, B extends NodeInterface, R extends Relation<A, B, ?, ?>> R create(A fromNode, B toNode, Class<R> relType, PropertyMap properties) throws FrameworkException {
        return this.command(CreateRelationshipCommand.class).execute(fromNode, toNode, relType, properties);
    }

    @Override
    public void delete(RelationshipInterface relationship) {
        this.removeRelFromCache(relationship);
        this.command(DeleteRelationshipCommand.class).execute(relationship);
    }

    @Override
    public GraphObject get(String uuid) throws FrameworkException {
        if (uuid == null) {
            return null;
        }
        NodeInterface node = this.getNodeById(uuid);
        if (node != null) {
            return node;
        }
        RelationshipInterface rel = this.getRelationshipById(uuid);
        if (rel != null) {
            return rel;
        }
        return null;
    }

    @Override
    public NodeInterface getNodeById(String uuid) throws FrameworkException {
        if (uuid == null) {
            return null;
        }
        Long nodeId = this.getNodeFromCache(uuid);
        if (nodeId == null) {
            NodeInterface entity = this.nodeQuery().uuid(uuid).includeDeletedAndHidden().getFirst();
            if (entity != null && uuid.equals(entity.getUuid())) {
                nodeUuidMap.put((Object)uuid, (Object)entity.getId());
                return entity;
            }
        } else {
            try {
                return this.nodeFactory.instantiate(this.getDatabaseService().getNodeById(nodeId.longValue()));
            }
            catch (NotFoundException ignore) {
                nodeUuidMap.remove((Object)uuid);
            }
        }
        return null;
    }

    @Override
    public RelationshipInterface getRelationshipById(String uuid) throws FrameworkException {
        if (uuid == null) {
            return null;
        }
        Long id = this.getRelFromCache(uuid);
        if (id == null) {
            RelationshipInterface entity = this.relationshipQuery().uuid(uuid).getFirst();
            if (entity != null && uuid.equals(entity.getUuid())) {
                relUuidMap.put((Object)uuid, (Object)entity.getId());
                return entity;
            }
        } else {
            try {
                return this.relFactory.instantiate(this.getDatabaseService().getRelationshipById(id.longValue()));
            }
            catch (NotFoundException ignore) {
                relUuidMap.remove((Object)uuid);
            }
        }
        return null;
    }

    @Override
    public <T extends GraphObject> T get(Class<T> type, String uuid) throws FrameworkException {
        GraphObject entity = this.get(uuid);
        if (type != null && entity != null && type.isAssignableFrom(entity.getClass())) {
            return (T)entity;
        }
        return null;
    }

    @Override
    public <T extends GraphObject> List<T> get(Class<T> type) throws FrameworkException {
        Query query = this.command(SearchNodeCommand.class);
        return query.andType(type).getAsList();
    }

    public Query<NodeInterface> nodeQuery() {
        return this.command(SearchNodeCommand.class);
    }

    @Override
    public <T extends NodeInterface> Query<T> nodeQuery(Class<T> type) {
        return this.command(SearchNodeCommand.class).andTypes((Class)type);
    }

    public Query<RelationshipInterface> relationshipQuery() {
        return this.command(SearchRelationshipCommand.class);
    }

    @Override
    public <T extends RelationshipInterface> Query<T> relationshipQuery(Class<T> type) {
        return this.command(SearchRelationshipCommand.class).andType((Class)type);
    }

    @Override
    public Tx tx() {
        return this.tx(true);
    }

    @Override
    public Tx tx(boolean doValidation) {
        return this.tx(doValidation, true);
    }

    @Override
    public Tx tx(boolean doValidation, boolean doCallbacks) {
        return new Tx(this.securityContext, this, doValidation, doCallbacks).begin();
    }

    @Override
    public Tx tx(boolean doValidation, boolean doCallbacks, boolean doNotifications) {
        return new Tx(this.securityContext, this, doValidation, doCallbacks, doNotifications).begin();
    }

    @Override
    public void shutdown() {
        Services.getInstance().shutdown();
    }

    @Override
    public void close() throws IOException {
        this.shutdown();
    }

    @Override
    public <T extends Command> T command(Class<T> commandType) {
        return Services.getInstance().command(this.securityContext, commandType);
    }

    @Override
    public void processTasks(Task ... tasks) {
        AgentService agentService = this.getService(AgentService.class);
        if (agentService != null) {
            for (Task task : tasks) {
                agentService.processTask(task);
            }
        }
    }

    @Override
    public <T extends Command> void maintenance(Class<T> commandClass, Map<String, Object> propertySet) throws FrameworkException {
        ((MaintenanceCommand)Services.getInstance().command(this.securityContext, commandClass)).execute(propertySet);
    }

    @Override
    public List<GraphObject> cypher(String cypherQuery, Map<String, Object> parameters) throws FrameworkException {
        return Services.getInstance().command(this.securityContext, CypherQueryCommand.class).execute(cypherQuery, parameters);
    }

    @Override
    public <T extends Service> T getService(Class<T> serviceClass) {
        return Services.getInstance().getService(serviceClass);
    }

    @Override
    public DatabaseService getDatabaseService() {
        if (this.graphDb == null) {
            this.graphDb = Services.getInstance().command(this.securityContext, GraphDatabaseCommand.class).execute();
        }
        return this.graphDb;
    }

    @Override
    public <T> T getGlobalSetting(String key, T defaultValue) throws FrameworkException {
        DatabaseService service = this.getDatabaseService();
        if (service != null) {
            GraphProperties config = service.getGlobalProperties();
            Object value = null;
            if (config != null) {
                value = config.getProperty(key);
            }
            if (value == null) {
                return defaultValue;
            }
            return (T)value;
        }
        return defaultValue;
    }

    @Override
    public void setGlobalSetting(String key, Object value) throws FrameworkException {
        GraphProperties config;
        DatabaseService service = this.getDatabaseService();
        if (service != null && (config = service.getGlobalProperties()) != null) {
            config.setProperty(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getInstanceId() throws FrameworkException {
        Object object = globalConfigLock;
        synchronized (object) {
            String instanceId = this.getGlobalSetting("structr.instance.id", null);
            System.out.println("instance id from getGlobalSetting: " + instanceId);
            if (instanceId == null) {
                instanceId = NodeServiceCommand.getNextUuid();
                this.setGlobalSetting("structr.instance.id", instanceId);
            }
            System.out.println("instance id: " + instanceId);
            return instanceId;
        }
    }

    @Override
    public FulltextIndexer getFulltextIndexer(Object ... params) {
        Map<String, StructrModule> modules = StructrApp.getConfiguration().getModules();
        StructrModule module = modules.get("text-search");
        if (module != null && module instanceof FulltextIndexer) {
            return (FulltextIndexer)((Object)module);
        }
        return new DummyFulltextIndexer();
    }

    public static App getInstance() {
        return new StructrApp(SecurityContext.getSuperUserInstance());
    }

    public static App getInstance(SecurityContext securityContext) {
        return new StructrApp(securityContext);
    }

    public static ConfigurationProvider getConfiguration() {
        return Services.getInstance().getConfigurationProvider();
    }

    public static <T extends GraphObject> URI getSchemaId(Class<T> type) {
        StructrApp.initializeSchemaIds();
        return typeIdMap.get(type);
    }

    public static Class resolveSchemaId(URI uri) {
        StructrApp.initializeSchemaIds();
        return schemaIdMap.get(uri);
    }

    public static URI getSchemaBaseURI() {
        return schemaBaseURI;
    }

    public static void invalidate(String uuid) {
        if (nodeUuidMap != null) {
            nodeUuidMap.remove((Object)uuid);
        }
        if (relUuidMap != null) {
            relUuidMap.remove((Object)uuid);
        }
    }

    private static void initializeSchemaIds() {
        if (schemaIdMap.isEmpty()) {
            for (Class<? extends NodeInterface> clazz : StructrApp.getConfiguration().getNodeEntities().values()) {
                StructrApp.registerType(clazz);
            }
            for (Class<GraphObject> clazz : StructrApp.getConfiguration().getRelationshipEntities().values()) {
                StructrApp.registerType(clazz);
            }
        }
    }

    private static void registerType(Class type) {
        URI id = schemaBaseURI.resolve(URI.create("definitions/" + type.getSimpleName()));
        schemaIdMap.put(id, type);
        typeIdMap.put(type, id);
    }

    private synchronized Long getNodeFromCache(String uuid) {
        if (nodeUuidMap == null) {
            nodeUuidMap = new FixedSizeCache(((Integer)Settings.UuidCacheSize.getValue()).intValue());
        }
        return (Long)nodeUuidMap.get((Object)uuid);
    }

    private synchronized Long getRelFromCache(String uuid) {
        if (relUuidMap == null) {
            relUuidMap = new FixedSizeCache(((Integer)Settings.UuidCacheSize.getValue()).intValue());
        }
        return (Long)relUuidMap.get((Object)uuid);
    }

    private synchronized void removeNodeFromCache(NodeInterface node) {
        String uuid;
        if (node != null && (uuid = node.getUuid()) != null && nodeUuidMap == null) {
            nodeUuidMap = new FixedSizeCache(((Integer)Settings.UuidCacheSize.getValue()).intValue());
        }
    }

    private synchronized void removeRelFromCache(RelationshipInterface rel) {
        String uuid;
        if (rel != null && (uuid = rel.getUuid()) != null && relUuidMap == null) {
            relUuidMap = new FixedSizeCache(((Integer)Settings.UuidCacheSize.getValue()).intValue());
        }
    }

    @Override
    public void invalidateCache() {
        if (nodeUuidMap != null) {
            nodeUuidMap.clear();
        }
        if (relUuidMap != null) {
            relUuidMap.clear();
        }
    }
}

