/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core.converter;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.common.SecurityContext;
import org.structr.common.error.FrameworkException;
import org.structr.core.GraphObject;
import org.structr.core.app.App;
import org.structr.core.app.StructrApp;
import org.structr.core.converter.PropertyConverter;
import org.structr.core.graph.NodeAttribute;
import org.structr.core.graph.NodeInterface;
import org.structr.core.property.PropertyKey;
import org.structr.core.property.RelationProperty;

public class RelatedNodePropertyMapper<T extends NodeInterface>
extends PropertyConverter {
    private static final Logger logger = LoggerFactory.getLogger((String)RelatedNodePropertyMapper.class.getName());
    private PropertyKey<T> sourceKey = null;
    private PropertyKey targetKey = null;

    public RelatedNodePropertyMapper(SecurityContext securityContext, GraphObject currentObject, PropertyKey<T> sourceKey, PropertyKey targetKey) {
        super(securityContext, currentObject);
        this.sourceKey = sourceKey;
        this.targetKey = targetKey;
    }

    public Object convert(Object source) {
        NodeInterface relatedNode = this.getRelatedNode(true);
        if (relatedNode != null) {
            try {
                relatedNode.setProperty(this.targetKey, source);
            }
            catch (FrameworkException fex) {
                logger.warn("Unable to set remote node property {}", (Object)this.targetKey);
            }
        }
        return null;
    }

    public Object revert(Object source) {
        NodeInterface relatedNode = this.getRelatedNode(false);
        if (relatedNode != null) {
            return relatedNode.getProperty(this.targetKey);
        }
        return null;
    }

    private NodeInterface getRelatedNode(boolean add) {
        NodeInterface localNode;
        NodeInterface relatedNode = null;
        if (this.currentObject != null && this.currentObject instanceof NodeInterface && (relatedNode = (NodeInterface)(localNode = (NodeInterface)this.currentObject).getProperty(this.sourceKey)) == null && add && this.sourceKey instanceof RelationProperty) {
            RelationProperty relationProperty = (RelationProperty)((Object)this.sourceKey);
            App app = StructrApp.getInstance();
            Class relatedType = relationProperty.getTargetType();
            if (relatedType != null) {
                try {
                    relatedNode = app.create(relatedType, new NodeAttribute[0]);
                    relationProperty.addSingleElement(this.securityContext, localNode, relatedNode);
                }
                catch (FrameworkException fex) {
                    logger.warn("", (Throwable)fex);
                }
            } else {
                logger.error("Related type was null for {}", (Object)this.currentObject);
            }
        }
        return relatedNode;
    }
}

