/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core.entity;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import org.apache.chemistry.opencmis.commons.data.Ace;
import org.apache.chemistry.opencmis.commons.data.AllowableActions;
import org.apache.chemistry.opencmis.commons.enums.BaseTypeId;
import org.apache.chemistry.opencmis.commons.enums.PropertyType;
import org.apache.commons.codec.digest.DigestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.api.Predicate;
import org.structr.api.config.Settings;
import org.structr.api.graph.Direction;
import org.structr.api.graph.Node;
import org.structr.api.graph.PropertyContainer;
import org.structr.api.graph.Relationship;
import org.structr.api.index.Index;
import org.structr.api.util.FixedSizeCache;
import org.structr.api.util.Iterables;
import org.structr.cmis.CMISInfo;
import org.structr.cmis.common.CMISExtensionsData;
import org.structr.cmis.common.StructrItemActions;
import org.structr.cmis.info.CMISDocumentInfo;
import org.structr.cmis.info.CMISFolderInfo;
import org.structr.cmis.info.CMISItemInfo;
import org.structr.cmis.info.CMISPolicyInfo;
import org.structr.cmis.info.CMISRelationshipInfo;
import org.structr.cmis.info.CMISSecondaryInfo;
import org.structr.common.AccessControllable;
import org.structr.common.IdSorter;
import org.structr.common.Permission;
import org.structr.common.PermissionPropagation;
import org.structr.common.PermissionResolutionMask;
import org.structr.common.SecurityContext;
import org.structr.common.ValidationHelper;
import org.structr.common.View;
import org.structr.common.error.ErrorBuffer;
import org.structr.common.error.FrameworkException;
import org.structr.common.error.InternalSystemPropertyToken;
import org.structr.common.error.NullArgumentToken;
import org.structr.common.error.ReadOnlyPropertyToken;
import org.structr.core.GraphObject;
import org.structr.core.IterableAdapter;
import org.structr.core.Services;
import org.structr.core.app.App;
import org.structr.core.app.StructrApp;
import org.structr.core.converter.PropertyConverter;
import org.structr.core.entity.AbstractRelationship;
import org.structr.core.entity.ManyEndpoint;
import org.structr.core.entity.ManyStartpoint;
import org.structr.core.entity.OneEndpoint;
import org.structr.core.entity.OneStartpoint;
import org.structr.core.entity.Principal;
import org.structr.core.entity.Relation;
import org.structr.core.entity.SchemaRelationshipNode;
import org.structr.core.entity.Security;
import org.structr.core.entity.Source;
import org.structr.core.entity.Target;
import org.structr.core.entity.relationship.Ownership;
import org.structr.core.entity.relationship.PrincipalOwnsNode;
import org.structr.core.graph.ModificationQueue;
import org.structr.core.graph.NodeInterface;
import org.structr.core.graph.NodeRelationshipStatisticsCommand;
import org.structr.core.graph.NodeService;
import org.structr.core.graph.RelationshipFactory;
import org.structr.core.graph.RelationshipInterface;
import org.structr.core.property.FunctionProperty;
import org.structr.core.property.PropertyKey;
import org.structr.core.property.PropertyMap;
import org.structr.core.script.Scripting;
import org.structr.schema.action.ActionContext;
import org.structr.schema.action.Function;

public abstract class AbstractNode
implements NodeInterface,
AccessControllable,
CMISInfo,
CMISItemInfo {
    private static final int permissionResolutionMaxLevel = (Integer)Settings.ResolutionDepth.getValue();
    private static final Logger logger = LoggerFactory.getLogger((String)AbstractNode.class.getName());
    private static final FixedSizeCache<String, Object> relationshipTemplateInstanceCache = new FixedSizeCache(1000);
    private static final Map<Long, Map<Long, PermissionResolutionResult>> globalPermissionResolutionCache = new HashMap<Long, Map<Long, PermissionResolutionResult>>();
    public static final View defaultView = new View(AbstractNode.class, "public", id, type);
    public static final View uiView = new View(AbstractNode.class, "ui", id, name, owner, type, createdBy, deleted, hidden, createdDate, lastModifiedDate, visibleToPublicUsers, visibleToAuthenticatedUsers, visibilityStartDate, visibilityEndDate);
    public boolean internalSystemPropertiesUnlocked = false;
    private Relationship rawPathSegment = null;
    private boolean readOnlyPropertiesUnlocked = false;
    private boolean isCreation = false;
    protected String cachedUuid = null;
    protected SecurityContext securityContext = null;
    protected Principal cachedOwnerNode = null;
    protected Class entityType = null;
    protected Node dbNode = null;

    public AbstractNode() {
    }

    public AbstractNode(SecurityContext securityContext, Node dbNode, Class entityType) {
        this.init(securityContext, dbNode, entityType, false);
    }

    @Override
    public void onNodeCreation() {
    }

    @Override
    public void onNodeInstantiation(boolean isCreation) {
        this.cachedUuid = this.getProperty(GraphObject.id);
    }

    @Override
    public void onNodeDeletion() {
    }

    @Override
    public final void init(SecurityContext securityContext, Node dbNode, Class entityType, boolean isCreation) {
        this.isCreation = isCreation;
        this.dbNode = dbNode;
        this.entityType = entityType;
        this.securityContext = securityContext;
    }

    @Override
    public Class getEntityType() {
        return this.entityType;
    }

    @Override
    public final void setSecurityContext(SecurityContext securityContext) {
        this.securityContext = securityContext;
    }

    @Override
    public final SecurityContext getSecurityContext() {
        return this.securityContext;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof AbstractNode)) {
            return false;
        }
        return Integer.valueOf(this.hashCode()).equals(o.hashCode());
    }

    public int hashCode() {
        if (this.dbNode == null) {
            return super.hashCode();
        }
        return Long.valueOf(this.dbNode.getId()).hashCode();
    }

    public int compareTo(Object other) {
        if (other instanceof AbstractNode) {
            AbstractNode node = (AbstractNode)other;
            String _name = this.getName();
            if (_name == null) {
                return -1;
            }
            String nodeName = node.getName();
            if (nodeName == null) {
                return -1;
            }
            return _name.compareTo(nodeName);
        }
        if (other instanceof String) {
            return this.getUuid().compareTo((String)other);
        }
        if (other == null) {
            throw new NullPointerException();
        }
        throw new IllegalStateException("Cannot compare " + this + " to " + other);
    }

    public String toString() {
        return this.getUuid();
    }

    @Override
    public final void unlockReadOnlyPropertiesOnce() {
        this.readOnlyPropertiesUnlocked = true;
    }

    @Override
    public final void unlockSystemPropertiesOnce() {
        this.internalSystemPropertiesUnlocked = true;
        this.unlockReadOnlyPropertiesOnce();
    }

    @Override
    public final void removeProperty(PropertyKey key) throws FrameworkException {
        if (!this.isGranted(Permission.write, this.securityContext)) {
            throw new FrameworkException(403, "Modification not permitted.");
        }
        if (this.dbNode != null) {
            if (key == null) {
                logger.error("Tried to set property with null key (action was denied)");
                return;
            }
            if (key.isReadOnly()) {
                if (this.readOnlyPropertiesUnlocked || this.securityContext.isSuperUser()) {
                    this.internalSystemPropertiesUnlocked = false;
                } else {
                    throw new FrameworkException(404, "Property " + key.jsonName() + " is read-only", new ReadOnlyPropertyToken(this.getType(), key));
                }
            }
            if (key.isSystemInternal()) {
                if (this.internalSystemPropertiesUnlocked) {
                    this.internalSystemPropertiesUnlocked = false;
                } else {
                    throw new FrameworkException(404, "Property " + key.jsonName() + " is read-only", new InternalSystemPropertyToken(this.getType(), key));
                }
            }
            this.dbNode.removeProperty(key.dbName());
            this.removeFromIndex(key);
        }
    }

    @Override
    public final PropertyKey getDefaultSortKey() {
        return name;
    }

    @Override
    public final String getDefaultSortOrder() {
        return "asc";
    }

    @Override
    public final String getType() {
        return (String)this.getProperty(type);
    }

    @Override
    public final PropertyContainer getPropertyContainer() {
        return this.dbNode;
    }

    @Override
    public final String getName() {
        String name = (String)this.getProperty(AbstractNode.name);
        if (name == null) {
            name = this.getNodeId().toString();
        }
        return name;
    }

    @Override
    public final long getId() {
        if (this.dbNode == null) {
            return -1L;
        }
        return this.dbNode.getId();
    }

    @Override
    public final String getUuid() {
        if (this.cachedUuid == null) {
            this.cachedUuid = this.getProperty(GraphObject.id);
        }
        return this.cachedUuid;
    }

    public final Long getNodeId() {
        return this.getId();
    }

    public final String getIdString() {
        return Long.toString(this.getId());
    }

    public final boolean getVisibleToPublicUsers() {
        return (Boolean)this.getProperty(visibleToPublicUsers);
    }

    public final boolean getVisibleToAuthenticatedUsers() {
        return (Boolean)this.getProperty(visibleToPublicUsers);
    }

    public final boolean getHidden() {
        return (Boolean)this.getProperty(hidden);
    }

    public final boolean getDeleted() {
        return (Boolean)this.getProperty(deleted);
    }

    @Override
    public Iterable<PropertyKey> getPropertyKeys(String propertyView) {
        if (this.securityContext != null && this.securityContext.hasCustomView()) {
            LinkedHashSet<PropertyKey> keys = new LinkedHashSet<PropertyKey>(StructrApp.getConfiguration().getPropertySet(this.entityType, propertyView));
            Set<String> customView = this.securityContext.getCustomView();
            Iterator it = keys.iterator();
            while (it.hasNext()) {
                if (customView.contains(((PropertyKey)it.next()).jsonName())) continue;
                it.remove();
            }
            return keys;
        }
        return StructrApp.getConfiguration().getPropertySet(this.entityType, propertyView);
    }

    @Override
    public <T> T getProperty(PropertyKey<T> key) {
        return this.getProperty(key, null);
    }

    @Override
    public <T> T getProperty(PropertyKey<T> key, Predicate<GraphObject> predicate) {
        return this.getProperty(key, true, predicate);
    }

    private <T> T getProperty(PropertyKey<T> key, boolean applyConverter, Predicate<GraphObject> predicate) {
        if (key == null || key.dbName() == null) {
            return null;
        }
        return key.getProperty(this.securityContext, this, applyConverter, predicate);
    }

    public final String getPropertyMD5(PropertyKey key) {
        Object value = this.getProperty(key);
        if (value instanceof String) {
            return DigestUtils.md5Hex((String)((String)value));
        }
        if (value instanceof byte[]) {
            return DigestUtils.md5Hex((byte[])((byte[])value));
        }
        logger.warn("Could not create MD5 hex out of value {}", value);
        return null;
    }

    @Override
    public final <T> Comparable getComparableProperty(PropertyKey<T> key) {
        if (key != null) {
            T propertyValue = this.getProperty(key);
            PropertyConverter<T, ?> converter = key.databaseConverter(this.securityContext, this);
            if (converter != null) {
                try {
                    return converter.convertForSorting(propertyValue);
                }
                catch (Throwable t) {
                    logger.warn("Unable to convert property {} of type {}: {}", new Object[]{key.dbName(), this.getClass().getSimpleName(), t.getMessage()});
                    logger.warn("", t);
                }
            }
            if (propertyValue instanceof Comparable) {
                return (Comparable)propertyValue;
            }
            if (propertyValue != null) {
                return propertyValue.toString();
            }
        }
        return null;
    }

    public final Iterable getIterableProperty(PropertyKey<? extends Iterable> propertyKey) {
        return this.getProperty(propertyKey);
    }

    public Set<AbstractNode> getNodesForModificationPropagation() {
        return null;
    }

    @Override
    public final Node getNode() {
        return this.dbNode;
    }

    @Override
    public final <R extends AbstractRelationship> Iterable<R> getRelationships() {
        return new IterableAdapter(this.dbNode.getRelationships(), new RelationshipFactory(this.securityContext));
    }

    @Override
    public final <A extends NodeInterface, B extends NodeInterface, S extends Source, T extends Target, R extends Relation<A, B, S, T>> Iterable<R> getRelationships(Class<R> type) {
        RelationshipFactory factory = new RelationshipFactory(this.securityContext);
        R template = AbstractNode.getRelationshipForType(type);
        Direction direction = template.getDirectionForType(this.entityType);
        R relType = template;
        return new IterableAdapter(this.dbNode.getRelationships(direction, relType), factory);
    }

    @Override
    public final <A extends NodeInterface, B extends NodeInterface, T extends Target, R extends Relation<A, B, OneStartpoint<A>, T>> R getIncomingRelationship(Class<R> type) {
        RelationshipFactory factory = new RelationshipFactory(this.securityContext);
        R template = AbstractNode.getRelationshipForType(type);
        Relationship relationship = template.getSource().getRawSource(this.securityContext, this.dbNode, (Predicate<GraphObject>)null);
        if (relationship != null) {
            return (R)((Relation)factory.adapt(relationship));
        }
        return null;
    }

    @Override
    public final <A extends NodeInterface, B extends NodeInterface, T extends Target, R extends Relation<A, B, ManyStartpoint<A>, T>> Iterable<R> getIncomingRelationships(Class<R> type) {
        RelationshipFactory factory = new RelationshipFactory(this.securityContext);
        R template = AbstractNode.getRelationshipForType(type);
        return new IterableAdapter(new IdSorter(template.getSource().getRawSource(this.securityContext, this.dbNode, (Predicate)null)), factory);
    }

    @Override
    public final <A extends NodeInterface, B extends NodeInterface, S extends Source, R extends Relation<A, B, S, OneEndpoint<B>>> R getOutgoingRelationship(Class<R> type) {
        RelationshipFactory factory = new RelationshipFactory(this.securityContext);
        R template = AbstractNode.getRelationshipForType(type);
        Relationship relationship = template.getTarget().getRawSource(this.securityContext, this.dbNode, (Predicate<GraphObject>)null);
        if (relationship != null) {
            return (R)((Relation)factory.adapt(relationship));
        }
        return null;
    }

    @Override
    public final <A extends NodeInterface, B extends NodeInterface, S extends Source, R extends Relation<A, B, S, ManyEndpoint<B>>> Iterable<R> getOutgoingRelationships(Class<R> type) {
        RelationshipFactory factory = new RelationshipFactory(this.securityContext);
        R template = AbstractNode.getRelationshipForType(type);
        return new IterableAdapter(new IdSorter(template.getTarget().getRawSource(this.securityContext, this.dbNode, (Predicate)null)), factory);
    }

    @Override
    public final <R extends AbstractRelationship> Iterable<R> getIncomingRelationships() {
        return new IterableAdapter(new IdSorter(this.dbNode.getRelationships(Direction.INCOMING)), new RelationshipFactory(this.securityContext));
    }

    @Override
    public final <R extends AbstractRelationship> Iterable<R> getOutgoingRelationships() {
        return new IterableAdapter(new IdSorter(this.dbNode.getRelationships(Direction.OUTGOING)), new RelationshipFactory(this.securityContext));
    }

    @Override
    public final <R extends AbstractRelationship> Iterable<R> getRelationshipsAsSuperUser() {
        return new IterableAdapter(this.dbNode.getRelationships(), new RelationshipFactory(SecurityContext.getSuperUserInstance()));
    }

    protected final <A extends NodeInterface, B extends NodeInterface, T extends Target, R extends Relation<A, B, ManyStartpoint<A>, T>> Iterable<R> getIncomingRelationshipsAsSuperUser(Class<R> type) {
        RelationshipFactory factory = new RelationshipFactory(SecurityContext.getSuperUserInstance());
        R template = AbstractNode.getRelationshipForType(type);
        return new IterableAdapter(template.getSource().getRawSource(SecurityContext.getSuperUserInstance(), this.dbNode, (Predicate)null), factory);
    }

    protected final <A extends NodeInterface, B extends NodeInterface, T extends Target, R extends Relation<A, B, ManyStartpoint<A>, T>> R getOutgoingRelationshipAsSuperUser(Class<R> type) {
        RelationshipFactory factory = new RelationshipFactory(SecurityContext.getSuperUserInstance());
        R template = AbstractNode.getRelationshipForType(type);
        Relationship relationship = template.getSource().getRawTarget(SecurityContext.getSuperUserInstance(), this.dbNode, null);
        if (relationship != null) {
            return (R)((Relation)factory.adapt(relationship));
        }
        return null;
    }

    protected final <A extends NodeInterface, B extends NodeInterface, S extends Source, T extends Target, R extends Relation<A, B, S, T>> Iterable<R> getRelationshipsAsSuperUser(Class<R> type) {
        RelationshipFactory factory = new RelationshipFactory(SecurityContext.getSuperUserInstance());
        R template = AbstractNode.getRelationshipForType(type);
        Direction direction = template.getDirectionForType(this.entityType);
        R relType = template;
        return new IterableAdapter(this.dbNode.getRelationships(direction, relType), factory);
    }

    public final Map<String, Long> getRelationshipInfo(Direction dir) throws FrameworkException {
        return StructrApp.getInstance(this.securityContext).command(NodeRelationshipStatisticsCommand.class).execute(this, dir);
    }

    @Override
    public final Principal getOwnerNode() {
        Ownership ownership;
        if (this.cachedOwnerNode == null && (ownership = (Ownership)this.getIncomingRelationshipAsSuperUser(PrincipalOwnsNode.class)) != null) {
            Principal principal;
            this.cachedOwnerNode = principal = ownership.getSourceNode();
        }
        return this.cachedOwnerNode;
    }

    public final Long getOwnerId() {
        return this.getOwnerNode().getId();
    }

    protected <A extends NodeInterface, B extends NodeInterface, T extends Target, R extends Relation<A, B, OneStartpoint<A>, T>> R getIncomingRelationshipAsSuperUser(Class<R> type) {
        RelationshipFactory factory = new RelationshipFactory(SecurityContext.getSuperUserInstance());
        R template = AbstractNode.getRelationshipForType(type);
        Relationship relationship = template.getSource().getRawSource(SecurityContext.getSuperUserInstance(), this.dbNode, (Predicate<GraphObject>)null);
        if (relationship != null) {
            return (R)((Relation)factory.adapt(relationship));
        }
        return null;
    }

    public final <A extends NodeInterface, B extends NodeInterface, S extends Source, T extends Target> boolean hasRelationship(Class<? extends Relation<A, B, S, T>> type) {
        return this.getRelationships(type).iterator().hasNext();
    }

    public final <A extends NodeInterface, B extends NodeInterface, S extends Source, T extends Target, R extends Relation<A, B, S, T>> boolean hasIncomingRelationships(Class<R> type) {
        return AbstractNode.getRelationshipForType(type).getSource().hasElements(this.securityContext, this.dbNode, null);
    }

    public final <A extends NodeInterface, B extends NodeInterface, S extends Source, T extends Target, R extends Relation<A, B, S, T>> boolean hasOutgoingRelationships(Class<R> type) {
        return AbstractNode.getRelationshipForType(type).getTarget().hasElements(this.securityContext, this.dbNode, null);
    }

    @Override
    public final boolean isGranted(Permission permission, SecurityContext context) {
        if (context != null && context.isSuperUser()) {
            return true;
        }
        Principal accessingUser = null;
        if (context != null) {
            accessingUser = context.getUser(false);
        }
        boolean doLog = this.securityContext.hasParameter("logPermissionResolution");
        return this.isGranted(permission, accessingUser, new PermissionResolutionMask(), 0, new AlreadyTraversed(), true, doLog);
    }

    private boolean isGranted(Permission permission, Principal accessingUser, PermissionResolutionMask mask, int level, AlreadyTraversed alreadyTraversed, boolean resolvePermissions, boolean doLog) {
        boolean hasOwner;
        if (level > 100) {
            logger.warn("Aborting recursive permission resolution because of recursion level > 100, this is quite likely an infinite loop.");
            return false;
        }
        if (this.isCreation && (accessingUser == null || accessingUser.equals(this) || accessingUser.equals(this.getOwnerNode()))) {
            return true;
        }
        if (accessingUser != null && accessingUser.isAdmin()) {
            return true;
        }
        if (this.equals(accessingUser) && (level == 0 || permission.equals(Permission.read) && level > 0)) {
            return true;
        }
        Principal _owner = this.getOwnerNode();
        boolean bl = hasOwner = _owner != null;
        if (!hasOwner && Services.getPermissionsForOwnerlessNodes().contains(permission)) {
            if (accessingUser != null && this.isVisibleToAuthenticatedUsers()) {
                return true;
            }
            if (accessingUser == null && this.isVisibleToPublicUsers()) {
                return true;
            }
        }
        if (hasOwner && accessingUser == null) {
            return false;
        }
        if (accessingUser != null) {
            if (hasOwner && accessingUser.equals(_owner)) {
                return true;
            }
            Security security = this.getSecurityRelationship(accessingUser);
            if (security != null && security.isAllowed(permission)) {
                return true;
            }
            if (resolvePermissions) {
                LinkedList<BFSInfo> bfsNodes = new LinkedList<BFSInfo>();
                BFSInfo root = new BFSInfo(null, this);
                bfsNodes.add(root);
                do {
                    BFSInfo info;
                    if ((info = (BFSInfo)bfsNodes.poll()) == null || info.level >= permissionResolutionMaxLevel) continue;
                    Boolean value = info.node.getPermissionResolutionResult(accessingUser.getId(), permission);
                    if (value != null) {
                        if (!Boolean.TRUE.equals(value)) continue;
                        this.backtrack(info, accessingUser.getId(), permission, true, 0, doLog);
                        return true;
                    }
                    if (!info.node.hasEffectivePermissions(info, accessingUser, permission, mask, level, alreadyTraversed, bfsNodes, doLog)) continue;
                    this.backtrack(info, accessingUser.getId(), permission, true, 0, doLog);
                    return true;
                } while (!bfsNodes.isEmpty());
                this.backtrack(root, accessingUser.getId(), permission, false, 0, doLog);
            }
            for (Principal parent : accessingUser.getParents()) {
                if (!this.isGranted(permission, parent, mask, level + 1, alreadyTraversed, false, doLog)) continue;
                return true;
            }
        }
        return false;
    }

    private void backtrack(BFSInfo info, long principalId, Permission permission, boolean value, int level, boolean doLog) {
        if (doLog) {
            if (level == 0) {
                if (value) {
                    System.out.print(permission.name() + ": granted: ");
                } else {
                    System.out.print(permission.name() + ": denied: ");
                }
            }
            System.out.print(info.node.getType() + " (" + info.node.getUuid() + ") --> ");
        }
        info.node.storePermissionResolutionResult(principalId, permission, value);
        if (info.parent != null) {
            this.backtrack(info.parent, principalId, permission, value, level + 1, doLog);
        }
        if (doLog && level == 0) {
            System.out.println();
        }
    }

    private boolean hasEffectivePermissions(BFSInfo parent, Principal principal, Permission permission, PermissionResolutionMask mask, int level, AlreadyTraversed alreadyTraversed, Queue<BFSInfo> bfsNodes, boolean doLog) {
        if (alreadyTraversed.contains("Node", this.dbNode.getId())) {
            return false;
        }
        for (Class propagatingType : SchemaRelationshipNode.getPropagatingRelationshipTypes()) {
            Object template = AbstractNode.getRelationshipForType(propagatingType);
            Direction direction = template.getDirectionForType(this.entityType);
            if (Direction.BOTH.equals((Object)direction)) continue;
            Iterable iterable = this.getRelationshipsAsSuperUser(propagatingType);
            for (Relation source : iterable) {
                PermissionPropagation perm;
                Relation rel;
                if (!(source instanceof PermissionPropagation) || !this.propagationAllowed(this, rel = source, (perm = (PermissionPropagation)((Object)source)).getPropagationDirection(), doLog)) continue;
                this.applyCurrentStep(perm, mask);
                if (!mask.allowsPermission(permission)) continue;
                AbstractNode otherNode = (AbstractNode)rel.getOtherNode(this);
                if (otherNode.isGranted(permission, principal, mask, level + 1, alreadyTraversed, false, doLog)) {
                    otherNode.storePermissionResolutionResult(principal.getId(), permission, true);
                    return true;
                }
                bfsNodes.add(new BFSInfo(parent, otherNode));
            }
        }
        return false;
    }

    private boolean propagationAllowed(AbstractNode thisNode, RelationshipInterface rel, SchemaRelationshipNode.Direction propagationDirection, boolean doLog) {
        long thisNodeId;
        if (propagationDirection.equals((Object)SchemaRelationshipNode.Direction.Both)) {
            return true;
        }
        if (propagationDirection.equals((Object)SchemaRelationshipNode.Direction.None)) {
            return false;
        }
        long sourceNodeId = rel.getSourceNode().getId();
        if (sourceNodeId == (thisNodeId = thisNode.getId())) {
            switch (propagationDirection) {
                case Out: {
                    return false;
                }
                case In: {
                    return true;
                }
            }
        } else {
            switch (propagationDirection) {
                case Out: {
                    return true;
                }
                case In: {
                    return false;
                }
            }
        }
        return false;
    }

    private void applyCurrentStep(PermissionPropagation rel, PermissionResolutionMask mask) {
        switch (rel.getReadPropagation()) {
            case Add: 
            case Keep: {
                mask.addRead();
                break;
            }
            case Remove: {
                mask.removeRead();
                break;
            }
        }
        switch (rel.getWritePropagation()) {
            case Add: 
            case Keep: {
                mask.addWrite();
                break;
            }
            case Remove: {
                mask.removeWrite();
                break;
            }
        }
        switch (rel.getDeletePropagation()) {
            case Add: 
            case Keep: {
                mask.addDelete();
                break;
            }
            case Remove: {
                mask.removeDelete();
                break;
            }
        }
        switch (rel.getAccessControlPropagation()) {
            case Add: 
            case Keep: {
                mask.addAccessControl();
                break;
            }
            case Remove: {
                mask.removeAccessControl();
                break;
            }
        }
        mask.handleProperties(rel.getDeltaProperties());
    }

    private Boolean getPermissionResolutionResult(long principalId, Permission permission) {
        PermissionResolutionResult result;
        Map<Long, PermissionResolutionResult> permissionResolutionCache = globalPermissionResolutionCache.get(this.getId());
        if (permissionResolutionCache == null) {
            permissionResolutionCache = new HashMap<Long, PermissionResolutionResult>();
            globalPermissionResolutionCache.put(this.getId(), permissionResolutionCache);
        }
        if ((result = permissionResolutionCache.get(principalId)) != null) {
            if (permission.equals(Permission.read)) {
                return result.read;
            }
            if (permission.equals(Permission.write)) {
                return result.write;
            }
            if (permission.equals(Permission.delete)) {
                return result.delete;
            }
            if (permission.equals(Permission.accessControl)) {
                return result.accessControl;
            }
        }
        return null;
    }

    private void storePermissionResolutionResult(long principalId, Permission permission, boolean value) {
        PermissionResolutionResult result;
        Map<Long, PermissionResolutionResult> permissionResolutionCache = globalPermissionResolutionCache.get(this.getId());
        if (permissionResolutionCache == null) {
            permissionResolutionCache = new HashMap<Long, PermissionResolutionResult>();
            globalPermissionResolutionCache.put(this.getId(), permissionResolutionCache);
        }
        if ((result = permissionResolutionCache.get(principalId)) == null) {
            result = new PermissionResolutionResult();
            permissionResolutionCache.put(principalId, result);
        }
        if (permission.equals(Permission.read) && (result.read == null || !result.read.booleanValue())) {
            result.read = value;
        }
        if (permission.equals(Permission.write) && (result.write == null || !result.write.booleanValue())) {
            result.write = value;
        }
        if (permission.equals(Permission.delete) && (result.delete == null || !result.delete.booleanValue())) {
            result.delete = value;
        }
        if (permission.equals(Permission.accessControl) && (result.accessControl == null || !result.accessControl.booleanValue())) {
            result.accessControl = value;
        }
    }

    @Override
    public final Security getSecurityRelationship(Principal p) {
        if (p == null) {
            return null;
        }
        for (Security r : this.getIncomingRelationshipsAsSuperUser(Security.class)) {
            if (r == null || !p.equals(r.getSourceNode())) continue;
            return r;
        }
        return null;
    }

    @Override
    public boolean onCreation(SecurityContext securityContext, ErrorBuffer errorBuffer) throws FrameworkException {
        return true;
    }

    @Override
    public boolean onModification(SecurityContext securityContext, ErrorBuffer errorBuffer, ModificationQueue modificationQueue) throws FrameworkException {
        AbstractNode.clearPermissionResolutionCache();
        return true;
    }

    @Override
    public boolean onDeletion(SecurityContext securityContext, ErrorBuffer errorBuffer, PropertyMap properties) throws FrameworkException {
        AbstractNode.clearPermissionResolutionCache();
        return true;
    }

    @Override
    public void afterCreation(SecurityContext securityContext) {
    }

    @Override
    public void afterModification(SecurityContext securityContext) {
    }

    @Override
    public void afterDeletion(SecurityContext securityContext, PropertyMap properties) {
    }

    @Override
    public void ownerModified(SecurityContext securityContext) {
        AbstractNode.clearPermissionResolutionCache();
    }

    @Override
    public void securityModified(SecurityContext securityContext) {
        AbstractNode.clearPermissionResolutionCache();
    }

    @Override
    public void locationModified(SecurityContext securityContext) {
        AbstractNode.clearPermissionResolutionCache();
    }

    @Override
    public void propagatedModification(SecurityContext securityContext) {
        AbstractNode.clearPermissionResolutionCache();
    }

    @Override
    public boolean isValid(ErrorBuffer errorBuffer) {
        boolean valid = true;
        valid &= ValidationHelper.isValidStringNotBlank(this, id, errorBuffer);
        valid &= ValidationHelper.isValidGloballyUniqueProperty(this, id, errorBuffer);
        valid &= ValidationHelper.isValidStringMatchingRegex(this, id, "[a-fA-F0-9]{32}", errorBuffer);
        return valid &= ValidationHelper.isValidStringNotBlank(this, type, errorBuffer);
    }

    @Override
    public final boolean isVisibleToPublicUsers() {
        return this.getVisibleToPublicUsers();
    }

    @Override
    public final boolean isVisibleToAuthenticatedUsers() {
        return (Boolean)this.getProperty(visibleToAuthenticatedUsers);
    }

    @Override
    public final boolean isNotHidden() {
        return !this.getHidden();
    }

    @Override
    public final boolean isHidden() {
        return this.getHidden();
    }

    @Override
    public final Date getVisibilityStartDate() {
        return (Date)this.getProperty(visibilityStartDate);
    }

    @Override
    public final Date getVisibilityEndDate() {
        return (Date)this.getProperty(visibilityEndDate);
    }

    @Override
    public final Date getCreatedDate() {
        return (Date)this.getProperty(createdDate);
    }

    @Override
    public final Date getLastModifiedDate() {
        return (Date)this.getProperty(lastModifiedDate);
    }

    public final boolean isNotDeleted() {
        return !this.getDeleted();
    }

    @Override
    public final boolean isDeleted() {
        return this.getDeleted();
    }

    public final boolean isRootNode() {
        return this.getId() == 0L;
    }

    public final boolean isVisible() {
        return this.securityContext.isVisible(this);
    }

    @Override
    public <T> Object setProperty(PropertyKey<T> key, T value) throws FrameworkException {
        if (!key.equals(GraphObject.id) && !this.isGranted(Permission.write, this.securityContext)) {
            this.internalSystemPropertiesUnlocked = false;
            this.readOnlyPropertiesUnlocked = false;
            throw new FrameworkException(403, "Modification not permitted.");
        }
        T oldValue = this.getProperty(key);
        if (oldValue == null && value != null || oldValue != null && !oldValue.equals(value) || key instanceof FunctionProperty) {
            return this.setPropertyInternal(key, value);
        }
        this.internalSystemPropertiesUnlocked = false;
        this.readOnlyPropertiesUnlocked = false;
        return null;
    }

    @Override
    public void setProperties(SecurityContext securityContext, PropertyMap properties) throws FrameworkException {
        if (!this.isGranted(Permission.write, securityContext)) {
            this.internalSystemPropertiesUnlocked = false;
            this.readOnlyPropertiesUnlocked = false;
            throw new FrameworkException(403, "Modification not permitted.");
        }
        for (PropertyKey key : properties.keySet()) {
            if (key.equals(GraphObject.id) || this.dbNode == null || !this.dbNode.hasProperty(key.dbName())) continue;
            if (key.isSystemInternal() && !this.internalSystemPropertiesUnlocked) {
                throw new FrameworkException(422, "Property " + key.jsonName() + " is an internal system property", new InternalSystemPropertyToken(this.getClass().getSimpleName(), key));
            }
            if (!key.isReadOnly() && !key.isWriteOnce() || this.readOnlyPropertiesUnlocked || securityContext.isSuperUser()) continue;
            throw new FrameworkException(422, "Property " + key.jsonName() + " is read-only", new ReadOnlyPropertyToken(this.getClass().getSimpleName(), key));
        }
        NodeInterface.super.setProperties(securityContext, properties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> Object setPropertyInternal(PropertyKey<T> key, T value) throws FrameworkException {
        if (key == null) {
            logger.error("Tried to set property with null key (action was denied)");
            throw new FrameworkException(422, "Tried to set property with null key (action was denied)", new NullArgumentToken(this.getClass().getSimpleName(), base));
        }
        try {
            if (this.dbNode != null && this.dbNode.hasProperty(key.dbName())) {
                if (key.isSystemInternal() && !this.internalSystemPropertiesUnlocked) {
                    throw new FrameworkException(422, "Property " + key.jsonName() + " is an internal system property", new InternalSystemPropertyToken(this.getClass().getSimpleName(), key));
                }
                if ((key.isReadOnly() || key.isWriteOnce()) && !this.readOnlyPropertiesUnlocked && !this.securityContext.isSuperUser()) {
                    throw new FrameworkException(422, "Property " + key.jsonName() + " is read-only", new ReadOnlyPropertyToken(this.getClass().getSimpleName(), key));
                }
            }
            Object object = key.setProperty(this.securityContext, this, value);
            return object;
        }
        finally {
            this.internalSystemPropertiesUnlocked = false;
            this.readOnlyPropertiesUnlocked = false;
        }
    }

    @Override
    public final void updateInIndex() {
        this.removeFromIndex();
        this.addToIndex();
    }

    @Override
    public final void removeFromIndex() {
        Index<Node> index = Services.getInstance().getService(NodeService.class).getNodeIndex();
        index.remove((Object)this.dbNode);
    }

    public final void removeFromIndex(PropertyKey key) {
        Index<Node> index = Services.getInstance().getService(NodeService.class).getNodeIndex();
        index.remove((Object)this.dbNode, key.dbName());
    }

    @Override
    public final void indexPassiveProperties() {
        for (PropertyKey key : StructrApp.getConfiguration().getPropertySet(this.entityType, "all")) {
            if (!key.isPassivelyIndexed()) continue;
            key.index(this, this.getProperty(key));
        }
    }

    public static void clearRelationshipTemplateInstanceCache() {
        relationshipTemplateInstanceCache.clear();
    }

    public static void clearPermissionResolutionCache() {
        globalPermissionResolutionCache.clear();
    }

    public static <A extends NodeInterface, B extends NodeInterface, R extends Relation<A, B, ?, ?>> R getRelationshipForType(Class<R> type) {
        Relation instance = (Relation)relationshipTemplateInstanceCache.get((Object)type.getName());
        if (instance == null) {
            try {
                instance = (Relation)type.newInstance();
                relationshipTemplateInstanceCache.put((Object)type.getName(), (Object)instance);
            }
            catch (Throwable t) {
                logger.warn("", t);
            }
        }
        return (R)instance;
    }

    @Override
    public final String getPropertyWithVariableReplacement(ActionContext renderContext, PropertyKey<String> key) throws FrameworkException {
        String value = this.getProperty(key);
        String result = null;
        try {
            result = Scripting.replaceVariables(renderContext, this, value);
        }
        catch (Throwable t) {
            logger.warn("Scripting error in {} {}:\n{}", new Object[]{key.dbName(), this.getUuid(), value, t});
        }
        return result;
    }

    @Override
    public final Object evaluate(ActionContext actionContext, String key, String defaultValue) throws FrameworkException {
        switch (key) {
            case "owner": {
                return this.getOwnerNode();
            }
            case "_path": {
                if (this.rawPathSegment != null) {
                    return new RelationshipFactory(actionContext.getSecurityContext()).adapt(this.rawPathSegment);
                }
                return null;
            }
        }
        Object value = this.getProperty(StructrApp.getConfiguration().getPropertyKeyForJSONName(this.entityType, key), (Predicate<GraphObject>)actionContext.getPredicate());
        if (value != null) {
            return value;
        }
        value = this.invokeMethod(key, Collections.EMPTY_MAP, false);
        if (value != null) {
            return value;
        }
        return Function.numberOrString(defaultValue);
    }

    @Override
    public final Object invokeMethod(String methodName, Map<String, Object> propertySet, boolean throwExceptionForUnknownMethods) throws FrameworkException {
        Method method = StructrApp.getConfiguration().getExportedMethodsForType(this.entityType).get(methodName);
        if (method != null) {
            try {
                if (method.getParameterTypes().length == 1 && method.getParameterTypes()[0].equals(Map.class)) {
                    return method.invoke((Object)this, propertySet);
                }
                return method.invoke((Object)this, this.extractParameters(propertySet, method.getParameterTypes()));
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException t) {
                if (t instanceof FrameworkException) {
                    throw (FrameworkException)t;
                }
                if (t.getCause() instanceof FrameworkException) {
                    throw (FrameworkException)t.getCause();
                }
                logger.debug("Unable to invoke method {}: {}", new Object[]{methodName, t.getMessage()});
                logger.warn("", (Throwable)t);
            }
        }
        if (throwExceptionForUnknownMethods) {
            throw new FrameworkException(400, "Method " + methodName + " not found in type " + this.getType());
        }
        return null;
    }

    private Object[] extractParameters(Map<String, Object> properties, Class[] parameterTypes) {
        ArrayList<Object> values = new ArrayList<Object>(properties.values());
        ArrayList<Object> parameters = new ArrayList<Object>();
        int index = 0;
        if (values.size() == parameterTypes.length) {
            for (Class parameterType : parameterTypes) {
                Object value;
                if ((value = this.convert(values.get(index++), parameterType)) == null) continue;
                parameters.add(value);
            }
        }
        return parameters.toArray(new Object[0]);
    }

    private Object convert(Object value, Class type) {
        Object convertedObject = null;
        if (type.equals(String.class)) {
            return value.toString();
        }
        if (value instanceof Number) {
            Number number = (Number)value;
            if (type.equals(Integer.class) || type.equals(Integer.TYPE)) {
                return number.intValue();
            }
            if (type.equals(Long.class) || type.equals(Long.TYPE)) {
                return number.longValue();
            }
            if (type.equals(Double.class) || type.equals(Double.TYPE)) {
                return number.doubleValue();
            }
            if (type.equals(Float.class) || type.equals(Float.TYPE)) {
                return Float.valueOf(number.floatValue());
            }
            if (type.equals(Short.class) || type.equals(Integer.TYPE)) {
                return number.shortValue();
            }
            if (type.equals(Byte.class) || type.equals(Byte.TYPE)) {
                return number.byteValue();
            }
        } else {
            if (value instanceof List) {
                return value;
            }
            if (value instanceof Map) {
                return value;
            }
        }
        try {
            Method valueOf = type.getMethod("valueOf", String.class);
            if (valueOf != null) {
                convertedObject = valueOf.invoke(null, value.toString());
            } else {
                logger.warn("Unable to find static valueOf method for type {}", (Object)type);
            }
        }
        catch (Throwable t) {
            logger.warn("Unable to deserialize value {} of type {}, Class has no static valueOf method.", new Object[]{value, type});
        }
        return convertedObject;
    }

    @Override
    public final void grant(Permission permission, Principal principal) throws FrameworkException {
        if (!this.isGranted(Permission.accessControl, this.securityContext)) {
            throw new FrameworkException(403, "Access control not permitted");
        }
        Security secRel = this.getSecurityRelationship(principal);
        if (secRel == null) {
            try {
                secRel = StructrApp.getInstance().create(principal, this, Security.class);
            }
            catch (FrameworkException ex) {
                logger.error("Could not create security relationship!", (Throwable)ex);
            }
        }
        if (secRel != null) {
            secRel.addPermission(permission);
        }
    }

    @Override
    public final void revoke(Permission permission, Principal principal) throws FrameworkException {
        if (!this.isGranted(Permission.accessControl, this.securityContext)) {
            throw new FrameworkException(403, "Access control not permitted");
        }
        Security secRel = this.getSecurityRelationship(principal);
        if (secRel == null) {
            logger.error("Could not create revoke permission, no security relationship exists!");
        } else {
            secRel.removePermission(permission);
        }
    }

    @Override
    public final void setRawPathSegment(Relationship rawPathSegment) {
        this.rawPathSegment = rawPathSegment;
    }

    @Override
    public final Relationship getRawPathSegment() {
        return this.rawPathSegment;
    }

    public final void revokeAll() throws FrameworkException {
        if (!this.isGranted(Permission.accessControl, this.securityContext)) {
            throw new FrameworkException(403, "Access control not permitted");
        }
        App app = StructrApp.getInstance();
        for (Security security : this.getIncomingRelationshipsAsSuperUser(Security.class)) {
            app.delete(security);
        }
    }

    public List<Security> getSecurityRelationships() {
        List grants = Iterables.toList(this.getIncomingRelationshipsAsSuperUser(Security.class));
        Collections.sort(grants, new Comparator<Security>(){

            @Override
            public int compare(Security o1, Security o2) {
                String n2;
                Principal p1 = (Principal)o1.getSourceNode();
                Principal p2 = (Principal)o2.getSourceNode();
                String n1 = p1 != null ? (String)p1.getProperty(name) : "empty";
                String string = n2 = p2 != null ? (String)p2.getProperty(name) : "empty";
                if (n1 != null && n2 != null) {
                    return n1.compareTo(n2);
                }
                if (n1 != null) {
                    return 1;
                }
                if (n2 != null) {
                    return -1;
                }
                return 0;
            }
        });
        return grants;
    }

    @Override
    public List<GraphObject> getSyncData() throws FrameworkException {
        return new ArrayList<GraphObject>();
    }

    @Override
    public final boolean isNode() {
        return true;
    }

    @Override
    public final boolean isRelationship() {
        return false;
    }

    @Override
    public final NodeInterface getSyncNode() {
        return this;
    }

    @Override
    public final RelationshipInterface getSyncRelationship() {
        throw new ClassCastException(this.getClass() + " cannot be cast to org.structr.core.graph.RelationshipInterface");
    }

    @Override
    public CMISInfo getCMISInfo() {
        return this;
    }

    @Override
    public BaseTypeId getBaseTypeId() {
        return BaseTypeId.CMIS_ITEM;
    }

    @Override
    public CMISFolderInfo getFolderInfo() {
        return null;
    }

    @Override
    public CMISDocumentInfo getDocumentInfo() {
        return null;
    }

    @Override
    public CMISItemInfo geItemInfo() {
        return this;
    }

    @Override
    public CMISRelationshipInfo getRelationshipInfo() {
        return null;
    }

    @Override
    public CMISPolicyInfo getPolicyInfo() {
        return null;
    }

    @Override
    public CMISSecondaryInfo getSecondaryInfo() {
        return null;
    }

    @Override
    public String getCreatedBy() {
        return (String)this.getProperty(createdBy);
    }

    @Override
    public String getLastModifiedBy() {
        return (String)this.getProperty(lastModifiedBy);
    }

    @Override
    public GregorianCalendar getLastModificationDate() {
        Date creationDate = (Date)this.getProperty(lastModifiedDate);
        if (creationDate != null) {
            GregorianCalendar calendar = new GregorianCalendar();
            calendar.setTime(creationDate);
            return calendar;
        }
        return null;
    }

    @Override
    public GregorianCalendar getCreationDate() {
        Date creationDate = (Date)this.getProperty(createdDate);
        if (creationDate != null) {
            GregorianCalendar calendar = new GregorianCalendar();
            calendar.setTime(creationDate);
            return calendar;
        }
        return null;
    }

    @Override
    public PropertyMap getDynamicProperties() {
        PropertyMap propertyMap = new PropertyMap();
        Class<?> type = this.getClass();
        for (PropertyKey key : StructrApp.getConfiguration().getPropertySet(type, "all")) {
            PropertyType dataType;
            if (!key.isDynamic() && !key.isCMISProperty() || (dataType = key.getDataType()) == null) continue;
            propertyMap.put(key, this.getProperty(key));
        }
        return propertyMap;
    }

    @Override
    public AllowableActions getAllowableActions() {
        return new StructrItemActions();
    }

    @Override
    public List<Ace> getAccessControlEntries() {
        LinkedList<Ace> entries = new LinkedList<Ace>();
        for (Security security : this.getIncomingRelationshipsAsSuperUser(Security.class)) {
            if (security == null) continue;
            entries.add(new AceEntry(security));
        }
        return entries;
    }

    private static class PermissionResolutionResult {
        Boolean read = false;
        Boolean write = false;
        Boolean delete = false;
        Boolean accessControl = false;

        private PermissionResolutionResult() {
        }
    }

    private static class BFSInfo {
        public AbstractNode node = null;
        public BFSInfo parent = null;
        public int level = 0;

        public BFSInfo(BFSInfo parent, AbstractNode node) {
            this.parent = parent;
            this.node = node;
            if (parent != null) {
                this.level = parent.level + 1;
            }
        }
    }

    private static class AlreadyTraversed {
        private Map<String, Set<Long>> sets = new LinkedHashMap<String, Set<Long>>();

        private AlreadyTraversed() {
        }

        public boolean contains(String key, Long id) {
            Set<Long> set = this.sets.get(key);
            if (set == null) {
                set = new HashSet<Long>();
                this.sets.put(key, set);
            }
            return !set.add(id);
        }

        public int size(String key) {
            Set<Long> set = this.sets.get(key);
            if (set != null) {
                return set.size();
            }
            return 0;
        }
    }

    private static class AceEntry
    extends CMISExtensionsData
    implements Ace,
    org.apache.chemistry.opencmis.commons.data.Principal {
        private final List<String> permissions = new LinkedList<String>();
        private String principalId = null;

        public AceEntry(Security security) {
            Principal principal = (Principal)security.getSourceNode();
            if (principal != null) {
                this.principalId = (String)principal.getProperty(Principal.name);
            }
            this.permissions.addAll(security.getPermissions());
        }

        public org.apache.chemistry.opencmis.commons.data.Principal getPrincipal() {
            return this;
        }

        public String getPrincipalId() {
            return this.principalId;
        }

        public List<String> getPermissions() {
            return this.permissions;
        }

        public boolean isDirect() {
            return true;
        }

        public String getId() {
            return this.getPrincipalId();
        }
    }
}

