/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core.entity;

import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.chemistry.opencmis.commons.enums.PropertyType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.api.Predicate;
import org.structr.api.graph.Direction;
import org.structr.api.graph.Node;
import org.structr.api.graph.PropertyContainer;
import org.structr.api.graph.Relationship;
import org.structr.api.graph.RelationshipType;
import org.structr.api.index.Index;
import org.structr.cmis.CMISInfo;
import org.structr.common.SecurityContext;
import org.structr.common.ValidationHelper;
import org.structr.common.View;
import org.structr.common.error.ErrorBuffer;
import org.structr.common.error.FrameworkException;
import org.structr.common.error.IdNotFoundToken;
import org.structr.common.error.InternalSystemPropertyToken;
import org.structr.common.error.NullArgumentToken;
import org.structr.common.error.ReadOnlyPropertyToken;
import org.structr.core.GraphObject;
import org.structr.core.Services;
import org.structr.core.app.App;
import org.structr.core.app.StructrApp;
import org.structr.core.converter.PropertyConverter;
import org.structr.core.entity.AbstractNode;
import org.structr.core.graph.ModificationQueue;
import org.structr.core.graph.NodeFactory;
import org.structr.core.graph.NodeInterface;
import org.structr.core.graph.NodeService;
import org.structr.core.graph.RelationshipInterface;
import org.structr.core.property.IntProperty;
import org.structr.core.property.Property;
import org.structr.core.property.PropertyKey;
import org.structr.core.property.PropertyMap;
import org.structr.core.property.RelationshipTypeProperty;
import org.structr.core.property.SourceId;
import org.structr.core.property.SourceNodeProperty;
import org.structr.core.property.TargetId;
import org.structr.core.property.TargetNodeProperty;
import org.structr.core.script.Scripting;
import org.structr.schema.action.ActionContext;
import org.structr.schema.action.Function;

public abstract class AbstractRelationship<S extends NodeInterface, T extends NodeInterface>
implements Comparable<AbstractRelationship>,
RelationshipInterface {
    private static final Logger logger = LoggerFactory.getLogger((String)AbstractRelationship.class.getName());
    public static final Property<Integer> cascadeDelete = new IntProperty("cascadeDelete");
    public static final Property<String> relType = new RelationshipTypeProperty();
    public static final SourceId sourceId = new SourceId("sourceId");
    public static final TargetId targetId = new TargetId("targetId");
    public static final Property<NodeInterface> sourceNodeProperty = new SourceNodeProperty("sourceNode");
    public static final Property<NodeInterface> targetNodeProperty = new TargetNodeProperty("targetNode");
    public static final View defaultView = new View(AbstractRelationship.class, "public", id, type, relType, sourceId, targetId);
    public static final View uiView = new View(AbstractRelationship.class, "ui", id, type, relType, sourceId, targetId);
    public static final View graphView = new View(AbstractRelationship.class, "_graph", id, type, relType, sourceNodeProperty, targetNodeProperty);
    public boolean internalSystemPropertiesUnlocked = false;
    private boolean readOnlyPropertiesUnlocked = false;
    private String cachedEndNodeId = null;
    private String cachedStartNodeId = null;
    protected SecurityContext securityContext = null;
    protected Relationship dbRelationship = null;
    protected Class entityType = null;

    public AbstractRelationship() {
    }

    public AbstractRelationship(SecurityContext securityContext, Relationship dbRel, Class entityType) {
        this.init(securityContext, dbRel, entityType);
    }

    @Override
    public final void init(SecurityContext securityContext, Relationship dbRel, Class entityType) {
        this.dbRelationship = dbRel;
        this.entityType = entityType;
        this.securityContext = securityContext;
    }

    public Property<String> getSourceIdProperty() {
        return sourceId;
    }

    public Property<String> getTargetIdProperty() {
        return targetId;
    }

    @Override
    public void onRelationshipCreation() {
    }

    @Override
    public Class getEntityType() {
        return this.entityType;
    }

    @Override
    public void onRelationshipInstantiation() {
        try {
            if (this.dbRelationship != null) {
                Node startNode = this.dbRelationship.getStartNode();
                Node endNode = this.dbRelationship.getEndNode();
                if (startNode != null && endNode != null && startNode.hasProperty(GraphObject.id.dbName()) && endNode.hasProperty(GraphObject.id.dbName())) {
                    this.cachedStartNodeId = (String)startNode.getProperty(GraphObject.id.dbName());
                    this.cachedEndNodeId = (String)endNode.getProperty(GraphObject.id.dbName());
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public void onRelationshipDeletion() {
    }

    @Override
    public final void setSecurityContext(SecurityContext securityContext) {
        this.securityContext = securityContext;
    }

    @Override
    public final SecurityContext getSecurityContext() {
        return this.securityContext;
    }

    @Override
    public final void unlockSystemPropertiesOnce() {
        this.internalSystemPropertiesUnlocked = true;
        this.unlockReadOnlyPropertiesOnce();
    }

    @Override
    public final void unlockReadOnlyPropertiesOnce() {
        this.readOnlyPropertiesUnlocked = true;
    }

    @Override
    public final void removeProperty(PropertyKey key) throws FrameworkException {
        this.dbRelationship.removeProperty(key.dbName());
        this.removeFromIndex(key);
    }

    public boolean equals(Object o) {
        return o != null && new Integer(this.hashCode()).equals(new Integer(o.hashCode()));
    }

    public int hashCode() {
        if (this.dbRelationship == null) {
            return super.hashCode();
        }
        return Long.valueOf(this.dbRelationship.getId()).hashCode();
    }

    @Override
    public final int compareTo(AbstractRelationship rel) {
        if (rel == null) {
            return -1;
        }
        return Long.valueOf(this.getId()).compareTo(rel.getId());
    }

    @Override
    public int cascadeDelete() {
        Integer value = this.getProperty(cascadeDelete);
        return value != null ? value : 0;
    }

    public boolean propagatesModifications(Direction direction) {
        return false;
    }

    @Override
    public final PropertyKey getDefaultSortKey() {
        return null;
    }

    @Override
    public final String getDefaultSortOrder() {
        return "asc";
    }

    @Override
    public final long getId() {
        return this.getInternalId();
    }

    @Override
    public final String getUuid() {
        return (String)this.getProperty(id);
    }

    public final long getRelationshipId() {
        return this.getInternalId();
    }

    public final long getInternalId() {
        return this.dbRelationship.getId();
    }

    @Override
    public final PropertyMap getProperties() throws FrameworkException {
        LinkedHashMap<String, Object> properties = new LinkedHashMap<String, Object>();
        for (String key : this.dbRelationship.getPropertyKeys()) {
            properties.put(key, this.dbRelationship.getProperty(key));
        }
        return PropertyMap.databaseTypeToJavaType(this.securityContext, this, properties);
    }

    @Override
    public <T> T getProperty(PropertyKey<T> key) {
        return this.getProperty(key, true, null);
    }

    @Override
    public <T> T getProperty(PropertyKey<T> key, Predicate<GraphObject> predicate) {
        return this.getProperty(key, true, predicate);
    }

    private <T> T getProperty(PropertyKey<T> key, boolean applyConverter, Predicate<GraphObject> predicate) {
        if (key == null || key.dbName() == null) {
            return null;
        }
        return key.getProperty(this.securityContext, this, applyConverter, predicate);
    }

    @Override
    public final <T> Comparable getComparableProperty(PropertyKey<T> key) {
        if (key != null) {
            T propertyValue = this.getProperty(key, false, null);
            PropertyConverter<T, ?> converter = key.databaseConverter(this.securityContext, this);
            if (converter != null) {
                try {
                    return converter.convertForSorting(propertyValue);
                }
                catch (FrameworkException fex) {
                    logger.warn("Unable to convert property {} of type {}: {}", new Object[]{key.dbName(), this.getClass().getSimpleName(), fex.getMessage()});
                }
            }
            if (propertyValue instanceof Comparable) {
                return (Comparable)propertyValue;
            }
            if (propertyValue != null) {
                return propertyValue.toString();
            }
        }
        return null;
    }

    @Override
    public Relationship getRelationship() {
        return this.dbRelationship;
    }

    public final T getTargetNode() {
        NodeFactory nodeFactory = new NodeFactory(this.securityContext);
        return nodeFactory.instantiate(this.dbRelationship.getEndNode());
    }

    public final T getTargetNodeAsSuperUser() {
        NodeFactory nodeFactory = new NodeFactory(SecurityContext.getSuperUserInstance());
        return nodeFactory.instantiate(this.dbRelationship.getEndNode());
    }

    public final S getSourceNode() {
        NodeFactory nodeFactory = new NodeFactory(this.securityContext);
        return (S)nodeFactory.instantiate(this.dbRelationship.getStartNode());
    }

    public final S getSourceNodeAsSuperUser() {
        NodeFactory nodeFactory = new NodeFactory(SecurityContext.getSuperUserInstance());
        return (S)nodeFactory.instantiate(this.dbRelationship.getStartNode());
    }

    @Override
    public final NodeInterface getOtherNode(NodeInterface node) {
        NodeFactory nodeFactory = new NodeFactory(this.securityContext);
        return nodeFactory.instantiate(this.dbRelationship.getOtherNode(node.getNode()));
    }

    public final NodeInterface getOtherNodeAsSuperUser(NodeInterface node) {
        NodeFactory nodeFactory = new NodeFactory(SecurityContext.getSuperUserInstance());
        return nodeFactory.instantiate(this.dbRelationship.getOtherNode(node.getNode()));
    }

    @Override
    public final RelationshipType getRelType() {
        if (this.dbRelationship != null) {
            return this.dbRelationship.getType();
        }
        return null;
    }

    public final Iterable<PropertyKey> getPropertyKeys() {
        return this.getPropertyKeys("all");
    }

    @Override
    public Iterable<PropertyKey> getPropertyKeys(String propertyView) {
        return StructrApp.getConfiguration().getPropertySet(this.getClass(), propertyView);
    }

    public final Map<String, Long> getRelationshipInfo(Direction direction) {
        return null;
    }

    public final List<AbstractRelationship> getRelationships(String type, Direction dir) {
        return null;
    }

    @Override
    public final String getType() {
        return this.getRelType().name();
    }

    @Override
    public final PropertyContainer getPropertyContainer() {
        return this.dbRelationship;
    }

    @Override
    public final String getSourceNodeId() {
        return this.cachedStartNodeId;
    }

    @Override
    public final String getTargetNodeId() {
        return this.cachedEndNodeId;
    }

    public final String getOtherNodeId(AbstractNode node) {
        return (String)this.getOtherNode(node).getProperty(id);
    }

    @Override
    public boolean onCreation(SecurityContext securityContext, ErrorBuffer errorBuffer) throws FrameworkException {
        return this.isValid(errorBuffer);
    }

    @Override
    public boolean onModification(SecurityContext securityContext, ErrorBuffer errorBuffer, ModificationQueue modificationQueue) throws FrameworkException {
        return this.isValid(errorBuffer);
    }

    @Override
    public boolean onDeletion(SecurityContext securityContext, ErrorBuffer errorBuffer, PropertyMap properties) throws FrameworkException {
        return true;
    }

    @Override
    public void afterCreation(SecurityContext securityContext) {
    }

    @Override
    public void afterModification(SecurityContext securityContext) {
    }

    @Override
    public void afterDeletion(SecurityContext securityContext, PropertyMap properties) {
    }

    @Override
    public void ownerModified(SecurityContext securityContext) {
    }

    @Override
    public void securityModified(SecurityContext securityContext) {
    }

    @Override
    public void locationModified(SecurityContext securityContext) {
    }

    @Override
    public void propagatedModification(SecurityContext securityContext) {
    }

    @Override
    public boolean isValid(ErrorBuffer errorBuffer) {
        boolean valid = true;
        return valid &= ValidationHelper.isValidStringNotBlank(this, id, errorBuffer);
    }

    @Override
    public void setProperties(SecurityContext securityContext, PropertyMap properties) throws FrameworkException {
        for (PropertyKey key : properties.keySet()) {
            if (this.dbRelationship == null || !this.dbRelationship.hasProperty(key.dbName())) continue;
            if (key.isSystemInternal() && !this.internalSystemPropertiesUnlocked) {
                throw new FrameworkException(422, "Property " + key.jsonName() + " is an internal system property", new InternalSystemPropertyToken(this.getClass().getSimpleName(), key));
            }
            if (!key.isReadOnly() && !key.isWriteOnce() || this.readOnlyPropertiesUnlocked || securityContext.isSuperUser()) continue;
            throw new FrameworkException(422, "Property " + key.jsonName() + " is read-only", new ReadOnlyPropertyToken(this.getClass().getSimpleName(), key));
        }
        RelationshipInterface.super.setProperties(securityContext, properties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final <T> Object setProperty(PropertyKey<T> key, T value) throws FrameworkException {
        if (key == null) {
            logger.error("Tried to set property with null key (action was denied)");
            throw new FrameworkException(422, "Tried to set property with null key (action was denied)", new NullArgumentToken(this.getClass().getSimpleName(), base));
        }
        try {
            if (this.dbRelationship != null && this.dbRelationship.hasProperty(key.dbName())) {
                if (key.isSystemInternal() && !this.internalSystemPropertiesUnlocked) {
                    throw new FrameworkException(422, "Property " + key.jsonName() + " is an internal system property", new InternalSystemPropertyToken(this.getClass().getSimpleName(), key));
                }
                if ((key.isReadOnly() || key.isWriteOnce()) && !this.readOnlyPropertiesUnlocked && !this.securityContext.isSuperUser()) {
                    throw new FrameworkException(422, "Property " + key.jsonName() + " is read-only", new ReadOnlyPropertyToken(this.getClass().getSimpleName(), key));
                }
            }
            Object object = key.setProperty(this.securityContext, this, value);
            return object;
        }
        finally {
            this.internalSystemPropertiesUnlocked = false;
            this.readOnlyPropertiesUnlocked = false;
        }
    }

    @Override
    public final void updateInIndex() {
        this.removeFromIndex();
        this.addToIndex();
    }

    @Override
    public final void removeFromIndex() {
        Index<Relationship> index = Services.getInstance().getService(NodeService.class).getRelationshipIndex();
        index.remove((Object)this.dbRelationship);
    }

    public final void removeFromIndex(PropertyKey key) {
        Index<Relationship> index = Services.getInstance().getService(NodeService.class).getRelationshipIndex();
        index.remove((Object)this.dbRelationship, key.dbName());
    }

    @Override
    public final void indexPassiveProperties() {
        for (PropertyKey key : StructrApp.getConfiguration().getPropertySet(this.entityType, "all")) {
            if (!key.isPassivelyIndexed()) continue;
            key.index(this, this.getProperty(key));
        }
    }

    @Override
    public final void setSourceNodeId(String sourceNodeId) throws FrameworkException {
        if (this.getSourceNodeId().equals(sourceNodeId)) {
            return;
        }
        App app = StructrApp.getInstance(this.securityContext);
        NodeInterface newStartNode = app.getNodeById(sourceNodeId);
        T endNode = this.getTargetNode();
        Class<?> relationType = this.getClass();
        PropertyMap _props = this.getProperties();
        String type = this.getClass().getSimpleName();
        if (newStartNode == null) {
            throw new FrameworkException(404, "Node with ID " + sourceNodeId + " not found", new IdNotFoundToken(type, sourceNodeId));
        }
        app.delete(this);
        app.create(newStartNode, endNode, relationType, _props);
    }

    @Override
    public final void setTargetNodeId(String targetNodeId) throws FrameworkException {
        if (this.getTargetNodeId().equals(targetNodeId)) {
            return;
        }
        App app = StructrApp.getInstance(this.securityContext);
        NodeInterface newTargetNode = app.getNodeById(targetNodeId);
        S startNode = this.getSourceNode();
        Class<?> relationType = this.getClass();
        PropertyMap _props = this.getProperties();
        String type = this.getClass().getSimpleName();
        if (newTargetNode == null) {
            throw new FrameworkException(404, "Node with ID " + targetNodeId + " not found", new IdNotFoundToken(type, targetNodeId));
        }
        app.delete(this);
        app.create(startNode, newTargetNode, relationType, _props);
    }

    @Override
    public final String getPropertyWithVariableReplacement(ActionContext renderContext, PropertyKey<String> key) throws FrameworkException {
        return Scripting.replaceVariables(renderContext, this, this.getProperty(key));
    }

    @Override
    public final Object evaluate(ActionContext actionContext, String key, String defaultValue) throws FrameworkException {
        switch (key) {
            case "_source": {
                return this.getSourceNode();
            }
            case "_target": {
                return this.getTargetNode();
            }
        }
        T value = this.getProperty(StructrApp.getConfiguration().getPropertyKeyForJSONName(this.entityType, key), (Predicate<GraphObject>)actionContext.getPredicate());
        if (value == null) {
            return Function.numberOrString(defaultValue);
        }
        return value;
    }

    @Override
    public Object invokeMethod(String methodName, Map<String, Object> parameters, boolean throwException) throws FrameworkException {
        throw new UnsupportedOperationException("Invoking a method on a relationship is not supported at the moment.");
    }

    protected final Direction getDirectionForType(Class<S> sourceType, Class<T> targetType, Class<? extends NodeInterface> type) {
        if (sourceType.equals(type) && targetType.equals(type)) {
            return Direction.BOTH;
        }
        if (sourceType.equals(type)) {
            return Direction.OUTGOING;
        }
        if (targetType.equals(type)) {
            return Direction.INCOMING;
        }
        if (sourceType.isAssignableFrom(type)) {
            return Direction.OUTGOING;
        }
        if (targetType.isAssignableFrom(type)) {
            return Direction.INCOMING;
        }
        if (type.isAssignableFrom(sourceType)) {
            return Direction.OUTGOING;
        }
        if (type.isAssignableFrom(targetType)) {
            return Direction.INCOMING;
        }
        return Direction.BOTH;
    }

    @Override
    public final CMISInfo getCMISInfo() {
        return null;
    }

    @Override
    public List<GraphObject> getSyncData() {
        return new ArrayList<GraphObject>();
    }

    @Override
    public boolean isNode() {
        return false;
    }

    @Override
    public boolean isRelationship() {
        return true;
    }

    @Override
    public NodeInterface getSyncNode() {
        throw new ClassCastException(this.getClass() + " cannot be cast to org.structr.core.graph.NodeInterface");
    }

    @Override
    public RelationshipInterface getSyncRelationship() {
        return this;
    }

    public String getCreatedBy() {
        return (String)this.getProperty(AbstractNode.createdBy);
    }

    public String getLastModifiedBy() {
        return (String)this.getProperty(AbstractNode.lastModifiedBy);
    }

    public GregorianCalendar getLastModificationDate() {
        Date creationDate = (Date)this.getProperty(AbstractNode.lastModifiedDate);
        if (creationDate != null) {
            GregorianCalendar calendar = new GregorianCalendar();
            calendar.setTime(creationDate);
            return calendar;
        }
        return null;
    }

    public GregorianCalendar getCreationDate() {
        Date creationDate = (Date)this.getProperty(AbstractNode.createdDate);
        if (creationDate != null) {
            GregorianCalendar calendar = new GregorianCalendar();
            calendar.setTime(creationDate);
            return calendar;
        }
        return null;
    }

    public PropertyMap getDynamicProperties() {
        PropertyMap propertyMap = new PropertyMap();
        Class<?> type = this.getClass();
        for (PropertyKey key : StructrApp.getConfiguration().getPropertySet(type, "all")) {
            PropertyType dataType;
            if (!key.isDynamic() && !key.isCMISProperty() || (dataType = key.getDataType()) == null) continue;
            propertyMap.put(key, this.getProperty(key));
        }
        return propertyMap;
    }
}

