/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core.entity;

import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.structr.common.SecurityContext;
import org.structr.common.View;
import org.structr.common.error.ErrorBuffer;
import org.structr.common.error.FrameworkException;
import org.structr.core.app.StructrApp;
import org.structr.core.entity.AbstractNode;
import org.structr.core.entity.SchemaMethod;
import org.structr.core.entity.SchemaNode;
import org.structr.core.entity.SchemaProperty;
import org.structr.core.entity.SchemaReloadingNode;
import org.structr.core.entity.SchemaView;
import org.structr.core.entity.relationship.SchemaNodeMethod;
import org.structr.core.entity.relationship.SchemaNodeProperty;
import org.structr.core.entity.relationship.SchemaNodeView;
import org.structr.core.graph.ModificationQueue;
import org.structr.core.graph.NodeAttribute;
import org.structr.core.graph.TransactionCommand;
import org.structr.core.graph.TransactionPostProcess;
import org.structr.core.property.EndNodes;
import org.structr.core.property.Property;
import org.structr.core.property.PropertyKey;
import org.structr.core.property.StringProperty;
import org.structr.schema.ConfigurationProvider;
import org.structr.schema.Schema;

public abstract class AbstractSchemaNode
extends SchemaReloadingNode
implements Schema {
    public static final Property<List<SchemaProperty>> schemaProperties = new EndNodes("schemaProperties", SchemaNodeProperty.class);
    public static final Property<List<SchemaMethod>> schemaMethods = new EndNodes("schemaMethods", SchemaNodeMethod.class);
    public static final Property<List<SchemaView>> schemaViews = new EndNodes("schemaViews", SchemaNodeView.class);
    public static final Property<String> icon = new StringProperty("icon");
    public static final Property<String> description = new StringProperty("description");
    public static final Set<String> hiddenPropertyNames = new LinkedHashSet<String>();
    public static final View defaultView = new View(AbstractSchemaNode.class, "public", name, icon);
    public static final View uiView = new View(AbstractSchemaNode.class, "ui", name, schemaProperties, schemaViews, schemaMethods, icon, description);
    public static final View schemaView = new View(AbstractSchemaNode.class, "schema", id, type, name, schemaProperties, schemaViews, schemaMethods, icon, description);
    public static final View exportView = new View(AbstractSchemaNode.class, "export", id, type, name, icon, description);

    @Override
    public boolean onCreation(SecurityContext securityContext, ErrorBuffer errorBuffer) throws FrameworkException {
        if (super.onCreation(securityContext, errorBuffer)) {
            TransactionCommand.postProcess("createDefaultProperties", new CreateBuiltInSchemaEntities(this));
            return true;
        }
        return false;
    }

    @Override
    public boolean onModification(SecurityContext securityContext, ErrorBuffer errorBuffer, ModificationQueue modificationQueue) throws FrameworkException {
        if (super.onModification(securityContext, errorBuffer, modificationQueue)) {
            TransactionCommand.postProcess("createDefaultProperties", new CreateBuiltInSchemaEntities(this));
            return true;
        }
        return false;
    }

    @Override
    public List<SchemaProperty> getSchemaProperties() {
        return this.getProperty(schemaProperties);
    }

    @Override
    public List<SchemaView> getSchemaViews() {
        return this.getProperty(schemaViews);
    }

    @Override
    public List<SchemaMethod> getSchemaMethods() {
        return this.getProperty(schemaMethods);
    }

    public void createBuiltInSchemaEntities(ErrorBuffer errorBuffer) throws FrameworkException {
        new CreateBuiltInSchemaEntities(this).execute(this.securityContext, errorBuffer);
    }

    static {
        hiddenPropertyNames.add("visibilityStartDate");
        hiddenPropertyNames.add("visibilityEndDate");
        hiddenPropertyNames.add("createdBy");
        hiddenPropertyNames.add("hidden");
        hiddenPropertyNames.add("deleted");
    }

    private static class CreateBuiltInSchemaEntities
    implements TransactionPostProcess {
        private AbstractSchemaNode node = null;

        public CreateBuiltInSchemaEntities(AbstractSchemaNode node) {
            this.node = node;
        }

        @Override
        public boolean execute(SecurityContext securityContext, ErrorBuffer errorBuffer) throws FrameworkException {
            ConfigurationProvider config = StructrApp.getConfiguration();
            HashSet<String> viewNames = new HashSet<String>();
            viewNames.add("_graph");
            viewNames.add("all");
            for (SchemaView view : this.node.getProperty(schemaViews)) {
                viewNames.add((String)view.getProperty(AbstractNode.name));
            }
            Class builtinClass = config.getNodeEntityClass(this.node.getClassName());
            if (builtinClass == null) {
                builtinClass = config.getRelationshipEntityClass(this.node.getClassName());
            }
            if (builtinClass != null) {
                for (String view : config.getPropertyViewsForType(builtinClass)) {
                    if (viewNames.contains(view)) continue;
                    HashSet<String> viewPropertyNames = new HashSet<String>();
                    LinkedList<SchemaProperty> properties = new LinkedList<SchemaProperty>();
                    for (PropertyKey key : config.getPropertySet(builtinClass, view)) {
                        viewPropertyNames.add(key.jsonName());
                    }
                    for (SchemaProperty schemaProperty : (List)this.node.getProperty(SchemaNode.schemaProperties)) {
                        String schemaPropertyName = (String)schemaProperty.getProperty(SchemaProperty.name);
                        if (!viewPropertyNames.contains(schemaPropertyName)) continue;
                        properties.add(schemaProperty);
                    }
                    StructrApp.getInstance(this.node.getSecurityContext()).create(SchemaView.class, new NodeAttribute<AbstractSchemaNode>(SchemaView.schemaNode, this.node), new NodeAttribute<String>(SchemaView.name, view), new NodeAttribute(SchemaView.schemaProperties, properties), new NodeAttribute<Boolean>(SchemaView.isBuiltinView, true));
                }
            }
            return true;
        }
    }
}

