/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core.entity;

import java.util.Collections;
import java.util.Comparator;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Function;
import org.structr.api.graph.Node;
import org.structr.api.util.FixedSizeCache;
import org.structr.api.util.Iterables;
import org.structr.common.SecurityContext;
import org.structr.common.error.ErrorBuffer;
import org.structr.common.error.FrameworkException;
import org.structr.core.entity.AbstractNode;
import org.structr.core.entity.ManyToMany;
import org.structr.core.graph.ModificationQueue;
import org.structr.core.property.GenericProperty;
import org.structr.core.property.PropertyKey;
import org.structr.core.property.PropertyMap;
import org.structr.schema.NonIndexed;

public class GenericNode
extends AbstractNode
implements NonIndexed {
    private static final FixedSizeCache<Long, Set<PropertyKey>> propertyKeys = new FixedSizeCache(1000);

    @Override
    public int hashCode() {
        return this.getNodeId().hashCode();
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof GenericNode) {
            return o.hashCode() == this.hashCode();
        }
        return false;
    }

    @Override
    public boolean onCreation(SecurityContext securityContext, ErrorBuffer errorBuffer) throws FrameworkException {
        return true;
    }

    @Override
    public boolean onModification(SecurityContext securityContext, ErrorBuffer errorBuffer, ModificationQueue modificationQueue) throws FrameworkException {
        return true;
    }

    @Override
    public boolean onDeletion(SecurityContext securityContext, ErrorBuffer errorBuffer, PropertyMap properties) throws FrameworkException {
        return true;
    }

    @Override
    public boolean isValid(ErrorBuffer errorBuffer) {
        return true;
    }

    @Override
    public Iterable<PropertyKey> getPropertyKeys(String propertyView) {
        Node node = this.getNode();
        if (node != null) {
            long id = node.getId();
            TreeSet<PropertyKey> keys = (TreeSet<PropertyKey>)propertyKeys.get((Object)id);
            if (keys == null) {
                keys = new TreeSet<PropertyKey>(new PropertyKeyComparator());
                keys.addAll(Iterables.toList(super.getPropertyKeys(propertyView)));
                keys.addAll(Iterables.toList((Iterable)Iterables.map((Function)new GenericPropertyKeyMapper(), (Iterable)this.dbNode.getPropertyKeys())));
                propertyKeys.put((Object)id, keys);
            }
            return keys;
        }
        return Collections.EMPTY_SET;
    }

    private class GenericRelation
    extends ManyToMany {
        private String relType = null;

        public GenericRelation(String relType) {
            this.relType = relType;
        }

        @Override
        public Class getSourceType() {
            return GenericNode.class;
        }

        @Override
        public Class getTargetType() {
            return GenericNode.class;
        }

        public String name() {
            return this.relType;
        }

        @Override
        public boolean isInternal() {
            return false;
        }
    }

    private class PropertyKeyComparator
    implements Comparator<PropertyKey> {
        private PropertyKeyComparator() {
        }

        @Override
        public int compare(PropertyKey o1, PropertyKey o2) {
            if (o1 != null && o2 != null) {
                return o1.jsonName().compareTo(o2.jsonName());
            }
            throw new NullPointerException();
        }
    }

    private class GenericPropertyKeyMapper
    implements Function<String, PropertyKey> {
        private GenericPropertyKeyMapper() {
        }

        @Override
        public PropertyKey apply(String from) throws RuntimeException {
            return new GenericProperty(from);
        }
    }
}

