/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core.entity;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.structr.api.util.Iterables;
import org.structr.common.error.FrameworkException;
import org.structr.core.app.App;
import org.structr.core.app.StructrApp;
import org.structr.core.entity.AbstractNode;
import org.structr.core.entity.AbstractRelationship;
import org.structr.core.entity.LinkedListNode;
import org.structr.core.entity.relationship.AbstractChildren;
import org.structr.core.entity.relationship.AbstractListSiblings;
import org.structr.core.graph.RelationshipInterface;
import org.structr.core.property.PropertyMap;

public abstract class LinkedTreeNode<R extends AbstractChildren<T, T>, S extends AbstractListSiblings<T, T>, T extends LinkedTreeNode>
extends LinkedListNode<S, T> {
    public abstract Class<R> getChildLinkType();

    public T treeGetParent() {
        AbstractChildren prevRel = (AbstractChildren)this.getIncomingRelationship(this.getChildLinkType());
        if (prevRel != null) {
            return (T)((LinkedTreeNode)prevRel.getSourceNode());
        }
        return null;
    }

    public void treeAppendChild(T childElement) throws FrameworkException {
        T lastChild = this.treeGetLastChild();
        PropertyMap properties = new PropertyMap();
        properties.put(AbstractChildren.position, this.treeGetChildCount());
        this.linkNodes(this.getChildLinkType(), this, childElement, properties);
        if (lastChild != null) {
            LinkedTreeNode.super.listInsertAfter(lastChild, childElement);
        }
        this.ensureCorrectChildPositions();
    }

    public void treeInsertBefore(T newChild, T refChild) throws FrameworkException {
        List<R> rels = this.treeGetChildRelationships();
        boolean found = false;
        int position = 0;
        if (rels.isEmpty()) {
            if (refChild != null) {
                throw new FrameworkException(404, "Referenced child is not a child of parent node.");
            }
            this.treeAppendChild(newChild);
            return;
        }
        for (AbstractChildren rel : rels) {
            LinkedTreeNode node = (LinkedTreeNode)rel.getTargetNode();
            if (node.equals(refChild)) {
                PropertyMap properties = new PropertyMap();
                properties.put(AbstractChildren.position, position);
                this.linkNodes(this.getChildLinkType(), this, newChild, properties);
                found = true;
                ++position;
            }
            rel.setProperty(AbstractChildren.position, position);
            ++position;
        }
        if (!found) {
            throw new FrameworkException(404, "Referenced child is not a child of parent node.");
        }
        LinkedTreeNode.super.listInsertBefore(refChild, newChild);
        this.ensureCorrectChildPositions();
    }

    public void treeInsertAfter(T newChild, T refChild) throws FrameworkException {
        List<R> rels = this.treeGetChildRelationships();
        int position = 0;
        if (rels.isEmpty()) {
            this.treeAppendChild(newChild);
            return;
        }
        for (AbstractChildren rel : rels) {
            LinkedTreeNode node = (LinkedTreeNode)rel.getTargetNode();
            rel.setProperty(AbstractChildren.position, position);
            ++position;
            if (!node.equals(refChild)) continue;
            PropertyMap properties = new PropertyMap();
            properties.put(AbstractChildren.position, position);
            this.linkNodes(this.getChildLinkType(), this, newChild, properties);
            ++position;
        }
        LinkedTreeNode.super.listInsertAfter(refChild, newChild);
        this.ensureCorrectChildPositions();
    }

    public void treeRemoveChild(T childToRemove) throws FrameworkException {
        LinkedTreeNode.super.listRemove(childToRemove);
        this.unlinkNodes(this.getChildLinkType(), this, childToRemove);
        this.ensureCorrectChildPositions();
    }

    public void treeReplaceChild(T newChild, T oldChild) throws FrameworkException {
        int oldPosition = this.treeGetChildPosition(oldChild);
        this.unlinkNodes(this.getChildLinkType(), this, oldChild);
        PropertyMap properties = new PropertyMap();
        properties.put(AbstractChildren.position, oldPosition);
        this.linkNodes(this.getChildLinkType(), this, newChild, properties);
        LinkedTreeNode.super.listInsertBefore(oldChild, newChild);
        LinkedTreeNode.super.listRemove(oldChild);
        this.ensureCorrectChildPositions();
    }

    public T treeGetFirstChild() {
        return this.treeGetChild(0);
    }

    public T treeGetLastChild() {
        int last = this.treeGetChildCount() - 1;
        if (last >= 0) {
            return this.treeGetChild(last);
        }
        return null;
    }

    public T treeGetChild(int position) {
        for (AbstractChildren rel : this.getOutgoingRelationships(this.getChildLinkType())) {
            Integer pos = rel.getProperty(AbstractChildren.position);
            if (pos == null || pos != position) continue;
            return (T)((LinkedTreeNode)rel.getTargetNode());
        }
        return null;
    }

    public int treeGetChildPosition(T child) {
        Integer pos;
        AbstractChildren rel = (AbstractChildren)((AbstractNode)child).getIncomingRelationship(this.getChildLinkType());
        if (rel != null && (pos = rel.getProperty(AbstractChildren.position)) != null) {
            return pos;
        }
        return 0;
    }

    public List<T> treeGetChildren() {
        ArrayList abstractChildren = new ArrayList();
        for (AbstractChildren rel : this.treeGetChildRelationships()) {
            abstractChildren.add(rel.getTargetNode());
        }
        return abstractChildren;
    }

    public int treeGetChildCount() {
        return (int)Iterables.count(this.getOutgoingRelationships(this.getChildLinkType()));
    }

    public List<R> treeGetChildRelationships() {
        List childRels = Iterables.toList(this.getOutgoingRelationships(this.getChildLinkType()));
        Collections.sort(childRels, new Comparator<R>(){

            @Override
            public int compare(R o1, R o2) {
                Integer pos1 = ((AbstractRelationship)o1).getProperty(AbstractChildren.position);
                Integer pos2 = ((AbstractRelationship)o2).getProperty(AbstractChildren.position);
                if (pos1 != null && pos2 != null) {
                    return pos1.compareTo(pos2);
                }
                return 0;
            }
        });
        return childRels;
    }

    private void ensureCorrectChildPositions() throws FrameworkException {
        List<R> childRels = this.treeGetChildRelationships();
        int position = 0;
        for (AbstractChildren childRel : childRels) {
            childRel.setProperty(AbstractChildren.position, position++);
        }
    }

    private void unlinkNodes(Class<R> linkType, T startNode, T endNode) throws FrameworkException {
        App app = StructrApp.getInstance(this.securityContext);
        for (RelationshipInterface rel : ((AbstractNode)startNode).getRelationships(linkType)) {
            if (rel == null || !rel.getTargetNode().equals(endNode)) continue;
            app.delete(rel);
        }
    }

    public Set<T> getAllChildNodes() {
        HashSet<LinkedTreeNode<R, S, T>> allChildNodes = new HashSet<LinkedTreeNode<R, S, T>>();
        List<T> childNodes = this.treeGetChildren();
        for (LinkedTreeNode child : childNodes) {
            allChildNodes.add(child);
            allChildNodes.addAll(child.getAllChildNodes());
        }
        return allChildNodes;
    }
}

