/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core.entity;

import org.structr.common.SecurityContext;
import org.structr.common.ValidationHelper;
import org.structr.common.View;
import org.structr.common.error.ErrorBuffer;
import org.structr.common.error.FrameworkException;
import org.structr.core.entity.AbstractNode;
import org.structr.core.function.LocalizeFunction;
import org.structr.core.graph.ModificationQueue;
import org.structr.core.property.BooleanProperty;
import org.structr.core.property.Property;
import org.structr.core.property.StringProperty;

public class Localization
extends AbstractNode {
    public static final Property<String> localizedName = new StringProperty("localizedName").cmis().indexed();
    public static final Property<String> description = new StringProperty("description");
    public static final Property<String> domain = new StringProperty("domain").cmis().indexed();
    public static final Property<String> locale = new StringProperty("locale").notNull().cmis().indexed();
    public static final Property<Boolean> imported = new BooleanProperty("imported").cmis().indexed();
    public static final View defaultView = new View(Localization.class, "public", domain, name, locale, localizedName, description, imported);
    public static final View uiView = new View(Localization.class, "ui", domain, name, locale, localizedName, description, imported);

    @Override
    public boolean onCreation(SecurityContext securityContext, ErrorBuffer errorBuffer) throws FrameworkException {
        if (super.onCreation(securityContext, errorBuffer)) {
            this.setProperty(visibleToPublicUsers, true);
            this.setProperty(visibleToAuthenticatedUsers, true);
            LocalizeFunction.invalidateCache();
            return true;
        }
        return false;
    }

    @Override
    public boolean onModification(SecurityContext securityContext, ErrorBuffer errorBuffer, ModificationQueue modificationQueue) throws FrameworkException {
        if (super.onModification(securityContext, errorBuffer, modificationQueue)) {
            LocalizeFunction.invalidateCache();
            return true;
        }
        return false;
    }

    @Override
    public boolean isValid(ErrorBuffer errorBuffer) {
        boolean valid = super.isValid(errorBuffer);
        valid &= ValidationHelper.isValidStringNotBlank(this, name, errorBuffer);
        return valid &= ValidationHelper.isValidStringNotBlank(this, locale, errorBuffer);
    }
}

