/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core.entity;

import org.structr.common.SecurityContext;
import org.structr.common.View;
import org.structr.common.error.ErrorBuffer;
import org.structr.common.error.FrameworkException;
import org.structr.core.entity.AbstractNode;
import org.structr.core.entity.Locatable;
import org.structr.core.entity.relationship.NodeHasLocation;
import org.structr.core.graph.ModificationQueue;
import org.structr.core.graph.NodeInterface;
import org.structr.core.graph.RelationshipInterface;
import org.structr.core.property.DoubleProperty;
import org.structr.core.property.Property;

public class Location
extends AbstractNode {
    public static final Property<Double> latitude = new DoubleProperty("latitude").cmis().passivelyIndexed();
    public static final Property<Double> longitude = new DoubleProperty("longitude").cmis().passivelyIndexed();
    public static final Property<Double> altitude = new DoubleProperty("altitude").cmis().passivelyIndexed();
    public static final View publicView = new View(Location.class, "public", latitude, longitude, altitude);
    public static final View uiView = new View(Location.class, "ui", latitude, longitude, altitude);

    @Override
    public boolean onCreation(SecurityContext securityContext, ErrorBuffer errorBuffer) throws FrameworkException {
        return this.isValid(errorBuffer);
    }

    @Override
    public boolean onModification(SecurityContext securityContext, ErrorBuffer errorBuffer, ModificationQueue modificationQueue) throws FrameworkException {
        return this.isValid(errorBuffer);
    }

    @Override
    public void afterCreation(SecurityContext securityContext) {
        this.notifyLocatables();
    }

    @Override
    public void afterModification(SecurityContext securityContext) {
        this.notifyLocatables();
    }

    @Override
    public boolean isValid(ErrorBuffer errorBuffer) {
        boolean valid = super.isValid(errorBuffer);
        return valid &= this.notifyLocatables();
    }

    private boolean notifyLocatables() {
        boolean allLocatablesAreValid = true;
        for (RelationshipInterface relationshipInterface : this.getRelationships(NodeHasLocation.class)) {
            NodeInterface otherNode = relationshipInterface.getOtherNode(this);
            if (otherNode == null || !(otherNode instanceof Locatable)) continue;
            allLocatablesAreValid &= !((Locatable)((Object)otherNode)).locationChanged();
        }
        return allLocatablesAreValid;
    }
}

