/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core.entity;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.common.ValidationHelper;
import org.structr.common.View;
import org.structr.common.error.ErrorBuffer;
import org.structr.common.error.FrameworkException;
import org.structr.common.error.UniqueToken;
import org.structr.core.Result;
import org.structr.core.app.StructrApp;
import org.structr.core.entity.AbstractNode;
import org.structr.core.property.Property;
import org.structr.core.property.StringProperty;
import org.structr.schema.SchemaService;

public class MailTemplate
extends AbstractNode {
    private static final Logger logger = LoggerFactory.getLogger((String)MailTemplate.class.getName());
    public static final Property<String> text = new StringProperty("text").cmis().indexed();
    public static final Property<String> locale = new StringProperty("locale").cmis().indexed();
    public static final View uiView = new View(MailTemplate.class, "ui", type, name, text, locale);
    public static final View publicView = new View(MailTemplate.class, "public", type, name, text, locale);

    @Override
    public boolean isValid(ErrorBuffer errorBuffer) {
        boolean valid = super.isValid(errorBuffer);
        String _name = (String)this.getProperty(name);
        String _locale = this.getProperty(locale);
        String _uuid = (String)this.getProperty(id);
        valid &= ValidationHelper.isValidStringNotBlank(this, name, errorBuffer);
        valid &= ValidationHelper.isValidStringNotBlank(this, locale, errorBuffer);
        try {
            Result<MailTemplate> res = StructrApp.getInstance(this.securityContext).nodeQuery(MailTemplate.class).andName(_name).and(locale, _locale).getResult();
            if (res.size() > 1) {
                errorBuffer.add(new UniqueToken(MailTemplate.class.getName(), name, _uuid));
                errorBuffer.add(new UniqueToken(MailTemplate.class.getName(), locale, _uuid));
                valid = false;
            }
        }
        catch (FrameworkException fe) {
            logger.warn("Could not search a MailTemplate with name {} and locale {}", new Object[]{this.getProperty(name), this.getProperty(locale)});
        }
        return valid;
    }

    static {
        SchemaService.registerBuiltinTypeOverride("MailTemplate", MailTemplate.class.getName());
    }
}

