/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core.entity;

import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.api.Predicate;
import org.structr.api.graph.Direction;
import org.structr.api.graph.Node;
import org.structr.api.graph.Relationship;
import org.structr.api.util.Iterables;
import org.structr.common.SecurityContext;
import org.structr.common.error.FrameworkException;
import org.structr.core.GraphObject;
import org.structr.core.app.App;
import org.structr.core.app.StructrApp;
import org.structr.core.entity.AbstractEndpoint;
import org.structr.core.entity.AbstractRelationship;
import org.structr.core.entity.Relation;
import org.structr.core.entity.Target;
import org.structr.core.graph.NodeFactory;
import org.structr.core.graph.NodeInterface;
import org.structr.core.property.PropertyMap;

public class ManyEndpoint<T extends NodeInterface>
extends AbstractEndpoint
implements Target<Iterable<Relationship>, Iterable<T>> {
    private static final Logger logger = LoggerFactory.getLogger((String)ManyEndpoint.class.getName());
    private Relation<?, T, ?, ManyEndpoint<T>> relation = null;

    public ManyEndpoint(Relation<?, T, ?, ManyEndpoint<T>> relation) {
        this.relation = relation;
    }

    @Override
    public Iterable<T> get(SecurityContext securityContext, NodeInterface node, Predicate<GraphObject> predicate) {
        final NodeFactory nodeFactory = new NodeFactory(securityContext);
        Object rels = this.getRawSource(securityContext, node.getNode(), (Predicate)predicate);
        if (rels != null) {
            return Iterables.map((Function)new Function<Relationship, T>(){

                @Override
                public T apply(Relationship from) throws RuntimeException {
                    return nodeFactory.instantiate(from.getEndNode(), from);
                }
            }, this.sort((Iterable<Relationship>)rels));
        }
        return null;
    }

    @Override
    public Object set(SecurityContext securityContext, NodeInterface sourceNode, Iterable<T> collection) throws FrameworkException {
        App app = StructrApp.getInstance(securityContext);
        LinkedList createdRelationships = new LinkedList();
        PropertyMap properties = new PropertyMap();
        NodeInterface actualSourceNode = (NodeInterface)this.unwrap(securityContext, this.relation.getClass(), sourceNode, properties);
        LinkedHashSet toBeDeleted = new LinkedHashSet(Iterables.toList((Iterable)this.get(securityContext, actualSourceNode, (Predicate)null)));
        LinkedHashSet toBeCreated = new LinkedHashSet();
        if (collection != null) {
            Iterables.addAll(toBeCreated, collection);
        }
        HashSet intersection = new HashSet(toBeCreated);
        intersection.retainAll(toBeDeleted);
        toBeCreated.removeAll(intersection);
        toBeDeleted.removeAll(intersection);
        if (actualSourceNode != null) {
            for (NodeInterface targetNode : toBeDeleted) {
                for (AbstractRelationship rel : actualSourceNode.getOutgoingRelationships()) {
                    String relTypeName = rel.getRelType().name();
                    String desiredRelType = this.relation.name();
                    if (actualSourceNode.equals(targetNode)) {
                        logger.warn("Preventing deletion of self relationship {}-[{}]->{}. If you experience issue with this, please report to team@structr.com.", new Object[]{actualSourceNode, rel.getRelType(), targetNode});
                        continue;
                    }
                    if (!relTypeName.equals(desiredRelType) || !rel.getTargetNode().equals(targetNode)) continue;
                    app.delete(rel);
                }
            }
            for (NodeInterface targetNode : toBeCreated) {
                if (targetNode == null) continue;
                properties.clear();
                NodeInterface actualTargetNode = (NodeInterface)this.unwrap(securityContext, this.relation.getClass(), targetNode, properties);
                this.relation.ensureCardinality(securityContext, actualSourceNode, actualTargetNode);
                PropertyMap notionProperties = this.getNotionProperties(securityContext, this.relation.getClass(), actualSourceNode.getName() + this.relation.name() + actualTargetNode.getName());
                if (notionProperties != null) {
                    properties.putAll(notionProperties);
                }
                createdRelationships.add(app.create(actualSourceNode, actualTargetNode, this.relation.getClass(), properties));
            }
        }
        return createdRelationships;
    }

    @Override
    public Iterable<Relationship> getRawSource(SecurityContext securityContext, Node dbNode, Predicate<GraphObject> predicate) {
        return this.getMultiple(securityContext, dbNode, this.relation, Direction.OUTGOING, this.relation.getTargetType(), predicate);
    }

    @Override
    public boolean hasElements(SecurityContext securityContext, Node dbNode, Predicate<GraphObject> predicate) {
        return this.getRawSource(securityContext, dbNode, (Predicate)predicate).iterator().hasNext();
    }
}

