/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core.entity;

import org.structr.api.Predicate;
import org.structr.api.graph.Direction;
import org.structr.api.graph.Node;
import org.structr.api.graph.Relationship;
import org.structr.common.SecurityContext;
import org.structr.common.error.FrameworkException;
import org.structr.core.GraphObject;
import org.structr.core.app.StructrApp;
import org.structr.core.entity.AbstractEndpoint;
import org.structr.core.entity.Relation;
import org.structr.core.entity.Target;
import org.structr.core.graph.NodeFactory;
import org.structr.core.graph.NodeInterface;
import org.structr.core.property.PropertyMap;

public class OneEndpoint<T extends NodeInterface>
extends AbstractEndpoint
implements Target<Relationship, T> {
    private Relation<?, T, ?, OneEndpoint<T>> relation = null;

    public OneEndpoint(Relation<?, T, ?, OneEndpoint<T>> relation) {
        this.relation = relation;
    }

    @Override
    public T get(SecurityContext securityContext, NodeInterface node, Predicate<GraphObject> predicate) {
        NodeFactory nodeFactory = new NodeFactory(securityContext);
        Relationship rel = this.getRawSource(securityContext, node.getNode(), predicate);
        if (rel != null) {
            return nodeFactory.instantiate(rel.getEndNode(), rel);
        }
        return null;
    }

    @Override
    public Object set(SecurityContext securityContext, NodeInterface sourceNode, T targetNode) throws FrameworkException {
        PropertyMap properties = new PropertyMap();
        NodeInterface actualTargetNode = (NodeInterface)this.unwrap(securityContext, this.relation.getClass(), (GraphObject)targetNode, properties);
        NodeInterface actualSourceNode = (NodeInterface)this.unwrap(securityContext, this.relation.getClass(), sourceNode, properties);
        this.relation.ensureCardinality(securityContext, actualSourceNode, actualTargetNode);
        if (actualSourceNode != null && actualTargetNode != null) {
            String storageKey = actualSourceNode.getName() + this.relation.name() + actualTargetNode.getName();
            PropertyMap notionProperties = this.getNotionProperties(securityContext, this.relation.getClass(), storageKey);
            if (notionProperties != null) {
                properties.putAll(notionProperties);
            }
            return StructrApp.getInstance(securityContext).create(actualSourceNode, actualTargetNode, this.relation.getClass(), properties);
        }
        return null;
    }

    @Override
    public Relationship getRawSource(SecurityContext securityContext, Node dbNode, Predicate<GraphObject> predicate) {
        return this.getSingle(securityContext, dbNode, this.relation, Direction.OUTGOING, this.relation.getTargetType());
    }

    @Override
    public boolean hasElements(SecurityContext securityContext, Node dbNode, Predicate<GraphObject> predicate) {
        return this.getRawSource(securityContext, dbNode, predicate) != null;
    }
}

