/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core.entity;

import org.structr.api.graph.Direction;
import org.structr.common.SecurityContext;
import org.structr.common.error.FrameworkException;
import org.structr.core.app.App;
import org.structr.core.app.StructrApp;
import org.structr.core.entity.AbstractRelationship;
import org.structr.core.entity.OneEndpoint;
import org.structr.core.entity.OneStartpoint;
import org.structr.core.entity.Relation;
import org.structr.core.graph.NodeInterface;
import org.structr.core.graph.RelationshipInterface;
import org.structr.core.graph.search.SearchCommand;
import org.structr.core.notion.Notion;
import org.structr.core.notion.RelationshipNotion;

public abstract class OneToOne<S extends NodeInterface, T extends NodeInterface>
extends AbstractRelationship<S, T>
implements Relation<S, T, OneStartpoint<S>, OneEndpoint<T>> {
    @Override
    public Relation.Multiplicity getSourceMultiplicity() {
        return Relation.Multiplicity.One;
    }

    @Override
    public Relation.Multiplicity getTargetMultiplicity() {
        return Relation.Multiplicity.One;
    }

    @Override
    public OneStartpoint<S> getSource() {
        return new OneStartpoint(this);
    }

    @Override
    public OneEndpoint<T> getTarget() {
        return new OneEndpoint(this);
    }

    @Override
    public int getCascadingDeleteFlag() {
        return 0;
    }

    @Override
    public int getAutocreationFlag() {
        return 0;
    }

    @Override
    public void ensureCardinality(SecurityContext securityContext, NodeInterface sourceNode, NodeInterface targetNode) throws FrameworkException {
        Object incomingRel;
        Object outgoingRel;
        App app = StructrApp.getInstance();
        Class<?> clazz = this.getClass();
        Class sourceType = this.getSourceType();
        Class targetType = this.getTargetType();
        if (sourceNode != null && (outgoingRel = sourceNode.getOutgoingRelationship(clazz)) != null && SearchCommand.isTypeAssignableFromOtherType(targetType, outgoingRel.getTargetType())) {
            app.delete((RelationshipInterface)outgoingRel);
        }
        if (targetNode != null && (incomingRel = targetNode.getIncomingRelationship(clazz)) != null && SearchCommand.isTypeAssignableFromOtherType(sourceType, incomingRel.getSourceType())) {
            app.delete((RelationshipInterface)incomingRel);
        }
    }

    @Override
    public Notion getEndNodeNotion() {
        return new RelationshipNotion(this.getTargetIdProperty());
    }

    @Override
    public Notion getStartNodeNotion() {
        return new RelationshipNotion(this.getSourceIdProperty());
    }

    @Override
    public Direction getDirectionForType(Class<? extends NodeInterface> type) {
        return super.getDirectionForType(this.getSourceType(), this.getTargetType(), type);
    }

    @Override
    public Class getOtherType(Class type) {
        switch (this.getDirectionForType(type)) {
            case INCOMING: {
                return this.getSourceType();
            }
            case OUTGOING: {
                return this.getTargetType();
            }
            case BOTH: {
                return this.getSourceType();
            }
        }
        return null;
    }

    @Override
    public boolean isHidden() {
        return false;
    }

    @Override
    public boolean isInternal() {
        return false;
    }
}

