/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core.entity;

import java.util.Set;
import org.structr.api.Predicate;
import org.structr.api.graph.Node;
import org.structr.api.graph.Relationship;
import org.structr.common.SecurityContext;
import org.structr.core.GraphObject;
import org.structr.core.graph.NodeFactory;
import org.structr.core.graph.search.SearchCommand;

public class OtherNodeTypeFilter
implements Predicate<Relationship> {
    private Set<String> subtypes = null;
    private Predicate<GraphObject> nodePredicate = null;
    private NodeFactory nodeFactory = null;
    private Node thisNode = null;

    public OtherNodeTypeFilter(SecurityContext securityContext, Node thisNode, Class desiredType) {
        this(securityContext, thisNode, desiredType, null);
    }

    public OtherNodeTypeFilter(SecurityContext securityContext, Node thisNode, Class desiredType, Predicate<GraphObject> nodePredicate) {
        this.nodePredicate = nodePredicate;
        this.nodeFactory = new NodeFactory(securityContext);
        this.thisNode = thisNode;
        this.subtypes = SearchCommand.getAllSubtypesAsStringSet(desiredType.getSimpleName());
    }

    public boolean accept(Relationship item) {
        Object otherNode = this.nodeFactory.instantiate(item.getOtherNode(this.thisNode), item);
        if (otherNode != null && (this.nodePredicate == null || this.nodePredicate.accept(otherNode))) {
            Class<?> otherNodeType = otherNode.getClass();
            boolean desiredTypeIsAssignableFromOtherNodeType = this.subtypes.contains(otherNodeType.getSimpleName());
            return desiredTypeIsAssignableFromOtherNodeType;
        }
        return false;
    }
}

