/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core.entity;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.common.SecurityContext;
import org.structr.common.ValidationHelper;
import org.structr.common.View;
import org.structr.common.error.ErrorBuffer;
import org.structr.common.error.FrameworkException;
import org.structr.core.app.StructrApp;
import org.structr.core.entity.AbstractNode;
import org.structr.core.graph.ModificationQueue;
import org.structr.core.property.ConstantBooleanProperty;
import org.structr.core.property.IntProperty;
import org.structr.core.property.LongProperty;
import org.structr.core.property.Property;
import org.structr.core.property.PropertyMap;
import org.structr.core.property.StringProperty;

public class ResourceAccess
extends AbstractNode {
    private static final Map<String, ResourceAccess> grantCache = new ConcurrentHashMap<String, ResourceAccess>();
    private static final Logger logger = LoggerFactory.getLogger((String)ResourceAccess.class.getName());
    public static final Property<String> signature = new StringProperty("signature").cmis().unique().indexed();
    public static final Property<Long> flags = new LongProperty("flags").cmis().indexed();
    public static final Property<Integer> position = new IntProperty("position").cmis().indexed();
    public static final Property<Boolean> isResourceAccess = new ConstantBooleanProperty("isResourceAccess", true);
    public static final View uiView = new View(ResourceAccess.class, "ui", signature, flags, position, isResourceAccess);
    public static final View publicView = new View(ResourceAccess.class, "public", signature, flags, isResourceAccess);
    private String cachedResourceSignature = null;
    private Long cachedFlags = null;
    private Integer cachedPosition = null;

    public boolean hasFlag(long flag) {
        return (this.getFlags() & flag) == flag;
    }

    public void setFlag(long flag) throws FrameworkException {
        this.cachedFlags = null;
        this.setProperty(flags, this.getFlags() | flag);
    }

    public void clearFlag(long flag) throws FrameworkException {
        this.cachedFlags = null;
        this.setProperty(flags, this.getFlags() & (flag ^ 0xFFFFFFFFFFFFFFFFL));
    }

    public long getFlags() {
        if (this.cachedFlags == null) {
            this.cachedFlags = this.getProperty(flags);
        }
        if (this.cachedFlags != null) {
            return this.cachedFlags;
        }
        return 0L;
    }

    public String getResourceSignature() {
        if (this.cachedResourceSignature == null) {
            this.cachedResourceSignature = this.getProperty(signature);
        }
        return this.cachedResourceSignature;
    }

    public int getPosition() {
        if (this.cachedPosition == null) {
            this.cachedPosition = this.getProperty(position);
        }
        if (this.cachedPosition != null) {
            return this.cachedPosition;
        }
        return 0;
    }

    @Override
    public boolean onCreation(SecurityContext securityContext, ErrorBuffer errorBuffer) {
        return this.isValid(errorBuffer);
    }

    @Override
    public boolean onModification(SecurityContext securityContext, ErrorBuffer errorBuffer, ModificationQueue modificationQueue) {
        return this.isValid(errorBuffer);
    }

    @Override
    public boolean onDeletion(SecurityContext securityContext, ErrorBuffer errorBuffer, PropertyMap properties) {
        grantCache.clear();
        return true;
    }

    @Override
    public boolean isValid(ErrorBuffer errorBuffer) {
        boolean valid = super.isValid(errorBuffer);
        valid &= ValidationHelper.isValidUniqueProperty(this, signature, errorBuffer);
        valid &= ValidationHelper.isValidStringNotBlank(this, signature, errorBuffer);
        return valid &= ValidationHelper.isValidPropertyNotNull(this, flags, errorBuffer);
    }

    @Override
    public void afterCreation(SecurityContext securityContext) {
        grantCache.clear();
    }

    @Override
    public void afterModification(SecurityContext securityContext) {
        grantCache.clear();
    }

    public static ResourceAccess findGrant(SecurityContext securityContext, String signature) throws FrameworkException {
        ResourceAccess grant = grantCache.get(signature);
        if (grant == null) {
            grant = StructrApp.getInstance().nodeQuery(ResourceAccess.class).and(ResourceAccess.signature, signature).getFirst();
            if (grant != null) {
                grantCache.put(signature, grant);
            } else {
                logger.debug("No resource access object found for {}", (Object)signature);
            }
        }
        return grant;
    }
}

