/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core.entity;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.common.SecurityContext;
import org.structr.common.View;
import org.structr.common.error.ErrorBuffer;
import org.structr.common.error.FrameworkException;
import org.structr.core.entity.AbstractNode;
import org.structr.core.entity.AbstractSchemaNode;
import org.structr.core.entity.SchemaReloadingNode;
import org.structr.core.entity.SchemaView;
import org.structr.core.entity.relationship.SchemaNodeProperty;
import org.structr.core.entity.relationship.SchemaViewProperty;
import org.structr.core.graph.ModificationQueue;
import org.structr.core.notion.PropertySetNotion;
import org.structr.core.property.BooleanProperty;
import org.structr.core.property.Property;
import org.structr.core.property.PropertyKey;
import org.structr.core.property.StartNode;
import org.structr.core.property.StartNodes;
import org.structr.core.property.StringProperty;
import org.structr.schema.SchemaHelper;
import org.structr.schema.parser.DoubleArrayPropertyParser;
import org.structr.schema.parser.DoublePropertyParser;
import org.structr.schema.parser.IntPropertyParser;
import org.structr.schema.parser.IntegerArrayPropertyParser;
import org.structr.schema.parser.LongArrayPropertyParser;
import org.structr.schema.parser.LongPropertyParser;
import org.structr.schema.parser.NotionPropertyParser;
import org.structr.schema.parser.PropertyDefinition;

public class SchemaProperty
extends SchemaReloadingNode
implements PropertyDefinition {
    private static final Logger logger = LoggerFactory.getLogger((String)SchemaProperty.class.getName());
    public static final Property<AbstractSchemaNode> schemaNode = new StartNode("schemaNode", SchemaNodeProperty.class, new PropertySetNotion(AbstractNode.id, AbstractNode.name));
    public static final Property<List<SchemaView>> schemaViews = new StartNodes("schemaViews", SchemaViewProperty.class, new PropertySetNotion(AbstractNode.id, AbstractNode.name));
    public static final Property<String> declaringClass = new StringProperty("declaringClass");
    public static final Property<String> defaultValue = new StringProperty("defaultValue");
    public static final Property<String> propertyType = new StringProperty("propertyType");
    public static final Property<String> contentType = new StringProperty("contentType");
    public static final Property<String> dbName = new StringProperty("dbName");
    public static final Property<String> format = new StringProperty("format");
    public static final Property<Boolean> notNull = new BooleanProperty("notNull");
    public static final Property<Boolean> compound = new BooleanProperty("compound");
    public static final Property<Boolean> unique = new BooleanProperty("unique");
    public static final Property<Boolean> indexed = new BooleanProperty("indexed").defaultValue((Object)true);
    public static final Property<Boolean> isDynamic = new BooleanProperty("isDynamic");
    public static final Property<Boolean> isBuiltinProperty = new BooleanProperty("isBuiltinProperty");
    public static final Property<Boolean> isDefaultInUi = new BooleanProperty("isDefaultInUi");
    public static final Property<Boolean> isDefaultInPublic = new BooleanProperty("isDefaultInPublic");
    public static final Property<String> contentHash = new StringProperty("contentHash");
    public static final Property<String> readFunction = new StringProperty("readFunction");
    public static final Property<String> writeFunction = new StringProperty("writeFunction");
    public static final View defaultView = new View(SchemaProperty.class, "public", name, dbName, schemaNode, schemaViews, propertyType, contentType, format, notNull, compound, unique, indexed, defaultValue, isBuiltinProperty, declaringClass, isDynamic, readFunction, writeFunction);
    public static final View uiView = new View(SchemaProperty.class, "ui", name, dbName, schemaNode, schemaViews, propertyType, contentType, format, notNull, compound, unique, indexed, defaultValue, isBuiltinProperty, declaringClass, isDynamic, readFunction, writeFunction);
    public static final View schemaView = new View(SchemaProperty.class, "schema", id, type, name, dbName, schemaNode, schemaViews, propertyType, contentType, format, notNull, compound, unique, indexed, defaultValue, isBuiltinProperty, isDefaultInUi, isDefaultInPublic, declaringClass, isDynamic, readFunction, writeFunction);
    public static final View exportView = new View(SchemaProperty.class, "export", id, type, name, schemaNode, schemaViews, dbName, propertyType, contentType, format, notNull, compound, unique, indexed, defaultValue, isBuiltinProperty, isDefaultInUi, isDefaultInPublic, declaringClass, isDynamic, readFunction, writeFunction);
    private NotionPropertyParser notionPropertyParser = null;
    private DoublePropertyParser doublePropertyParser = null;
    private LongPropertyParser longPropertyParser = null;
    private IntPropertyParser intPropertyParser = null;
    private DoubleArrayPropertyParser doubleArrayPropertyParser = null;
    private LongArrayPropertyParser longArrayPropertyParser = null;
    private IntegerArrayPropertyParser intArrayPropertyParser = null;

    @Override
    public String getPropertyName() {
        return (String)this.getProperty(name);
    }

    @Override
    public SchemaHelper.Type getPropertyType() {
        String _type = this.getProperty(propertyType);
        if (_type != null) {
            try {
                return SchemaHelper.Type.valueOf(_type);
            }
            catch (IllegalArgumentException ex) {
                throw new IllegalStateException("Invalid property type " + _type + " for property " + this.getPropertyName() + ".");
            }
        }
        throw new IllegalStateException("Invalid property type null for property " + this.getPropertyName() + ".");
    }

    @Override
    public String getContentType() {
        return this.getProperty(contentType);
    }

    @Override
    public boolean isNotNull() {
        Boolean isNotNull = this.getProperty(notNull);
        return isNotNull != null && isNotNull != false;
    }

    @Override
    public boolean isCompound() {
        Boolean isCompoundUnique = this.getProperty(compound);
        return isCompoundUnique != null && isCompoundUnique != false;
    }

    @Override
    public boolean isUnique() {
        Boolean isUnique = this.getProperty(unique);
        return isUnique != null && isUnique != false;
    }

    @Override
    public boolean isIndexed() {
        Boolean isIndexed = this.getProperty(indexed);
        return isIndexed != null && isIndexed != false;
    }

    @Override
    public String getRawSource() {
        return "";
    }

    @Override
    public String getSource() {
        return "";
    }

    @Override
    public String getDbName() {
        return this.getProperty(dbName);
    }

    @Override
    public String getDefaultValue() {
        return this.getProperty(defaultValue);
    }

    @Override
    public boolean onCreation(SecurityContext securityContext, ErrorBuffer errorBuffer) throws FrameworkException {
        AbstractSchemaNode parent = this.getProperty(schemaNode);
        if (parent != null) {
            for (SchemaView view : parent.getProperty(AbstractSchemaNode.schemaViews)) {
                if (!"ui".equals(view.getName())) continue;
                LinkedHashSet<SchemaProperty> properties = new LinkedHashSet<SchemaProperty>((Collection)view.getProperty(SchemaView.schemaProperties));
                properties.add(this);
                view.setProperty(SchemaView.schemaProperties, new LinkedList(properties));
                break;
            }
        }
        return super.onCreation(securityContext, errorBuffer);
    }

    @Override
    public boolean onModification(SecurityContext securityContext, ErrorBuffer errorBuffer, ModificationQueue modificationQueue) throws FrameworkException {
        if (this.getProperty(isBuiltinProperty).booleanValue() && !this.getContentHash().equals(this.getProperty(contentHash))) {
            throw new FrameworkException(403, "Modification of built-in properties not permitted.");
        }
        return super.onModification(securityContext, errorBuffer, modificationQueue);
    }

    public String getContentHash() {
        int _contentHash = 77;
        _contentHash = this.addContentHash(defaultValue, _contentHash);
        _contentHash = this.addContentHash(propertyType, _contentHash);
        _contentHash = this.addContentHash(contentType, _contentHash);
        _contentHash = this.addContentHash(dbName, _contentHash);
        _contentHash = this.addContentHash(format, _contentHash);
        _contentHash = this.addContentHash(notNull, _contentHash);
        _contentHash = this.addContentHash(unique, _contentHash);
        _contentHash = this.addContentHash(indexed, _contentHash);
        _contentHash = this.addContentHash(isDynamic, _contentHash);
        _contentHash = this.addContentHash(isBuiltinProperty, _contentHash);
        _contentHash = this.addContentHash(isDefaultInUi, _contentHash);
        _contentHash = this.addContentHash(isDefaultInPublic, _contentHash);
        _contentHash = this.addContentHash(readFunction, _contentHash);
        _contentHash = this.addContentHash(writeFunction, _contentHash);
        return Integer.toHexString(_contentHash);
    }

    @Override
    public String getFormat() {
        String _format = this.getProperty(format);
        if (_format != null) {
            _format = _format.trim();
        }
        return _format;
    }

    public boolean isRequired() {
        return this.getProperty(notNull);
    }

    public String getSourceContentType() {
        String source = this.getFormat();
        if (source != null && source.startsWith("{") && source.endsWith("}")) {
            return "application/x-structr-javascript";
        }
        return null;
    }

    public Set<String> getEnumDefinitions() {
        String _format = this.getProperty(format);
        LinkedHashSet<String> enums = new LinkedHashSet<String>();
        if (_format != null) {
            for (String source : _format.split("[, ]+")) {
                String trimmed = source.trim();
                if (!StringUtils.isNotBlank((CharSequence)trimmed)) continue;
                enums.add(trimmed);
            }
        }
        return enums;
    }

    public boolean isPropertySetNotion() {
        return this.getNotionPropertyParser().isPropertySet();
    }

    public String getTypeReferenceForNotionProperty() {
        return this.getNotionPropertyParser().getValueType();
    }

    public Set<String> getPropertiesForNotionProperty() {
        LinkedHashSet<String> properties = new LinkedHashSet<String>();
        for (String property : this.getNotionPropertyParser().getProperties()) {
            if (property.contains(".")) {
                String[] parts = property.split("[.]+");
                if (parts.length <= 1) continue;
                String type = parts[0];
                String name = parts[1];
                properties.add(name);
                continue;
            }
            properties.add(property);
        }
        return properties;
    }

    public String getNotionBaseProperty() {
        return this.getNotionPropertyParser().getBaseProperty();
    }

    public String getNotionMultiplicity() {
        return this.getNotionPropertyParser().getMultiplicity();
    }

    @Override
    public String getReadFunction() {
        String _readFunction = this.getProperty(readFunction);
        if (_readFunction != null) {
            _readFunction = _readFunction.trim();
        }
        return _readFunction;
    }

    @Override
    public String getWriteFunction() {
        String _writeFunction = this.getProperty(writeFunction);
        if (_writeFunction != null) {
            _writeFunction = _writeFunction.trim();
        }
        return _writeFunction;
    }

    private int addContentHash(PropertyKey key, int contentHash) {
        Object value = this.getProperty(key);
        if (value != null) {
            return contentHash ^ value.hashCode();
        }
        return contentHash;
    }

    public NotionPropertyParser getNotionPropertyParser() {
        if (this.notionPropertyParser == null) {
            try {
                this.notionPropertyParser = new NotionPropertyParser(new ErrorBuffer(), this.getName(), this);
                this.notionPropertyParser.getPropertySource(new StringBuilder(), this.getProperty(schemaNode));
            }
            catch (FrameworkException fex) {
                logger.warn("", (Throwable)fex);
            }
        }
        return this.notionPropertyParser;
    }

    public IntPropertyParser getIntPropertyParser() {
        if (this.intPropertyParser == null) {
            try {
                this.intPropertyParser = new IntPropertyParser(new ErrorBuffer(), this.getName(), this);
                this.intPropertyParser.getPropertySource(new StringBuilder(), this.getProperty(schemaNode));
            }
            catch (FrameworkException fex) {
                logger.warn("", (Throwable)fex);
            }
        }
        return this.intPropertyParser;
    }

    public IntegerArrayPropertyParser getIntArrayPropertyParser() {
        if (this.intArrayPropertyParser == null) {
            try {
                this.intArrayPropertyParser = new IntegerArrayPropertyParser(new ErrorBuffer(), this.getName(), this);
                this.intArrayPropertyParser.getPropertySource(new StringBuilder(), this.getProperty(schemaNode));
            }
            catch (FrameworkException fex) {
                logger.warn("", (Throwable)fex);
            }
        }
        return this.intArrayPropertyParser;
    }

    public LongPropertyParser getLongPropertyParser() {
        if (this.longPropertyParser == null) {
            try {
                this.longPropertyParser = new LongPropertyParser(new ErrorBuffer(), this.getName(), this);
                this.longPropertyParser.getPropertySource(new StringBuilder(), this.getProperty(schemaNode));
            }
            catch (FrameworkException fex) {
                logger.warn("", (Throwable)fex);
            }
        }
        return this.longPropertyParser;
    }

    public LongArrayPropertyParser getLongArrayPropertyParser() {
        if (this.longArrayPropertyParser == null) {
            try {
                this.longArrayPropertyParser = new LongArrayPropertyParser(new ErrorBuffer(), this.getName(), this);
                this.longArrayPropertyParser.getPropertySource(new StringBuilder(), this.getProperty(schemaNode));
            }
            catch (FrameworkException fex) {
                logger.warn("", (Throwable)fex);
            }
        }
        return this.longArrayPropertyParser;
    }

    public DoublePropertyParser getDoublePropertyParser() {
        if (this.doublePropertyParser == null) {
            try {
                this.doublePropertyParser = new DoublePropertyParser(new ErrorBuffer(), this.getName(), this);
                this.doublePropertyParser.getPropertySource(new StringBuilder(), this.getProperty(schemaNode));
            }
            catch (FrameworkException fex) {
                logger.warn("", (Throwable)fex);
            }
        }
        return this.doublePropertyParser;
    }

    public DoubleArrayPropertyParser getDoubleArrayPropertyParser() {
        if (this.doubleArrayPropertyParser == null) {
            try {
                this.doubleArrayPropertyParser = new DoubleArrayPropertyParser(new ErrorBuffer(), this.getName(), this);
                this.doubleArrayPropertyParser.getPropertySource(new StringBuilder(), this.getProperty(schemaNode));
            }
            catch (FrameworkException fex) {
                logger.warn("", (Throwable)fex);
            }
        }
        return this.doubleArrayPropertyParser;
    }
}

