/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core.entity.relationship;

import java.util.LinkedHashSet;
import java.util.List;
import org.structr.api.graph.PropertyContainer;
import org.structr.api.util.Iterables;
import org.structr.common.ValidationHelper;
import org.structr.common.View;
import org.structr.common.error.ErrorBuffer;
import org.structr.core.GraphObject;
import org.structr.core.entity.ManyToMany;
import org.structr.core.entity.SchemaNode;
import org.structr.core.property.LongProperty;
import org.structr.core.property.Property;
import org.structr.core.property.PropertyKey;
import org.structr.core.property.StringProperty;
import org.structr.schema.SchemaHelper;

public class SchemaRelationship
extends ManyToMany<SchemaNode, SchemaNode> {
    public static final Property<String> name = new StringProperty("name").indexed();
    public static final Property<String> relationshipType = new StringProperty("relationshipType");
    public static final Property<String> sourceMultiplicity = new StringProperty("sourceMultiplicity");
    public static final Property<String> targetMultiplicity = new StringProperty("targetMultiplicity");
    public static final Property<String> sourceNotion = new StringProperty("sourceNotion");
    public static final Property<String> targetNotion = new StringProperty("targetNotion");
    public static final Property<String> sourceJsonName = new StringProperty("sourceJsonName");
    public static final Property<String> targetJsonName = new StringProperty("targetJsonName");
    public static final Property<String> extendsClass = new StringProperty("extendsClass").indexed();
    public static final Property<Long> cascadingDeleteFlag = new LongProperty("cascadingDeleteFlag");
    public static final Property<Long> autocreationFlag = new LongProperty("autocreationFlag");
    public static final Property<String> sourceTypeName = new StringProperty("__internal_Structr_sourceTypeName");
    public static final View defaultView = new View(SchemaRelationship.class, "public", name, sourceId, targetId, sourceMultiplicity, targetMultiplicity, sourceNotion, targetNotion, relationshipType, sourceJsonName, targetJsonName, extendsClass, cascadingDeleteFlag, autocreationFlag);
    public static final View uiView = new View(SchemaRelationship.class, "ui", name, sourceId, targetId, sourceMultiplicity, targetMultiplicity, sourceNotion, targetNotion, relationshipType, sourceJsonName, targetJsonName, extendsClass, cascadingDeleteFlag, autocreationFlag);

    @Override
    public Class<SchemaNode> getSourceType() {
        return SchemaNode.class;
    }

    @Override
    public Class<SchemaNode> getTargetType() {
        return SchemaNode.class;
    }

    @Override
    public Property<String> getSourceIdProperty() {
        return sourceId;
    }

    @Override
    public Property<String> getTargetIdProperty() {
        return targetId;
    }

    public String name() {
        return "IS_RELATED_TO";
    }

    @Override
    public int getCascadingDeleteFlag() {
        return 0;
    }

    @Override
    public int getAutocreationFlag() {
        return 1;
    }

    @Override
    public Iterable<PropertyKey> getPropertyKeys(String propertyView) {
        LinkedHashSet<PropertyKey> propertyKeys = new LinkedHashSet<PropertyKey>(Iterables.toList(super.getPropertyKeys(propertyView)));
        for (String key : SchemaHelper.getProperties((PropertyContainer)this.getRelationship())) {
            StringProperty newKey = new StringProperty(key);
            newKey.setDeclaringClass(this.getClass());
            propertyKeys.add(newKey);
        }
        return propertyKeys;
    }

    @Override
    public boolean isValid(ErrorBuffer errorBuffer) {
        boolean valid = super.isValid(errorBuffer);
        return valid &= ValidationHelper.isValidStringNotBlank(this, relationshipType, errorBuffer);
    }

    @Override
    public boolean isInternal() {
        return true;
    }

    @Override
    public List<GraphObject> getSyncData() {
        List<GraphObject> syncables = super.getSyncData();
        syncables.add((GraphObject)this.getSourceNode());
        syncables.add((GraphObject)this.getTargetNode());
        return syncables;
    }

    private void formatRelationshipFlags(StringBuilder src) {
        Long autocreate;
        Long cascadingDelete = this.getProperty(cascadingDeleteFlag);
        if (cascadingDelete != null) {
            src.append("\n\t@Override\n");
            src.append("\tpublic int getCascadingDeleteFlag() {\n");
            switch (cascadingDelete.intValue()) {
                case 3: {
                    src.append("\t\treturn Relation.ALWAYS;\n");
                    break;
                }
                case 4: {
                    src.append("\t\treturn Relation.CONSTRAINT_BASED;\n");
                    break;
                }
                case 1: {
                    src.append("\t\treturn Relation.SOURCE_TO_TARGET;\n");
                    break;
                }
                case 2: {
                    src.append("\t\treturn Relation.TARGET_TO_SOURCE;\n");
                    break;
                }
                default: {
                    src.append("\t\treturn Relation.NONE;\n");
                }
            }
            src.append("\t}\n\n");
        }
        if ((autocreate = this.getProperty(autocreationFlag)) != null) {
            src.append("\n\t@Override\n");
            src.append("\tpublic int getAutocreationFlag() {\n");
            switch (autocreate.intValue()) {
                case 3: {
                    src.append("\t\treturn Relation.ALWAYS;\n");
                    break;
                }
                case 1: {
                    src.append("\t\treturn Relation.SOURCE_TO_TARGET;\n");
                    break;
                }
                case 2: {
                    src.append("\t\treturn Relation.TARGET_TO_SOURCE;\n");
                    break;
                }
                default: {
                    src.append("\t\treturn Relation.NONE;\n");
                }
            }
            src.append("\t}\n\n");
        }
    }
}

