/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core.function;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.structr.common.error.FrameworkException;
import org.structr.schema.SchemaHelper;
import org.structr.schema.action.ActionContext;
import org.structr.schema.action.Function;

public class AncestorTypesFunction
extends Function<Object, Object> {
    public static final String ERROR_MESSAGE_ANCESTOR_TYPES = "Usage: ${ancestor_types(type[, blacklist])}. Example ${ancestor_types('User')}";
    public static final String ERROR_MESSAGE_ANCESTOR_TYPES_JS = "Usage: ${Structr.ancestor_types(type[, blacklist])}. Example ${Structr.ancestor_types('User')}";

    @Override
    public Object apply(ActionContext ctx, Object caller, Object[] sources) throws FrameworkException {
        try {
            if (this.arrayHasMinLengthAndMaxLengthAndAllElementsNotNull(sources, 1, 2)) {
                String typeName = sources[0].toString();
                ArrayList<String> ancestorTypes = new ArrayList<String>();
                for (Class type = SchemaHelper.getEntityClassForRawType(typeName); type != null && !type.equals(Object.class); type = type.getSuperclass()) {
                    ancestorTypes.add(type.getSimpleName());
                }
                List<String> blackList = sources.length == 2 ? (List<String>)sources[1] : Arrays.asList("AbstractNode");
                ancestorTypes.removeAll(blackList);
                return ancestorTypes;
            }
            this.logParameterError(caller, sources, ctx.isJavaScriptContext());
            return this.usage(ctx.isJavaScriptContext());
        }
        catch (IllegalArgumentException e) {
            this.logParameterError(caller, sources, ctx.isJavaScriptContext());
            return this.usage(ctx.isJavaScriptContext());
        }
    }

    @Override
    public String usage(boolean inJavaScriptContext) {
        return inJavaScriptContext ? ERROR_MESSAGE_ANCESTOR_TYPES_JS : ERROR_MESSAGE_ANCESTOR_TYPES;
    }

    @Override
    public String shortDescription() {
        return "Returns the names of the parent classes of the given type";
    }

    @Override
    public String getName() {
        return "ancestor_types()";
    }
}

