/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core.function;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.mozilla.javascript.NativeObject;
import org.mozilla.javascript.ScriptRuntime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.api.config.Settings;
import org.structr.common.error.FrameworkException;
import org.structr.core.GraphObject;
import org.structr.core.GraphObjectMap;
import org.structr.core.app.App;
import org.structr.core.app.StructrApp;
import org.structr.core.entity.AbstractNode;
import org.structr.core.property.EndNodeProperty;
import org.structr.core.property.Property;
import org.structr.core.property.PropertyKey;
import org.structr.core.property.StringProperty;
import org.structr.schema.action.ActionContext;
import org.structr.schema.action.Function;

public class ChangelogFunction
extends Function<Object, Object> {
    public static final String ERROR_MESSAGE_CHANGELOG = "Usage: ${changelog(entity[, resolve=false[, filterKey, filterValue...]])}. Example: ${changelog(current, false, 'verb', 'change', 'timeTo', now)}";
    public static final String ERROR_MESSAGE_CHANGELOG_JS = "Usage: ${{Structr.changelog(entity[, resolve=false[, filterObject]])}}. Example: ${{Structr.changelog(Structr.get('current', false, {verb:\"change\", timeTo: new Date()}))}}";
    private static final Logger logger = LoggerFactory.getLogger((String)ChangelogFunction.class.getName());
    private static final Property<String> changelog_verb = new StringProperty("verb");
    private static final Property<String> changelog_time = new StringProperty("time");
    private static final Property<String> changelog_userId = new StringProperty("userId");
    private static final Property<String> changelog_userName = new StringProperty("userName");
    private static final Property<String> changelog_target = new StringProperty("target");
    private static final Property<AbstractNode> changelog_targetObj = new EndNodeProperty<AbstractNode>("targetObj");
    private static final Property<String> changelog_rel = new StringProperty("rel");
    private static final Property<String> changelog_relId = new StringProperty("relId");
    private static final Property<String> changelog_relDir = new StringProperty("relDir");
    private static final Property<String> changelog_key = new StringProperty("key");
    private static final Property<String> changelog_prev = new StringProperty("prev");
    private static final Property<String> changelog_val = new StringProperty("val");

    @Override
    public String getName() {
        return "changelog()";
    }

    @Override
    public Object apply(ActionContext ctx, Object caller, Object[] sources) throws FrameworkException {
        if (!((Boolean)Settings.ChangelogEnabled.getValue()).booleanValue()) {
            logger.warn("changelog function used even though the changelog is disabled - please check your configuration. (This function might still return results if the changelog was enabled earlier.)");
        }
        if (sources.length >= 1) {
            if (sources[0] instanceof GraphObject) {
                String changelog = ((GraphObject)sources[0]).getProperty(GraphObject.structrChangeLog);
                if (changelog != null && !"".equals(changelog)) {
                    ChangelogFilter changelogFilter = new ChangelogFilter();
                    if (sources.length >= 3 && sources[2] != null) {
                        if (sources[2] instanceof NativeObject) {
                            changelogFilter.processJavaScriptConfigurationObject((NativeObject)sources[2]);
                        } else {
                            int maxLength = sources.length;
                            int i = 2;
                            while (i + 2 <= maxLength) {
                                if (sources[i] != null && sources[i + 1] != null) {
                                    changelogFilter.addFilterEntry(sources[i].toString(), sources[i + 1]);
                                }
                                i += 2;
                            }
                            if (maxLength % 2 == 1 && sources[maxLength - 1] != null) {
                                logger.warn("Ignoring dangling filterKey: {}", sources[maxLength - 1]);
                            }
                        }
                    }
                    if (sources.length >= 2 && Boolean.TRUE.equals(sources[1])) {
                        changelogFilter.setResolveTargets(true);
                    }
                    return changelogFilter.getFilteredChangelog(changelog);
                }
                return new ArrayList();
            }
            logger.warn("First parameter must be of type GraphObject: \"{}\"", sources[0]);
            return this.usage(ctx.isJavaScriptContext());
        }
        this.logParameterError(caller, sources, ctx.isJavaScriptContext());
        return this.usage(ctx.isJavaScriptContext());
    }

    @Override
    public String usage(boolean inJavaScriptContext) {
        return inJavaScriptContext ? ERROR_MESSAGE_CHANGELOG_JS : ERROR_MESSAGE_CHANGELOG;
    }

    @Override
    public String shortDescription() {
        return "Returns the changelog object";
    }

    private class ChangelogFilter {
        private final JsonParser _jsonParser = new JsonParser();
        private final Gson _gson = new GsonBuilder().disableHtmlEscaping().create();
        private final App _app = StructrApp.getInstance();
        private final ArrayList<String> _filterVerbs = new ArrayList();
        private Long _filterTimeFrom = null;
        private Long _filterTimeTo = null;
        private final ArrayList<String> _filterUserId = new ArrayList();
        private final ArrayList<String> _filterUserName = new ArrayList();
        private final ArrayList<String> _filterRelType = new ArrayList();
        private String _filterRelDir = null;
        private final ArrayList<String> _filterTarget = new ArrayList();
        private final ArrayList<String> _filterKey = new ArrayList();
        private boolean _resolveTargets = false;
        private boolean _noFilterConfig = true;

        private ChangelogFilter() {
        }

        public void addFilterEntry(String filterKey, Object filterValue) {
            switch (filterKey) {
                case "verb": {
                    this._filterVerbs.add(filterValue.toString());
                    break;
                }
                case "timeFrom": {
                    this._filterTimeFrom = this.toLong(filterValue);
                    break;
                }
                case "timeTo": {
                    this._filterTimeTo = this.toLong(filterValue);
                    break;
                }
                case "userId": {
                    this._filterUserId.add(filterValue.toString());
                    break;
                }
                case "userName": {
                    this._filterUserName.add(filterValue.toString());
                    break;
                }
                case "relType": {
                    this._filterRelType.add(filterValue.toString());
                    break;
                }
                case "relDir": {
                    this._filterRelDir = filterValue.toString();
                    break;
                }
                case "target": {
                    this._filterTarget.add(filterValue.toString());
                    break;
                }
                case "key": {
                    this._filterKey.add(filterValue.toString());
                    break;
                }
                default: {
                    logger.warn("Unknown filter key: {}", (Object)filterKey);
                }
            }
        }

        public void processJavaScriptConfigurationObject(NativeObject javascriptConfigObject) {
            this.assignStringsIfPresent(javascriptConfigObject.get((Object)"verb"), this._filterVerbs);
            this.assignLongIfPresent(javascriptConfigObject.get((Object)"timeFrom"), this._filterTimeFrom);
            this.assignLongIfPresent(javascriptConfigObject.get((Object)"timeTo"), this._filterTimeTo);
            this.assignStringsIfPresent(javascriptConfigObject.get((Object)"userId"), this._filterUserId);
            this.assignStringsIfPresent(javascriptConfigObject.get((Object)"userName"), this._filterUserName);
            this.assignStringsIfPresent(javascriptConfigObject.get((Object)"relType"), this._filterRelType);
            if (javascriptConfigObject.get((Object)"relDir") != null) {
                this._filterRelDir = javascriptConfigObject.get((Object)"relDir").toString();
            }
            this.assignStringsIfPresent(javascriptConfigObject.get((Object)"target"), this._filterTarget);
            this.assignStringsIfPresent(javascriptConfigObject.get((Object)"key"), this._filterKey);
        }

        private void assignLongIfPresent(Object possibleLong, Long targetLongReference) {
            if (possibleLong != null) {
                targetLongReference = new Double(ScriptRuntime.toNumber((Object)possibleLong)).longValue();
            }
        }

        private void assignStringsIfPresent(Object possibleListOrString, ArrayList<String> targetListReference) {
            if (possibleListOrString != null) {
                if (possibleListOrString instanceof List) {
                    targetListReference.addAll((List)possibleListOrString);
                } else if (possibleListOrString instanceof String) {
                    targetListReference.add((String)possibleListOrString);
                }
            }
        }

        public void setResolveTargets(boolean resolve) {
            this._resolveTargets = resolve;
        }

        public List getFilteredChangelog(String changelog) throws FrameworkException {
            ArrayList<GraphObjectMap> list = new ArrayList<GraphObjectMap>();
            this._noFilterConfig = this._filterVerbs.isEmpty() && this._filterTimeFrom == null && this._filterTimeTo == null && this._filterUserId.isEmpty() && this._filterUserName.isEmpty() && this._filterRelType.isEmpty() && this._filterRelDir == null && this._filterTarget.isEmpty() && this._filterKey.isEmpty();
            block12: for (String entry : changelog.split("\n")) {
                String key;
                JsonObject jsonObj = this._jsonParser.parse(entry).getAsJsonObject();
                String verb = jsonObj.get("verb").getAsString();
                long time = jsonObj.get("time").getAsLong();
                String userId = jsonObj.get("userId").getAsString();
                String userName = jsonObj.get("userName").getAsString();
                String relType = jsonObj.has("rel") ? jsonObj.get("rel").getAsString() : null;
                String relId = jsonObj.has("relId") ? jsonObj.get("relId").getAsString() : null;
                String relDir = jsonObj.has("relDir") ? jsonObj.get("relDir").getAsString() : null;
                String target = jsonObj.has("target") ? jsonObj.get("target").getAsString() : null;
                String string = key = jsonObj.has("key") ? jsonObj.get("key").getAsString() : null;
                if (!this.doesFilterApply(verb, time, userId, userName, relType, relDir, target, key)) continue;
                GraphObjectMap obj = new GraphObjectMap();
                obj.put((PropertyKey)changelog_verb, verb);
                obj.put((PropertyKey)changelog_time, (Object)time);
                obj.put((PropertyKey)changelog_userId, userId);
                obj.put((PropertyKey)changelog_userName, userName);
                switch (verb) {
                    case "create": 
                    case "delete": {
                        obj.put((PropertyKey)changelog_target, target);
                        if (this._resolveTargets) {
                            obj.put((PropertyKey)changelog_targetObj, this._app.getNodeById(target));
                        }
                        list.add(obj);
                        continue block12;
                    }
                    case "link": 
                    case "unlink": {
                        obj.put((PropertyKey)changelog_rel, relType);
                        obj.put((PropertyKey)changelog_relId, relId);
                        obj.put((PropertyKey)changelog_relDir, relDir);
                        obj.put((PropertyKey)changelog_target, target);
                        if (this._resolveTargets) {
                            obj.put((PropertyKey)changelog_targetObj, this._app.getNodeById(target));
                        }
                        list.add(obj);
                        continue block12;
                    }
                    case "change": {
                        obj.put((PropertyKey)changelog_key, key);
                        obj.put((PropertyKey)changelog_prev, this._gson.toJson(jsonObj.get("prev")));
                        obj.put((PropertyKey)changelog_val, this._gson.toJson(jsonObj.get("val")));
                        list.add(obj);
                        continue block12;
                    }
                    default: {
                        logger.warn("Unknown verb in changelog: \"{}\"", (Object)verb);
                    }
                }
            }
            return list;
        }

        public boolean doesFilterApply(String verb, long time, String userId, String userName, String relType, String relDir, String target, String key) {
            return !(!this._noFilterConfig && (!this._filterVerbs.isEmpty() && !this._filterVerbs.contains(verb) || this._filterTimeFrom != null && this._filterTimeFrom > time || this._filterTimeTo != null && this._filterTimeTo < time || !this._filterUserId.isEmpty() && !this._filterUserId.contains(userId) || !this._filterUserName.isEmpty() && !this._filterUserName.contains(userName) || !this._filterRelType.isEmpty() && !this._filterRelType.contains(relType) || this._filterRelDir != null && !this._filterRelDir.equals(relDir) || !this._filterTarget.isEmpty() && !this._filterTarget.contains(target) || !this._filterKey.isEmpty() && !this._filterKey.contains(key)));
        }

        private Long toLong(Object possibleLong) {
            if (possibleLong instanceof Date) {
                return ((Date)possibleLong).getTime();
            }
            if (possibleLong instanceof Number) {
                return ((Number)possibleLong).longValue();
            }
            try {
                return new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ").parse(possibleLong.toString()).getTime();
            }
            catch (ParseException parseException) {
                logger.warn("Cannot convert object to long: {}", possibleLong);
                return null;
            }
        }
    }
}

