/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core.function;

import java.util.Collection;
import java.util.LinkedList;
import org.apache.commons.lang3.StringUtils;
import org.structr.common.error.FrameworkException;
import org.structr.core.function.Functions;
import org.structr.schema.action.ActionContext;
import org.structr.schema.action.Function;

public class CleanFunction
extends Function<Object, Object> {
    public static final String ERROR_MESSAGE_CLEAN = "Usage: ${clean(string)}. Example: ${clean(this.stringWithNonWordChars)}";

    @Override
    public String getName() {
        return "clean()";
    }

    @Override
    public Object apply(ActionContext ctx, Object caller, Object[] sources) throws FrameworkException {
        try {
            if (!this.arrayHasLengthAndAllElementsNotNull(sources, 1)) {
                return null;
            }
            if (sources[0] instanceof Collection) {
                LinkedList<String> cleanList = new LinkedList<String>();
                for (Object obj : (Collection)sources[0]) {
                    if (StringUtils.isBlank((CharSequence)obj.toString())) {
                        cleanList.add("");
                        continue;
                    }
                    cleanList.add(Functions.cleanString(obj));
                }
                return cleanList;
            }
            if (StringUtils.isBlank((CharSequence)sources[0].toString())) {
                return "";
            }
            return Functions.cleanString(sources[0]);
        }
        catch (IllegalArgumentException e) {
            this.logParameterError(caller, sources, ctx.isJavaScriptContext());
            return this.usage(ctx.isJavaScriptContext());
        }
    }

    @Override
    public String usage(boolean inJavaScriptContext) {
        return ERROR_MESSAGE_CLEAN;
    }

    @Override
    public String shortDescription() {
        return "Cleans the given string";
    }
}

