/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core.function;

import org.structr.common.error.FrameworkException;
import org.structr.schema.action.ActionContext;
import org.structr.schema.action.Function;

public class CoalesceFunction
extends Function<Object, Object> {
    public static final String ERROR_MESSAGE_COALESCE = "Usage: ${coalesce(string1, string2...)}. Example: ${coalesce(node.name, node.title, node.id)}";
    public static final String ERROR_MESSAGE_COALESCE_JS = "Usage: ${{Structr.coalesce(string1, string2...)}}. Example: ${{Structr.coalesce(node.name, node.title, node.id)}}";

    @Override
    public String getName() {
        return "coalesace()";
    }

    @Override
    public Object apply(ActionContext ctx, Object caller, Object[] sources) throws FrameworkException {
        if (sources != null) {
            int length = sources.length;
            for (int i = 0; i < length; ++i) {
                if (sources[i] == null || sources[i].equals("___NULL___")) continue;
                return sources[i].toString();
            }
            return null;
        }
        this.logParameterError(caller, sources, ctx.isJavaScriptContext());
        return this.usage(ctx.isJavaScriptContext());
    }

    @Override
    public String usage(boolean inJavaScriptContext) {
        return inJavaScriptContext ? ERROR_MESSAGE_COALESCE_JS : ERROR_MESSAGE_COALESCE;
    }

    @Override
    public String shortDescription() {
        return "Returns the first non-null value in the list of expressions passed to it. In case all arguments are null, null will be returned";
    }
}

