/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core.function;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.structr.common.error.FrameworkException;
import org.structr.schema.action.ActionContext;
import org.structr.schema.action.Function;

public class ComplementFunction
extends Function<Object, Object> {
    public static final String ERROR_MESSAGE_COMPLEMENT = "Usage: ${complement(list1, list2, list3, ...)}. (The resulting list contains no duplicates) Example: ${complement(allUsers, me)} => List of all users except myself";

    @Override
    public String getName() {
        return "complement()";
    }

    @Override
    public Object apply(ActionContext ctx, Object caller, Object[] sources) throws FrameworkException {
        LinkedList resultingList = new LinkedList();
        if (sources[0] instanceof List) {
            resultingList.addAll((List)sources[0]);
            for (int cnt = 1; cnt < sources.length; ++cnt) {
                Object source = sources[cnt];
                if (source instanceof List) {
                    resultingList.removeAll((List)source);
                    continue;
                }
                if (source == null) continue;
                ArrayList<Object> mockList = new ArrayList<Object>();
                mockList.add(source);
                resultingList.removeAll(mockList);
            }
        } else {
            logger.warn("Argument 1 for must be a Collection. Parameters: {}", new Object[]{this.getName(), this.getParametersAsString(sources)});
            return "Argument 1 for complement must be a Collection";
        }
        return resultingList;
    }

    @Override
    public String usage(boolean inJavaScriptContext) {
        return ERROR_MESSAGE_COMPLEMENT;
    }

    @Override
    public String shortDescription() {
        return "";
    }
}

