/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core.function;

import org.structr.common.error.FrameworkException;
import org.structr.core.app.StructrApp;
import org.structr.core.entity.AbstractNode;
import org.structr.schema.action.ActionContext;
import org.structr.schema.action.Function;

public class CreateRelationshipFunction
extends Function<Object, Object> {
    public static final String ERROR_MESSAGE_CREATE_RELATIONSHIP = "Usage: ${create_relationship(from, to, relType)}. Example: ${create_relationship(me, user, 'FOLLOWS')} (Relationshiptype has to exist)";
    public static final String ERROR_MESSAGE_CREATE_RELATIONSHIP_JS = "Usage: ${{Structr.create_relationship(from, to, relType)}}. Example: ${{Structr.create_relationship(Structr.get('me'), user, 'FOLLOWS')}} (Relationshiptype has to exist)";

    @Override
    public String getName() {
        return "create_relationship()";
    }

    @Override
    public Object apply(ActionContext ctx, Object caller, Object[] sources) throws FrameworkException {
        try {
            if (!this.arrayHasLengthAndAllElementsNotNull(sources, 3)) {
                return "";
            }
            Object source = sources[0];
            Object target = sources[1];
            String relType = (String)sources[2];
            AbstractNode sourceNode = null;
            AbstractNode targetNode = null;
            if (!(source instanceof AbstractNode) || !(target instanceof AbstractNode)) {
                logger.warn("Error: entities are not nodes. Parameters: {}", (Object)this.getParametersAsString(sources));
                return "Error: entities are not nodes.";
            }
            sourceNode = (AbstractNode)source;
            targetNode = (AbstractNode)target;
            Class relClass = StructrApp.getConfiguration().getRelationClassForCombinedType(sourceNode.getType(), relType, targetNode.getType());
            if (relClass != null) {
                return StructrApp.getInstance(sourceNode.getSecurityContext()).create(sourceNode, targetNode, relClass);
            }
            logger.warn("Error: Unknown relationship type. Parameters: {}", (Object)this.getParametersAsString(sources));
            return "Error: Unknown relationship type";
        }
        catch (IllegalArgumentException e) {
            this.logParameterError(caller, sources, ctx.isJavaScriptContext());
            return this.usage(ctx.isJavaScriptContext());
        }
    }

    @Override
    public String usage(boolean inJavaScriptContext) {
        return inJavaScriptContext ? ERROR_MESSAGE_CREATE_RELATIONSHIP_JS : ERROR_MESSAGE_CREATE_RELATIONSHIP;
    }

    @Override
    public String shortDescription() {
        return "Creates a relationship of the given type between two entities";
    }
}

