/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core.function;

import org.structr.common.error.FrameworkException;
import org.structr.schema.action.ActionContext;
import org.structr.schema.action.Function;

public class DivFunction
extends Function<Object, Object> {
    public static final String ERROR_MESSAGE_DIV = "Usage: ${div(value1, value2)}. Example: ${div(5, 2)}";

    @Override
    public String getName() {
        return "div()";
    }

    @Override
    public Object apply(ActionContext ctx, Object caller, Object[] sources) throws FrameworkException {
        try {
            if (this.arrayHasLengthAndAllElementsNotNull(sources, 2)) {
                try {
                    return Long.parseLong(sources[0].toString()) / Long.parseLong(sources[1].toString());
                }
                catch (NumberFormatException nfe) {
                    this.logException(nfe, "{}: NumberFormatException in element \"{}\" for parameters: {}", new Object[]{this.getName(), caller, this.getParametersAsString(sources)});
                    return nfe.getMessage();
                }
            }
            if (sources.length > 0 && sources[0] != null) {
                try {
                    return Long.parseLong(sources[0].toString());
                }
                catch (NumberFormatException nfe) {
                    this.logException(nfe, "{}: NumberFormatException in element \"{}\" for parameters: {}", new Object[]{this.getName(), caller, this.getParametersAsString(sources)});
                    return nfe.getMessage();
                }
            }
        }
        catch (IllegalArgumentException e) {
            this.logParameterError(caller, sources, ctx.isJavaScriptContext());
            return this.usage(ctx.isJavaScriptContext());
        }
        return null;
    }

    @Override
    public String usage(boolean inJavaScriptContext) {
        return ERROR_MESSAGE_DIV;
    }

    @Override
    public String shortDescription() {
        return "Integer division, first argument / second argument";
    }
}

