/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core.function;

import java.util.Collection;
import org.apache.commons.lang3.StringUtils;
import org.structr.common.error.FrameworkException;
import org.structr.schema.action.ActionContext;
import org.structr.schema.action.Function;

public class EmptyFunction
extends Function<Object, Object> {
    public static final String ERROR_MESSAGE_EMPTY = "Usage: ${empty(string|array|collection)}. Example: ${if(empty(possibleEmptyString), \"empty\", \"non-empty\")}";

    @Override
    public String getName() {
        return "empty()";
    }

    @Override
    public Object apply(ActionContext ctx, Object caller, Object[] sources) throws FrameworkException {
        if (sources == null) {
            this.logParameterError(caller, sources, ctx.isJavaScriptContext());
            return this.usage(ctx.isJavaScriptContext());
        }
        if (sources.length == 0 || sources[0] == null || StringUtils.isEmpty((CharSequence)sources[0].toString())) {
            return true;
        }
        if (sources[0] instanceof Collection) {
            return ((Collection)sources[0]).isEmpty();
        }
        if (sources[0].getClass().isArray()) {
            return ((Object[])sources[0]).length == 0;
        }
        return false;
    }

    @Override
    public String usage(boolean inJavaScriptContext) {
        return ERROR_MESSAGE_EMPTY;
    }

    @Override
    public String shortDescription() {
        return "Returns true if the given string or collection is null or empty";
    }
}

