/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core.function;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.structr.common.error.FrameworkException;
import org.structr.core.GraphObjectMap;
import org.structr.core.app.StructrApp;
import org.structr.core.property.EnumProperty;
import org.structr.core.property.PropertyKey;
import org.structr.core.property.StringProperty;
import org.structr.schema.ConfigurationProvider;
import org.structr.schema.SchemaHelper;
import org.structr.schema.action.ActionContext;
import org.structr.schema.action.Function;

public class EnumInfoFunction
extends Function<Object, Object> {
    public static final String ERROR_MESSAGE_ENUM_INFO = "Usage: ${enum_info(type, enumProperty[, raw])}. Example ${enum_info('Document', 'documentType')}";
    public static final String ERROR_MESSAGE_ENUM_INFO_JS = "Usage: ${Structr.enum_info(type, enumProperty[, raw])}. Example ${Structr.enum_info('Document', 'documentType')}";

    @Override
    public Object apply(ActionContext ctx, Object caller, Object[] sources) throws FrameworkException {
        try {
            if (this.arrayHasMinLengthAndMaxLengthAndAllElementsNotNull(sources, 2, 3)) {
                ConfigurationProvider config = StructrApp.getConfiguration();
                String typeName = sources[0].toString();
                String enumPropertyName = sources[1].toString();
                boolean rawList = sources.length == 3 ? Boolean.parseBoolean(sources[2].toString()) : false;
                Class type = SchemaHelper.getEntityClassForRawType(typeName);
                if (type != null) {
                    PropertyKey key = config.getPropertyKeyForJSONName(type, enumPropertyName, false);
                    if (key != null) {
                        if (key instanceof EnumProperty) {
                            String formatString = SchemaHelper.getPropertyInfo(ctx.getSecurityContext(), key).get("format").toString();
                            List<String> valueList = Arrays.asList(formatString.replace(" ", "").split(","));
                            if (rawList) {
                                return valueList;
                            }
                            ArrayList<GraphObjectMap> resultList = new ArrayList<GraphObjectMap>();
                            for (String value : valueList) {
                                GraphObjectMap valueMap = new GraphObjectMap();
                                resultList.add(valueMap);
                                valueMap.put((PropertyKey)new StringProperty("value"), value);
                            }
                            return resultList;
                        }
                        logger.warn("Error: Not an Enum property \"{}.{}\"", (Object)typeName, (Object)enumPropertyName);
                        return "Not an Enum property " + typeName + "." + enumPropertyName;
                    }
                    logger.warn("Error: Unknown property \"{}.{}\"", (Object)typeName, (Object)enumPropertyName);
                    return "Unknown property " + typeName + "." + enumPropertyName;
                }
                logger.warn("Error: Unknown type \"{}\"", (Object)typeName);
                return "Unknown type " + typeName;
            }
            this.logParameterError(caller, sources, ctx.isJavaScriptContext());
            return this.usage(ctx.isJavaScriptContext());
        }
        catch (IllegalArgumentException e) {
            this.logParameterError(caller, sources, ctx.isJavaScriptContext());
            return this.usage(ctx.isJavaScriptContext());
        }
    }

    @Override
    public String usage(boolean inJavaScriptContext) {
        return inJavaScriptContext ? ERROR_MESSAGE_ENUM_INFO_JS : ERROR_MESSAGE_ENUM_INFO;
    }

    @Override
    public String shortDescription() {
        return "Returns the enum values as an array";
    }

    @Override
    public String getName() {
        return "enum_info()";
    }
}

