/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core.function;

import org.apache.commons.lang3.StringEscapeUtils;
import org.structr.common.error.FrameworkException;
import org.structr.schema.action.ActionContext;
import org.structr.schema.action.Function;

public class EscapeJavascriptFunction
extends Function<Object, Object> {
    public static final String ERROR_MESSAGE_ESCAPE_JS = "Usage: ${escape_javascript(string)}. Example: ${escape_javascript(this.name)}";

    @Override
    public String getName() {
        return "escape_javascript()";
    }

    @Override
    public Object apply(ActionContext ctx, Object caller, Object[] sources) throws FrameworkException {
        try {
            if (!this.arrayHasLengthAndAllElementsNotNull(sources, 1)) {
                return null;
            }
            return StringEscapeUtils.escapeEcmaScript((String)sources[0].toString());
        }
        catch (IllegalArgumentException e) {
            this.logParameterError(caller, sources, ctx.isJavaScriptContext());
            return this.usage(ctx.isJavaScriptContext());
        }
    }

    @Override
    public String usage(boolean inJavaScriptContext) {
        return ERROR_MESSAGE_ESCAPE_JS;
    }

    @Override
    public String shortDescription() {
        return "Escapes the given string for use with Javascript";
    }
}

