/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core.function;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.structr.api.config.Setting;
import org.structr.api.config.Settings;
import org.structr.common.SecurityContext;
import org.structr.common.error.FrameworkException;
import org.structr.schema.action.ActionContext;
import org.structr.schema.action.Function;
import org.structr.util.AbstractProcess;

public class ExecFunction
extends Function<Object, Object> {
    public static final String ERROR_MESSAGE_EXEC = "Usage: ${exec(fileName [, parameters...]}. Example ${exec('my-script')}";
    public static final String ERROR_MESSAGE_EXEC_JS = "Usage: ${{Structr.exec(fileName [, parameters...]}}. Example ${{Structr.exec('my-script')}}";

    @Override
    public String getName() {
        return "exec()";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object apply(ActionContext ctx, Object caller, Object[] sources) throws FrameworkException {
        if (this.arrayHasMinLengthAndAllElementsNotNull(sources, 1)) {
            String scriptKey = sources[0].toString();
            Setting scriptSetting = Settings.getStringSetting((String[])new String[]{scriptKey});
            if (scriptSetting != null) {
                StringBuilder scriptBuilder = new StringBuilder((String)scriptSetting.getValue());
                if (sources.length > 1) {
                    for (int i = 1; i < sources.length; ++i) {
                        if (sources[i] == null) continue;
                        scriptBuilder.append(" ").append(sources[i].toString());
                    }
                }
                ExecutorService executorService = Executors.newSingleThreadExecutor();
                ScriptingProcess process = new ScriptingProcess(ctx.getSecurityContext(), scriptBuilder.toString());
                try {
                    String string = executorService.submit(process).get();
                    return string;
                }
                catch (InterruptedException | ExecutionException iex) {
                    this.logException(caller, iex, sources);
                }
                finally {
                    executorService.shutdown();
                }
            } else {
                logger.warn("No script found for key \"{}\" in structr.conf, nothing executed.", (Object)scriptKey);
            }
        } else {
            this.logParameterError(caller, sources, ctx.isJavaScriptContext());
        }
        return "";
    }

    @Override
    public String usage(boolean inJavaScriptContext) {
        return inJavaScriptContext ? ERROR_MESSAGE_EXEC_JS : ERROR_MESSAGE_EXEC;
    }

    @Override
    public String shortDescription() {
        return "Calls the given exported / dynamic method on the given entity";
    }

    private static class ScriptingProcess
    extends AbstractProcess<String> {
        private final StringBuilder commandLine = new StringBuilder();

        public ScriptingProcess(SecurityContext securityContext, String commandLine) {
            super(securityContext);
            this.commandLine.append(commandLine);
        }

        @Override
        public StringBuilder getCommandLine() {
            return this.commandLine;
        }

        @Override
        public String processExited(int exitCode) {
            return this.outputStream();
        }

        @Override
        public void preprocess() {
        }
    }
}

