/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core.function;

import java.util.Collection;
import java.util.LinkedList;
import org.structr.common.error.FrameworkException;
import org.structr.core.GraphObject;
import org.structr.core.app.StructrApp;
import org.structr.core.property.PropertyKey;
import org.structr.schema.ConfigurationProvider;
import org.structr.schema.action.ActionContext;
import org.structr.schema.action.Function;

public class ExtractFunction
extends Function<Object, Object> {
    public static final String ERROR_MESSAGE_EXTRACT = "Usage: ${extract(list, propertyName)}. Example: ${extract(this.children, \"amount\")}";

    @Override
    public String getName() {
        return "extract()";
    }

    @Override
    public Object apply(ActionContext ctx, Object caller, Object[] sources) throws FrameworkException {
        try {
            if (sources == null) {
                throw new IllegalArgumentException();
            }
            if (sources.length == 1 && sources[0] instanceof Collection) {
                LinkedList extraction = new LinkedList();
                for (Object obj : (Collection)sources[0]) {
                    if (!(obj instanceof Collection)) continue;
                    extraction.addAll((Collection)obj);
                }
                return extraction;
            }
            if (sources.length == 2) {
                if (sources[0] == null) {
                    return null;
                }
                if (sources[0] instanceof Collection && sources[1] instanceof String) {
                    ConfigurationProvider config = StructrApp.getConfiguration();
                    LinkedList extraction = new LinkedList();
                    String keyName = (String)sources[1];
                    for (Object obj : (Collection)sources[0]) {
                        PropertyKey key;
                        Object value;
                        if (!(obj instanceof GraphObject) || (value = ((GraphObject)obj).getProperty(key = config.getPropertyKeyForJSONName(obj.getClass(), keyName))) == null) continue;
                        extraction.add(value);
                    }
                    return extraction;
                }
            }
        }
        catch (IllegalArgumentException e) {
            this.logParameterError(caller, sources, ctx.isJavaScriptContext());
            return this.usage(ctx.isJavaScriptContext());
        }
        return null;
    }

    @Override
    public String usage(boolean inJavaScriptContext) {
        return ERROR_MESSAGE_EXTRACT;
    }

    @Override
    public String shortDescription() {
        return "Returns a collection of all the elements with a given name from a collection";
    }
}

