/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core.function;

import java.util.Map;
import org.structr.common.SecurityContext;
import org.structr.common.error.FrameworkException;
import org.structr.core.GraphObject;
import org.structr.core.app.App;
import org.structr.core.app.Query;
import org.structr.core.app.StructrApp;
import org.structr.core.converter.PropertyConverter;
import org.structr.core.function.QueryFunction;
import org.structr.core.graph.NodeInterface;
import org.structr.core.property.PropertyKey;
import org.structr.core.property.PropertyMap;
import org.structr.schema.ConfigurationProvider;
import org.structr.schema.action.ActionContext;
import org.structr.schema.action.Function;

public class FindFunction
extends Function<Object, Object>
implements QueryFunction {
    public static final String ERROR_MESSAGE_FIND = "Usage: ${find(type, key, value)}. Example: ${find(\"User\", \"email\", \"tester@test.com\"}";
    public static final String ERROR_MESSAGE_FIND_NO_TYPE_SPECIFIED = "Error in find(): no type specified.";
    public static final String ERROR_MESSAGE_FIND_TYPE_NOT_FOUND = "Error in find(): type not found: ";
    private int start = -1;
    private int end = -1;

    @Override
    public String getName() {
        return "find()";
    }

    @Override
    public Object apply(ActionContext ctx, Object caller, Object[] sources) throws FrameworkException {
        try {
            if (sources == null) {
                throw new IllegalArgumentException();
            }
            SecurityContext securityContext = ctx.getSecurityContext();
            ConfigurationProvider config = StructrApp.getConfiguration();
            App app = StructrApp.getInstance(securityContext);
            Query<? extends NodeInterface> query = app.nodeQuery().sort(GraphObject.createdDate).order(false);
            if (this.start >= 0 && this.end >= 0) {
                int pageSize = this.end - this.start;
                int page = this.start % pageSize;
                query.pageSize(pageSize);
                query.page(page);
            }
            Class type = null;
            if (sources.length >= 1 && sources[0] != null) {
                String typeString = sources[0].toString();
                type = config.getNodeEntityClass(typeString);
                if (type != null) {
                    query.andTypes(type);
                } else {
                    logger.warn("Error in find(): type \"{}\" not found.", (Object)typeString);
                    return ERROR_MESSAGE_FIND_TYPE_NOT_FOUND + typeString;
                }
            }
            if (type == null) {
                logger.warn("Error in find(): no type specified. Parameters: {}", (Object)this.getParametersAsString(sources));
                return ERROR_MESSAGE_FIND_NO_TYPE_SPECIFIED;
            }
            securityContext.ignoreResultCount(true);
            if (sources.length == 2 && sources[1] instanceof Map) {
                query.and(PropertyMap.inputTypeToJavaType(securityContext, type, (Map)sources[1]));
            } else {
                if (sources.length == 2) {
                    if (sources[1] == null) {
                        throw new IllegalArgumentException();
                    }
                    PropertyKey key = config.getPropertyKeyForJSONName(type, "id");
                    query.and(key, sources[1].toString());
                    return query.getFirst();
                }
                int parameter_count = sources.length;
                if (parameter_count % 2 == 0) {
                    throw new FrameworkException(400, "Invalid number of parameters: " + parameter_count + ". Should be uneven: " + ERROR_MESSAGE_FIND);
                }
                for (int c = 1; c < parameter_count; c += 2) {
                    if (sources[c] == null) {
                        throw new IllegalArgumentException();
                    }
                    PropertyKey key = config.getPropertyKeyForJSONName(type, sources[c].toString());
                    if (key == null) continue;
                    PropertyConverter inputConverter = key.inputConverter(securityContext);
                    Object value = sources[c + 1];
                    if (inputConverter != null) {
                        value = inputConverter.convert(value);
                    }
                    query.and(key, value);
                }
            }
            return query.getAsList();
        }
        catch (IllegalArgumentException e) {
            this.logParameterError(caller, sources, ctx.isJavaScriptContext());
            return this.usage(ctx.isJavaScriptContext());
        }
    }

    @Override
    public String usage(boolean inJavaScriptContext) {
        return ERROR_MESSAGE_FIND;
    }

    @Override
    public String shortDescription() {
        return "Returns a collection of entities of the given type from the database, takes optional key/value pairs";
    }

    @Override
    public void setRangeStart(int start) {
        this.start = start;
    }

    @Override
    public void setRangeEnd(int end) {
        this.end = end;
    }
}

