/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core.function;

import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.text.Normalizer;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.structr.common.error.FrameworkException;
import org.structr.common.error.UnlicensedException;
import org.structr.core.GraphObject;
import org.structr.core.function.UnlicensedFunction;
import org.structr.core.parser.AllExpression;
import org.structr.core.parser.AnyExpression;
import org.structr.core.parser.ArrayExpression;
import org.structr.core.parser.BatchExpression;
import org.structr.core.parser.CacheExpression;
import org.structr.core.parser.ConstantExpression;
import org.structr.core.parser.EachExpression;
import org.structr.core.parser.Expression;
import org.structr.core.parser.FilterExpression;
import org.structr.core.parser.FunctionExpression;
import org.structr.core.parser.FunctionValueExpression;
import org.structr.core.parser.GroupExpression;
import org.structr.core.parser.IfExpression;
import org.structr.core.parser.IsExpression;
import org.structr.core.parser.NoneExpression;
import org.structr.core.parser.NullExpression;
import org.structr.core.parser.RootExpression;
import org.structr.core.parser.SliceExpression;
import org.structr.core.parser.ValueExpression;
import org.structr.schema.action.ActionContext;
import org.structr.schema.action.Function;

public class Functions {
    private static final Map<String, Function<Object, Object>> functions = new LinkedHashMap<String, Function<Object, Object>>();
    public static final String NULL_STRING = "___NULL___";

    public static void put(boolean licensed, int edition, String name, Function<Object, Object> function) {
        if (licensed) {
            functions.put(name, function);
        } else {
            functions.put(name, new UnlicensedFunction(name, edition));
        }
    }

    public static Set<String> getNames() {
        return new LinkedHashSet<String>(functions.keySet());
    }

    public static Function<Object, Object> get(String name) {
        return functions.get(name);
    }

    public static Collection<Function<Object, Object>> getFunctions() {
        return new LinkedList<Function<Object, Object>>(functions.values());
    }

    public static Object evaluate(ActionContext actionContext, GraphObject entity, String expression) throws FrameworkException, UnlicensedException {
        String expressionWithoutNewlines = expression.replace('\n', ' ').replace('\r', ' ');
        StreamTokenizer tokenizer = new StreamTokenizer(new StringReader(expressionWithoutNewlines));
        tokenizer.eolIsSignificant(true);
        tokenizer.ordinaryChar(46);
        tokenizer.wordChars(95, 95);
        tokenizer.wordChars(46, 46);
        tokenizer.wordChars(33, 33);
        RootExpression root = new RootExpression();
        Expression current = root;
        Expression next = null;
        String lastToken = null;
        int token = 0;
        int level = 0;
        block12: while (token != -1) {
            token = Functions.nextToken(tokenizer);
            switch (token) {
                case -1: {
                    continue block12;
                }
                case 10: {
                    continue block12;
                }
                case -2: {
                    if (current == null) {
                        throw new FrameworkException(422, "Invalid expression: mismatched opening bracket before NUMBER");
                    }
                    next = new ConstantExpression(tokenizer.nval);
                    current.add(next);
                    lastToken = lastToken + "NUMBER";
                    continue block12;
                }
                case -3: {
                    if (current == null) {
                        throw new FrameworkException(422, "Invalid expression: mismatched opening bracket before " + tokenizer.sval);
                    }
                    next = Functions.checkReservedWords(tokenizer.sval);
                    Expression previousExpression = current.getPrevious();
                    if (tokenizer.sval.startsWith(".") && previousExpression != null && previousExpression instanceof FunctionExpression && next instanceof ValueExpression) {
                        FunctionExpression previousFunctionExpression = (FunctionExpression)previousExpression;
                        ValueExpression valueExpression = (ValueExpression)next;
                        current.replacePrevious(new FunctionValueExpression(previousFunctionExpression, valueExpression));
                    } else {
                        current.add(next);
                    }
                    lastToken = tokenizer.sval;
                    continue block12;
                }
                case 40: {
                    if ((current == null || current instanceof RootExpression) && next == null || current == next) {
                        next = new GroupExpression();
                        current.add(next);
                    }
                    current = next;
                    lastToken = lastToken + "(";
                    ++level;
                    continue block12;
                }
                case 41: {
                    if (current == null) {
                        throw new FrameworkException(422, "Invalid expression: mismatched opening bracket before " + lastToken);
                    }
                    if ((current = current.getParent()) == null) {
                        throw new FrameworkException(422, "Invalid expression: mismatched closing bracket after " + lastToken);
                    }
                    lastToken = lastToken + ")";
                    --level;
                    continue block12;
                }
                case 91: {
                    next = new ArrayExpression();
                    current.add(next);
                    current = next;
                    lastToken = lastToken + "[";
                    ++level;
                    continue block12;
                }
                case 93: {
                    if (current == null) {
                        throw new FrameworkException(422, "Invalid expression: mismatched closing bracket before " + lastToken);
                    }
                    if ((current = current.getParent()) == null) {
                        throw new FrameworkException(422, "Invalid expression: mismatched closing bracket after " + lastToken);
                    }
                    lastToken = lastToken + "]";
                    --level;
                    continue block12;
                }
                case 59: {
                    next = null;
                    lastToken = lastToken + ";";
                    continue block12;
                }
                case 44: {
                    next = current;
                    lastToken = lastToken + ",";
                    continue block12;
                }
            }
            if (current == null) {
                throw new FrameworkException(422, "Invalid expression: mismatched opening bracket before " + tokenizer.sval);
            }
            current.add(new ConstantExpression((Object)tokenizer.sval));
            lastToken = tokenizer.sval;
        }
        if (level > 0) {
            throw new FrameworkException(422, "Invalid expression: mismatched closing bracket after " + lastToken);
        }
        return ((Expression)root).evaluate(actionContext, entity);
    }

    public static String cleanString(Object input) {
        if (input == null) {
            return "";
        }
        String normalized = Normalizer.normalize(input.toString(), Normalizer.Form.NFD).replaceAll("\\<", "").replaceAll("\\>", "").replaceAll("\\.", "").replaceAll("\\'", "-").replaceAll("\\?", "").replaceAll("\\(", "").replaceAll("\\)", "").replaceAll("\\{", "").replaceAll("\\}", "").replaceAll("\\[", "").replaceAll("\\]", "").replaceAll("\\+", "-").replaceAll("/", "-").replaceAll("\u2013", "-").replaceAll("\\\\", "-").replaceAll("\\|", "-").replaceAll("'", "-").replaceAll("!", "").replaceAll(",", "").replaceAll("-", " ").replaceAll("_", " ").replaceAll("`", "-");
        String result = normalized.replaceAll("-", " ");
        result = StringUtils.normalizeSpace((String)result.toLowerCase());
        result = result.replaceAll("[^\\p{ASCII}]", "").replaceAll("\\p{P}", "-").replaceAll("\\-(\\s+\\-)+", "-");
        result = result.replaceAll(" ", "-");
        return result;
    }

    private static Expression checkReservedWords(String word) throws FrameworkException {
        if (word == null) {
            return new NullExpression();
        }
        switch (word) {
            case "cache": {
                return new CacheExpression();
            }
            case "true": {
                return new ConstantExpression(true);
            }
            case "false": {
                return new ConstantExpression(false);
            }
            case "if": {
                return new IfExpression();
            }
            case "is": {
                return new IsExpression();
            }
            case "each": {
                return new EachExpression();
            }
            case "filter": {
                return new FilterExpression();
            }
            case "slice": {
                return new SliceExpression();
            }
            case "batch": {
                return new BatchExpression();
            }
            case "data": {
                return new ValueExpression("data");
            }
            case "any": {
                return new AnyExpression();
            }
            case "all": {
                return new AllExpression();
            }
            case "none": {
                return new NoneExpression();
            }
            case "null": {
                return new ConstantExpression((Object)NULL_STRING);
            }
            case "___NULL___": {
                return new ConstantExpression((Object)NULL_STRING);
            }
        }
        Function<Object, Object> function = Functions.get(word);
        if (function != null) {
            return new FunctionExpression(word, function);
        }
        return new ValueExpression(word);
    }

    private static int nextToken(StreamTokenizer tokenizer) {
        try {
            return tokenizer.nextToken();
        }
        catch (IOException iOException) {
            return -1;
        }
    }
}

