/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core.function;

import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.structr.common.SecurityContext;
import org.structr.common.error.FrameworkException;
import org.structr.core.GraphObject;
import org.structr.core.GraphObjectMap;
import org.structr.core.app.StructrApp;
import org.structr.core.converter.PropertyConverter;
import org.structr.core.property.PropertyKey;
import org.structr.schema.action.ActionContext;
import org.structr.schema.action.Function;

public class GetFunction
extends Function<Object, Object> {
    public static final String ERROR_MESSAGE_GET = "Usage: ${get(entity, propertyKey)}. Example: ${get(this, \"children\")}";
    public static final String ERROR_MESSAGE_GET_ENTITY = "Cannot evaluate first argument to entity, must be entity or single element list of entities.";

    @Override
    public String getName() {
        return "get()";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Object apply(ActionContext ctx, Object caller, Object[] sources) throws FrameworkException {
        SecurityContext securityContext = ctx.getSecurityContext();
        try {
            List list;
            int size;
            if (!this.arrayHasLengthAndAllElementsNotNull(sources, 2)) {
                return "";
            }
            String keyName = sources[1].toString();
            GraphObject dataObject = null;
            if (sources[0] instanceof GraphObject) {
                dataObject = (GraphObject)sources[0];
            }
            if (sources[0] instanceof List && (size = (list = (List)sources[0]).size()) == 1) {
                Object e = list.get(0);
                if (e == null) return "get(): first element of collection is null.";
                if (!(e instanceof GraphObject)) return "get(): first element of collection is of type " + e.getClass() + " which is not supported.";
                dataObject = (GraphObject)list.get(0);
            }
            if (sources[0] instanceof Map && !(sources[0] instanceof GraphObjectMap)) {
                Map map = (Map)sources[0];
                return map.get(keyName);
            }
            if (sources[0] instanceof HttpServletRequest) {
                HttpServletRequest request = (HttpServletRequest)sources[0];
                return request.getParameter(keyName);
            }
            if (dataObject == null) return ERROR_MESSAGE_GET_ENTITY;
            PropertyKey key = StructrApp.getConfiguration().getPropertyKeyForJSONName(dataObject.getClass(), keyName);
            if (key == null) return "";
            PropertyConverter inputConverter = key.inputConverter(securityContext);
            Object t = dataObject.getProperty(key);
            if (inputConverter == null) return dataObject.getProperty(key);
            return inputConverter.revert(t);
        }
        catch (IllegalArgumentException e) {
            this.logParameterError(caller, sources, ctx.isJavaScriptContext());
            return this.usage(ctx.isJavaScriptContext());
        }
    }

    @Override
    public String usage(boolean inJavaScriptContext) {
        return ERROR_MESSAGE_GET;
    }

    @Override
    public String shortDescription() {
        return "Returns the value with the given name of the given entity, or an empty string";
    }
}

