/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core.function;

import org.structr.common.error.FrameworkException;
import org.structr.core.entity.AbstractNode;
import org.structr.core.entity.AbstractRelationship;
import org.structr.schema.action.ActionContext;
import org.structr.schema.action.Function;

public class HasIncomingRelationshipFunction
extends Function<Object, Object> {
    public static final String ERROR_MESSAGE_HAS_INCOMING_RELATIONSHIP = "Usage: ${has_incoming_relationship(from, to [, relType])}. Example: ${has_incoming_relationship(me, user, 'FOLLOWS')}";
    public static final String ERROR_MESSAGE_HAS_INCOMING_RELATIONSHIP_JS = "Usage: ${{Structr.has_incoming_relationship(from, to [, relType])}}. Example: ${{Structr.has_incoming_relationship(Structr.get('me'), user, 'FOLLOWS')}}";

    @Override
    public String getName() {
        return "has_incoming_relationship()";
    }

    @Override
    public Object apply(ActionContext ctx, Object caller, Object[] sources) throws FrameworkException {
        if (this.arrayHasMinLengthAndMaxLengthAndAllElementsNotNull(sources, 2, 3)) {
            Object source = sources[0];
            Object target = sources[1];
            AbstractNode sourceNode = null;
            AbstractNode targetNode = null;
            if (!(source instanceof AbstractNode) || !(target instanceof AbstractNode)) {
                logger.warn("Error: entities are not nodes. Parameters: {}", (Object)this.getParametersAsString(sources));
                return "Error: entities are not nodes.";
            }
            sourceNode = (AbstractNode)source;
            targetNode = (AbstractNode)target;
            if (sources.length == 2) {
                for (AbstractRelationship rel : sourceNode.getIncomingRelationships()) {
                    Object t;
                    Object s = rel.getSourceNode();
                    if (!(s != null & (t = rel.getTargetNode()) != null) || !s.equals(targetNode) || !t.equals(sourceNode)) continue;
                    return true;
                }
            } else if (sources.length == 3) {
                String relType = (String)sources[2];
                for (AbstractRelationship rel : sourceNode.getIncomingRelationships()) {
                    Object t;
                    Object s = rel.getSourceNode();
                    if (!(s != null & (t = rel.getTargetNode()) != null) || !rel.getRelType().name().equals(relType) || !s.equals(targetNode) || !t.equals(sourceNode)) continue;
                    return true;
                }
            }
        } else {
            this.logParameterError(caller, sources, ctx.isJavaScriptContext());
        }
        return false;
    }

    @Override
    public String usage(boolean inJavaScriptContext) {
        return inJavaScriptContext ? ERROR_MESSAGE_HAS_INCOMING_RELATIONSHIP_JS : ERROR_MESSAGE_HAS_INCOMING_RELATIONSHIP;
    }

    @Override
    public String shortDescription() {
        return "Returns true if the given entity has incoming relationships of the given type";
    }
}

