/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core.function;

import org.structr.common.error.FrameworkException;
import org.structr.core.entity.AbstractNode;
import org.structr.core.entity.AbstractRelationship;
import org.structr.schema.action.ActionContext;
import org.structr.schema.action.Function;

public class HasRelationshipFunction
extends Function<Object, Object> {
    public static final String ERROR_MESSAGE_HAS_RELATIONSHIP = "Usage: ${has_relationship(entity1, entity2 [, relType])}. Example: ${has_relationship(me, user, 'FOLLOWS')} (ignores direction of the relationship)";
    public static final String ERROR_MESSAGE_HAS_RELATIONSHIP_JS = "Usage: ${{Structr.has_relationship(entity1, entity2 [, relType])}}. Example: ${{Structr.has_relationship(Structr.get('me'), user, 'FOLLOWS')}} (ignores direction of the relationship)";

    @Override
    public String getName() {
        return "has_relationship()";
    }

    @Override
    public Object apply(ActionContext ctx, Object caller, Object[] sources) throws FrameworkException {
        if (this.arrayHasMinLengthAndMaxLengthAndAllElementsNotNull(sources, 2, 3)) {
            Object source = sources[0];
            Object target = sources[1];
            AbstractNode sourceNode = null;
            AbstractNode targetNode = null;
            if (!(source instanceof AbstractNode) || !(target instanceof AbstractNode)) {
                logger.warn("Error: entities are not nodes. Parameters: {}", (Object)this.getParametersAsString(sources));
                return "Error: entities are not nodes.";
            }
            sourceNode = (AbstractNode)source;
            targetNode = (AbstractNode)target;
            if (sources.length == 2) {
                for (AbstractRelationship rel : sourceNode.getRelationships()) {
                    Object t;
                    Object s = rel.getSourceNode();
                    if (!(s != null & (t = rel.getTargetNode()) != null) || (!s.equals(sourceNode) || !t.equals(targetNode)) && (!s.equals(targetNode) || !t.equals(sourceNode))) continue;
                    return true;
                }
            } else if (sources.length == 3) {
                String relType = (String)sources[2];
                for (AbstractRelationship rel : sourceNode.getRelationships()) {
                    Object t;
                    Object s = rel.getSourceNode();
                    if (!(s != null & (t = rel.getTargetNode()) != null) || !rel.getRelType().name().equals(relType) || (!s.equals(sourceNode) || !t.equals(targetNode)) && (!s.equals(targetNode) || !t.equals(sourceNode))) continue;
                    return true;
                }
            }
        } else {
            this.logParameterError(caller, sources, ctx.isJavaScriptContext());
        }
        return false;
    }

    @Override
    public String usage(boolean inJavaScriptContext) {
        return inJavaScriptContext ? ERROR_MESSAGE_HAS_RELATIONSHIP_JS : ERROR_MESSAGE_HAS_RELATIONSHIP;
    }

    @Override
    public String shortDescription() {
        return "Returns true if the given entity has relationships of the given type";
    }
}

