/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core.function;

import org.structr.common.AccessMode;
import org.structr.common.Permission;
import org.structr.common.Permissions;
import org.structr.common.SecurityContext;
import org.structr.common.error.FrameworkException;
import org.structr.core.entity.AbstractNode;
import org.structr.core.entity.Principal;
import org.structr.schema.action.ActionContext;
import org.structr.schema.action.Function;

public class IsAllowedFunction
extends Function<Object, Object> {
    public static final String ERROR_MESSAGE_IS_ALLOWED = "Usage: ${is_allowed(principal, node, permissions)}. Example: ${is_allowed(me, this, 'write, delete'))}";
    public static final String ERROR_MESSAGE_IS_ALLOWED_JS = "Usage: ${{Structr.is_allowed(principal, node, permissions)}}. Example: ${{Structr.is_allowed(Structr.('me'), Structr.this, 'write, delete'))}}";

    @Override
    public String getName() {
        return "is_allowed()";
    }

    @Override
    public Object apply(ActionContext ctx, Object caller, Object[] sources) throws FrameworkException {
        try {
            if (!this.arrayHasLengthAndAllElementsNotNull(sources, 3)) {
                return false;
            }
            if (sources[0] instanceof Principal) {
                Principal principal = (Principal)sources[0];
                if (sources[1] instanceof AbstractNode) {
                    AbstractNode node = (AbstractNode)sources[1];
                    if (sources[2] instanceof String) {
                        String[] parts = ((String)sources[2]).split("[,]+");
                        boolean allowed = true;
                        for (String part : parts) {
                            String trimmedPart = part.trim();
                            if (trimmedPart.length() <= 0) continue;
                            Permission permission = Permissions.valueOf(trimmedPart);
                            if (permission != null) {
                                allowed &= node.isGranted(permission, SecurityContext.getInstance(principal, AccessMode.Backend));
                                continue;
                            }
                            logger.warn("Error: unknown permission \"{}\". Parameters: {}", new Object[]{trimmedPart, this.getParametersAsString(sources)});
                            return "Error: unknown permission " + trimmedPart;
                        }
                        return allowed;
                    }
                    logger.warn("Error: third argument is not a string. Parameters: {}", (Object)this.getParametersAsString(sources));
                    return "Error: third argument is not a string.";
                }
                logger.warn("Error: second argument is not a node. Parameters: {}", (Object)this.getParametersAsString(sources));
                return "Error: second argument is not a node.";
            }
            logger.warn("Error: first argument is not of type Principal. Parameters: {}", (Object)this.getParametersAsString(sources));
            return "Error: first argument is not of type Principal.";
        }
        catch (IllegalArgumentException e) {
            this.logParameterError(caller, sources, ctx.isJavaScriptContext());
            return this.usage(ctx.isJavaScriptContext());
        }
    }

    @Override
    public String usage(boolean inJavaScriptContext) {
        return inJavaScriptContext ? ERROR_MESSAGE_IS_ALLOWED_JS : ERROR_MESSAGE_IS_ALLOWED;
    }

    @Override
    public String shortDescription() {
        return "Returns whether the principal has all of the permission(s) on the given node.";
    }
}

