/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core.function;

import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import org.structr.common.error.FrameworkException;
import org.structr.core.GraphObject;
import org.structr.core.GraphObjectMap;
import org.structr.core.property.PropertyKey;
import org.structr.schema.action.ActionContext;
import org.structr.schema.action.Function;

public class KeysFunction
extends Function<Object, Object> {
    public static final String ERROR_MESSAGE_KEYS = "Usage: ${keys(entity [, viewName])}. Example: ${keys(this, \"ui\")}";
    public static final String ERROR_MESSAGE_KEYS_JS = "Usage: ${{Structr.keys(entity [, viewName])}}. Example: ${{Structr.keys(this, \"ui\")}}";

    @Override
    public String getName() {
        return "keys()";
    }

    @Override
    public Object apply(ActionContext ctx, Object caller, Object[] sources) throws FrameworkException {
        try {
            if (sources == null) {
                throw new IllegalArgumentException();
            }
            if (sources.length == 2 && sources[0] != null && sources[0] instanceof GraphObject && sources[1] != null) {
                LinkedHashSet<String> keys = new LinkedHashSet<String>();
                GraphObject source = (GraphObject)sources[0];
                for (PropertyKey key : source.getPropertyKeys(sources[1].toString())) {
                    keys.add(key.jsonName());
                }
                return new LinkedList(keys);
            }
            if (sources.length == 1 && sources[0] != null && sources[0] instanceof GraphObjectMap) {
                return new LinkedList(((GraphObjectMap)sources[0]).keySet());
            }
            if (sources.length == 1 && sources[0] != null && sources[0] instanceof Map) {
                return new LinkedList(((Map)sources[0]).keySet());
            }
            return null;
        }
        catch (IllegalArgumentException e) {
            this.logParameterError(caller, sources, ctx.isJavaScriptContext());
            return this.usage(ctx.isJavaScriptContext());
        }
    }

    @Override
    public String usage(boolean inJavaScriptContext) {
        return inJavaScriptContext ? ERROR_MESSAGE_KEYS_JS : ERROR_MESSAGE_KEYS;
    }

    @Override
    public String shortDescription() {
        return "Returns the property keys of the given entity";
    }
}

