/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core.function;

import java.util.List;
import org.structr.common.error.FrameworkException;
import org.structr.schema.action.ActionContext;
import org.structr.schema.action.Function;

public class LastFunction
extends Function<Object, Object> {
    public static final String ERROR_MESSAGE_LAST = "Usage: ${last(collection)}. Example: ${last(this.children)}";

    @Override
    public String getName() {
        return "last()";
    }

    @Override
    public Object apply(ActionContext ctx, Object caller, Object[] sources) throws FrameworkException {
        try {
            Object[] arr;
            if (!this.arrayHasLengthAndAllElementsNotNull(sources, 1)) {
                return null;
            }
            if (sources[0] instanceof List && !((List)sources[0]).isEmpty()) {
                List list = (List)sources[0];
                return list.get(list.size() - 1);
            }
            if (sources[0].getClass().isArray() && (arr = (Object[])sources[0]).length > 0) {
                return arr[arr.length - 1];
            }
        }
        catch (IllegalArgumentException e) {
            this.logParameterError(caller, sources, ctx.isJavaScriptContext());
            return this.usage(ctx.isJavaScriptContext());
        }
        return null;
    }

    @Override
    public String usage(boolean inJavaScriptContext) {
        return ERROR_MESSAGE_LAST;
    }

    @Override
    public String shortDescription() {
        return "Returns the last element of the given collection";
    }
}

