/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core.function;

import java.util.ArrayList;
import java.util.Collection;
import org.structr.common.error.FrameworkException;
import org.structr.schema.action.ActionContext;
import org.structr.schema.action.Function;

public class MergeFunction
extends Function<Object, Object> {
    public static final String ERROR_MESSAGE_MERGE = "Usage: ${merge(list1, list2, list3, ...)}. Example: ${merge(this.children, this.siblings)}";

    @Override
    public String getName() {
        return "merge()";
    }

    @Override
    public Object apply(ActionContext ctx, Object caller, Object[] sources) throws FrameworkException {
        ArrayList<Object> list = new ArrayList<Object>();
        for (Object source : sources) {
            if (source instanceof Collection) {
                for (Object obj : (Collection)source) {
                    if (obj == null) continue;
                    list.add(obj);
                }
                continue;
            }
            if (source == null) continue;
            list.add(source);
        }
        return list;
    }

    @Override
    public String usage(boolean inJavaScriptContext) {
        return ERROR_MESSAGE_MERGE;
    }

    @Override
    public String shortDescription() {
        return "Merges the given collections / objects into a single collection";
    }
}

